/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Monitoring;

import Alachisoft.NCache.Common.AppUtil;
import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import Alachisoft.NCache.Common.Exceptions.ManagementException;
import Alachisoft.NCache.Common.Monitoring.Category;
import Alachisoft.NCache.Common.Monitoring.Counters;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class MonitoringConfigManager {
    static String DIRNAME = "config";
    static String FILENAME = "monitoring.ncconf";
    static String c_configDir = DIRNAME;
    static String c_configFileName = FILENAME;
    static String ENDSTRING = "\r\n";
    static Object _lock = new Object();
    static Counters _configuration;
    private static boolean _isConfigFileFound;

    public boolean getCongigFile() {
        return _isConfigFileFound;
    }

    public void setConfigFile(boolean value) {
        _isConfigFileFound = value;
    }

    public MonitoringConfigManager() throws ManagementException, Exception {
        this.LoadConfiguration();
    }

    private void LoadConfiguration() throws ManagementException, Exception {
        try {
            this.CombinePath();
            File file = new File(c_configFileName);
            if (!file.exists()) {
                this.setConfigFile(false);
                if (_configuration == null) {
                    _configuration = new Counters();
                }
            } else {
                this.setConfigFile(true);
                this.LoadXml();
            }
        }
        catch (ManagementException ex) {
            c_configFileName = "";
            throw ex;
        }
        catch (Exception ex) {
            c_configFileName = "";
            throw ex;
        }
    }

    public Category GetCategory(String categoryName) {
        if (_configuration != null) {
            for (Category category : _configuration.getCategory()) {
                if (!category.getName().equals(categoryName)) continue;
                return category;
            }
        }
        return null;
    }

    private void LoadXml() throws Exception {
        int i;
        if (c_configFileName == null) {
            this.CombinePath();
        }
        ConfigurationBuilder configBuilder = new ConfigurationBuilder(c_configFileName);
        configBuilder.RegisterRootConfigurationObject(Counters.class);
        configBuilder.ReadConfiguration();
        Counters counterConfiguration = null;
        Object[] configuration = configBuilder.getConfiguration();
        if (configuration != null && configuration.length > 0 && (i = 0) < configuration.length) {
            counterConfiguration = (Counters)configuration[i];
        }
        if ((_configuration = counterConfiguration) == null) {
            _configuration = new Counters();
        }
    }

    private String ToXml() throws Exception {
        StringBuilder sb = new StringBuilder();
        Object[] configuration = new Object[]{_configuration};
        ConfigurationBuilder cfgBuilder = new ConfigurationBuilder(configuration);
        cfgBuilder.RegisterRootConfigurationObject(Counters.class);
        sb.append(cfgBuilder.GetXmlString());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveConfiguration() throws ManagementException, IOException {
        if (c_configFileName == null || c_configFileName == "") {
            this.CombinePath();
        }
        File fs = null;
        OutputStreamWriter fw = null;
        Object object = _lock;
        synchronized (object) {
            try {
                fs = new File(c_configFileName);
                if (!fs.exists()) {
                    fs.createNewFile();
                }
                fw = new FileWriter(fs);
                fw.write(this.ToXml());
                fw.flush();
            }
            catch (Exception e) {
                throw new ManagementException(e.getMessage(), e);
            }
            finally {
                if (fw != null) {
                    fw.close();
                }
            }
        }
    }

    public void CombinePath() throws ManagementException {
        c_configDir = AppUtil.getInstallDir();
        if (c_configDir == null || c_configDir.length() == 0) {
            throw new ManagementException("Missing installation folder information");
        }
        c_configDir = c_configDir + File.separator + DIRNAME;
        c_configFileName = c_configDir + File.separator + FILENAME;
    }

    static {
        _isConfigFileFound = true;
    }
}

