/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Net;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;

public class DnsCache {
    private static HashMap _fwdMap = new HashMap();
    private static HashMap _bckMap = new HashMap();

    public static InetAddress ResolveName(String hostname) throws UnknownHostException {
        InetAddress[] ie;
        if (!_fwdMap.containsKey(hostname = hostname.toLowerCase()) && (ie = InetAddress.getAllByName(hostname)) != null && ie.length > 0) {
            _fwdMap.put(hostname, ie[0]);
            _bckMap.put(ie[0], hostname);
        }
        return _fwdMap.get(hostname) instanceof InetAddress ? _fwdMap.get(hostname) : null;
    }

    public static String ResolveAddress(String address) throws UnknownHostException {
        try {
            return InetAddress.getByName(address).getHostAddress();
        }
        catch (RuntimeException runtimeException) {
            return null;
        }
    }

    public static String ResolveAddress(InetAddress address) throws UnknownHostException {
        if (!_bckMap.containsKey(address)) {
            InetAddress ie = InetAddress.getByAddress(address.getAddress());
            String hostname = ie.getHostName();
            if ((hostname = hostname.replace("is~", "")).indexOf(46) > 0) {
                hostname = hostname.substring(0, hostname.indexOf(46));
            }
            _bckMap.put(address, hostname);
            _fwdMap.put(ie.getHostName(), address);
        }
        return _bckMap.get(address) instanceof String ? _bckMap.get(address) : null;
    }

    public static void FlushCache() {
        _fwdMap.clear();
        _bckMap.clear();
    }
}

