/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common;

import Alachisoft.NCache.Common.BridgeServicePropValues;
import Alachisoft.NCache.Common.Net.Helper;
import Alachisoft.NCache.Common.ServicePropValues;
import java.net.InetAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class PortPool {
    private static PortPool defaultPool = null;
    private static String serverType = "";
    int jmx = -1;
    int snmp = -1;
    int snmpPortPool = -1;
    int jmxPortPool = -1;
    int snmpClient = -1;
    Map<String, Integer> snmpPool = Collections.synchronizedMap(new HashMap());
    Map jmxPool = Collections.synchronizedMap(new HashMap());

    PortPool() {
        if (serverType.equals("CacheServer")) {
            if (ServicePropValues.SNMP_PORT != null) {
                this.snmp = Integer.parseInt(ServicePropValues.SNMP_PORT);
            }
            if (ServicePropValues.JMXServer_PORT != null) {
                this.jmx = Integer.parseInt(ServicePropValues.JMXServer_PORT);
            }
            this.snmpPortPool = ServicePropValues.SNMP_POOL != null ? Integer.parseInt(ServicePropValues.SNMP_POOL) : 10100;
            this.jmxPortPool = ServicePropValues.JMX__POOL != null ? Integer.parseInt(ServicePropValues.JMX__POOL) : this.snmpPortPool + 5000;
        } else {
            if (BridgeServicePropValues.getJvBRIDGE_SNMP_PORT() != null) {
                this.snmp = Integer.parseInt(BridgeServicePropValues.getJvBRIDGE_SNMP_PORT());
            }
            if (BridgeServicePropValues.getJvBRIDGE_JMXServer_PORT() != null) {
                this.jmx = Integer.parseInt(BridgeServicePropValues.getJvBRIDGE_JMXServer_PORT());
            }
            this.snmpPortPool = BridgeServicePropValues.getJvBRIDGE_SNMP_POOL() != null ? Integer.parseInt(BridgeServicePropValues.getJvBRIDGE_SNMP_POOL()) : 20100;
            this.jmxPortPool = BridgeServicePropValues.getJvBRIDGE_JMX__POOL() != null ? Integer.parseInt(BridgeServicePropValues.getJvBRIDGE_JMX__POOL()) : this.snmpPortPool + 5000;
        }
    }

    public static void setServerType(String serverType) {
        PortPool.serverType = serverType;
    }

    public static PortPool getInstance() {
        if (defaultPool == null) {
            defaultPool = new PortPool();
        }
        return defaultPool;
    }

    public int getNextSNMPPort(String cacheName, InetAddress addr) {
        InetAddress address;
        InetAddress inetAddress = address = addr == null ? ServicePropValues.getStatsServerIp() : addr;
        if (this.snmpPool.containsKey(cacheName)) {
            return this.snmpPool.get(cacheName);
        }
        while (this.snmpPortPool < this.jmxPortPool) {
            if (!this.snmpPool.containsValue(this.snmpPortPool) && Helper.isPortFree(this.snmpPortPool, address)) {
                this.snmpPool.put(cacheName, this.snmpPortPool);
                ++this.snmpPortPool;
                return this.snmpPortPool - 1;
            }
            ++this.snmpPortPool;
        }
        return 0;
    }

    public int getNextSNMPPort(String cacheName) {
        return this.getNextSNMPPort(cacheName, null);
    }

    public void assignPort(String cacheName, int port) {
        if (this.snmpPool.containsKey(cacheName) || this.snmpPool.containsValue(port)) {
            throw new IllegalArgumentException("Either " + cacheName + " already exists in pool or port " + port + " respecified");
        }
        this.snmpPool.put(cacheName, port);
    }

    public void disposeSNMPPort(String cacheName) {
        if (this.snmpPool.containsKey(cacheName)) {
            this.snmpPortPool = this.snmpPool.get(cacheName);
        }
        this.snmpPool.remove(cacheName);
    }

    public Map<String, Integer> getSNMPMap() {
        return Collections.unmodifiableMap(this.snmpPool);
    }

    public Integer getSNMPPort(String cacheName) {
        return this.snmpPool.get(cacheName);
    }

    public int getJMXPort() {
        return this.getJMXPort(null);
    }

    public int getJMXPort(InetAddress addr) {
        InetAddress address;
        InetAddress inetAddress = address = addr == null ? ServicePropValues.getStatsServerIp() : addr;
        if (this.jmx != -1 && Helper.isPortFree(this.jmx, address)) {
            return this.jmx;
        }
        return Helper.getFreePort(address);
    }
}

