/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.RPCFramework;

import Alachisoft.NCache.Common.RPCFramework.IRPCTargetObject;
import Alachisoft.NCache.Common.RPCFramework.ITargetMethod;
import java.util.HashMap;
import java.util.Map;

public class RPCMethodCache<TargetObject> {
    private IRPCTargetObject<TargetObject> _targetObject;
    private Map<String, ITargetMethod> _cache = new HashMap<String, ITargetMethod>();

    public RPCMethodCache(IRPCTargetObject<TargetObject> targetObject) {
        this._targetObject = targetObject;
        this.PopulateCache();
    }

    private static String GetCacheKey(String methodName, int overload) {
        return methodName + "$" + overload;
    }

    private void PopulateCache() {
        if (this._targetObject != null) {
            ITargetMethod[] methods = this._targetObject.GetAllMethods();
            for (int i = 0; i < methods.length; ++i) {
                ITargetMethod method = methods[i];
                String key = RPCMethodCache.GetCacheKey(method.GetMethodName(), method.GetOverlaod());
                if (this._cache.containsKey(key)) {
                    throw new RuntimeException("Duplicate method exists in the target object. (Method :" + method.GetMethodName() + " , overlaod :" + method.GetOverlaod() + ")");
                }
                this._cache.put(key, method);
            }
        }
    }

    public final ITargetMethod GetTargetMethod(String methodName, int overload) {
        String key = RPCMethodCache.GetCacheKey(methodName, overload);
        if (this._cache.containsKey(key)) {
            return this._cache.get(key);
        }
        return null;
    }

    public final IRPCTargetObject<TargetObject> GetTargetObject() {
        return this._targetObject;
    }
}

