/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Stats;

import com.alachisoft.ncache.serialization.core.io.InternalCompactSerializable;
import com.alachisoft.ncache.serialization.standard.io.CompactReader;
import com.alachisoft.ncache.serialization.standard.io.CompactWriter;
import java.io.IOException;

public class HPTime
implements Comparable,
InternalCompactSerializable {
    private static long _frequency;
    private static long _baseTimeInNanoSeconds;
    private static Object _synObj;
    private static String _col;
    private int _hr;
    private int _min;
    private int _sec;
    private int _mlSec;
    private int _micSec;
    private double _baseTime;
    private double _baseRem;

    public static void initialize() {
        HPTime.getNow();
        for (int i = 1; i < 1000; ++i) {
            HPTime.getNow();
        }
    }

    public static HPTime getNow() {
        double rem = 0.0;
        long currentTimeInNano = 0L;
        HPTime time = new HPTime();
        currentTimeInNano = System.nanoTime();
        long diff = currentTimeInNano - _baseTimeInNanoSeconds;
        rem = (double)diff / 1000000.0;
        time._hr = (int)(rem / 3600000.0);
        time._min = (int)(rem -= (double)(time._hr * 3600000)) / 60000;
        time._sec = (int)(rem -= (double)(time._min * 60000)) / 1000;
        time._mlSec = (int)(rem -= (double)(time._sec * 1000));
        rem = (rem - (double)time._mlSec) * 1000.0;
        time._micSec = (int)rem;
        return time;
    }

    public final int getHours() {
        return this._hr;
    }

    public final int getMinutes() {
        return this._min;
    }

    public final int getSeconds() {
        return this._sec;
    }

    public final int getMilliSeconds() {
        return this._mlSec;
    }

    public final int getMicroSeconds() {
        return this._micSec;
    }

    public final double getBaseTime() {
        return this._baseTime;
    }

    public final void setBaseTime(double value) {
        this._baseRem = value;
    }

    public final double getServerTicks() {
        return this._baseRem;
    }

    public final HPTime getCurrentTime() {
        double rem = 0.0;
        long currentTimeInNano = 0L;
        HPTime time = new HPTime();
        currentTimeInNano = System.nanoTime();
        long diff = currentTimeInNano - _baseTimeInNanoSeconds;
        this._baseTime = rem = (double)diff / 1000000.0;
        time._baseTime = rem;
        time._hr = (int)((rem += this._baseRem) / 3600000.0);
        time._min = (int)(rem -= (double)(time._hr * 3600000)) / 60000;
        time._sec = (int)(rem -= (double)(time._min * 60000)) / 1000;
        time._mlSec = (int)(rem -= (double)(time._sec * 1000));
        rem = (rem - (double)time._mlSec) * 1000.0;
        time._micSec = (int)rem;
        return time;
    }

    public String toString() {
        return this._hr % 24 + _col + this._min % 60 + _col + this._sec % 60 + _col + (long)this._mlSec + _col + this._micSec;
    }

    public final String ToAbsoluteTimeString() {
        return this._hr + _col + this._min + _col + this._sec + _col + (long)this._mlSec + _col + this._micSec;
    }

    public final int compareTo(Object obj) {
        if (obj instanceof HPTime) {
            HPTime other = (HPTime)obj;
            int result = new Integer(this.getHours()).compareTo(other.getHours());
            if (result == 0) {
                result = new Integer(this.getMinutes()).compareTo(other.getMinutes());
                if (result == 0) {
                    result = new Integer(this.getSeconds()).compareTo(other.getSeconds());
                    if (result == 0) {
                        result = new Integer(this.getMilliSeconds()).compareTo(other.getMilliSeconds());
                        if (result == 0) {
                            return new Integer(this.getMicroSeconds()).compareTo(other.getMicroSeconds());
                        }
                        return result;
                    }
                    return result;
                }
                return result;
            }
            return result;
        }
        throw new IllegalArgumentException("Object is not HPTime");
    }

    public final void Deserialize(CompactReader reader) throws IOException, ClassNotFoundException {
        this._hr = reader.ReadInt32();
        this._micSec = reader.ReadInt32();
        this._min = reader.ReadInt32();
        this._mlSec = reader.ReadInt32();
        this._sec = reader.ReadInt32();
    }

    public final void Serialize(CompactWriter writer) throws IOException {
        writer.Write(this._hr);
        writer.Write(this._micSec);
        writer.Write(this._min);
        writer.Write(this._mlSec);
        writer.Write(this._sec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        _synObj = new Object();
        _col = ":";
        Object object = _synObj;
        synchronized (object) {
            _baseTimeInNanoSeconds = System.nanoTime();
        }
    }
}

