/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Threading;

import java.util.LinkedList;
import java.util.List;

public class Monitor {
    static final Object s_mutex = new Object();
    static List<WaitableObject> s_watingObjects = new LinkedList<WaitableObject>();

    public static boolean wait(Object waitObject) throws InterruptedException {
        return Monitor.wait(waitObject, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wait(Object waitObject, long timeout) throws InterruptedException {
        boolean lockReacquired = true;
        if (timeout <= 0L) {
            timeout = Long.MAX_VALUE;
        }
        WaitableObject waitingObject = new WaitableObject(waitObject);
        try {
            Object object = s_mutex;
            synchronized (object) {
                s_watingObjects.add(waitingObject);
            }
            long timeElapsed = 0L;
            while (!waitingObject.isPulsed()) {
                if ((timeout -= timeElapsed) <= 0L) {
                    lockReacquired = false;
                } else {
                    timeElapsed = waitingObject.waitObject(timeout);
                    if (timeElapsed > 0L || waitingObject.isPulsed()) continue;
                    lockReacquired = false;
                }
                break;
            }
        }
        finally {
            Object object = s_mutex;
            synchronized (object) {
                for (int i = 0; i < s_watingObjects.size(); ++i) {
                    WaitableObject currentWaitingObject = s_watingObjects.get(i);
                    if (currentWaitingObject.getUniqueId() != waitingObject.getUniqueId()) continue;
                    s_watingObjects.remove(i);
                    break;
                }
            }
        }
        return lockReacquired;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pulse(Object waitObject) {
        WaitableObject waitingObject = null;
        Object object = s_mutex;
        synchronized (object) {
            for (int i = 0; i < s_watingObjects.size(); ++i) {
                waitingObject = s_watingObjects.get(i);
                if (waitingObject == null || !waitingObject.equals(waitObject)) continue;
                waitingObject.pulseObject();
                waitingObject.pulsingThread = Thread.currentThread().getName();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void pulseAll() {
        WaitableObject waitingObject = null;
        Object object = s_mutex;
        synchronized (object) {
            for (int i = 0; i < s_watingObjects.size(); ++i) {
                waitingObject = s_watingObjects.get(i);
                if (waitingObject == null) continue;
                waitingObject.pulseObject();
                waitingObject.pulsingThread = Thread.currentThread().getName();
            }
        }
    }

    static class WaitableObject {
        private static int s_unique_id_generator;
        private static Object s_unique_id_mutex;
        private Object objectToWaitFor;
        private boolean pulsed;
        private int pulseCount;
        private int uniqueId;
        private String pulsingThread;
        private long waitingThreadId;
        private long waitTime;
        private short wakeupCount;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public WaitableObject(Object objectToWaitFor) {
            this.objectToWaitFor = objectToWaitFor;
            Object object = s_unique_id_mutex;
            synchronized (object) {
                this.uniqueId = s_unique_id_generator++;
            }
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof WaitableObject ? this.objectToWaitFor == ((WaitableObject)obj).objectToWaitFor : obj != null && this.objectToWaitFor == obj;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long waitObject(long timeout) throws InterruptedException {
            this.waitingThreadId = Thread.currentThread().getId();
            this.waitTime = timeout;
            Object object = this.objectToWaitFor;
            synchronized (object) {
                if (this.pulsed) {
                    return -1L;
                }
                long start = System.currentTimeMillis();
                this.objectToWaitFor.wait(timeout);
                this.wakeupCount = (short)(this.wakeupCount + 1);
                long end = System.currentTimeMillis();
                if (start > end) {
                    return -1L;
                }
                return end - start;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pulseObject() {
            Object object = this.objectToWaitFor;
            synchronized (object) {
                this.pulsed = true;
                ++this.pulseCount;
                this.objectToWaitFor.notifyAll();
                this.objectToWaitFor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isPulsed() {
            Object object = this.objectToWaitFor;
            synchronized (object) {
                return this.pulsed;
            }
        }

        public int getUniqueId() {
            return this.uniqueId;
        }

        static {
            s_unique_id_mutex = new Object();
        }
    }
}

