/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Threading;

import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.Date;

public class ThrottlingManager {
    private long _limit;
    private long _throtllingUnitMs = 1000L;
    private long _currentInternval;
    private long _currentSize;
    private long _currentMilliSeconds;
    private Date _startTime;

    public ThrottlingManager(long limit) {
        this._limit = limit;
    }

    public ThrottlingManager(long limit, long unit) {
        this._limit = limit;
        this._throtllingUnitMs = unit;
    }

    public final void start() {
        this._startTime = new Date();
        this._currentMilliSeconds = this.getMilliSecondDiff();
        this._currentInternval = this._currentMilliSeconds / this._throtllingUnitMs;
    }

    private long getMilliSecondDiff() {
        return TimeSpan.subtract((Date)new Date(), (Date)this._startTime).getTotalMiliSeconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void throttle(long size) {
        try {
            ThrottlingManager throttlingManager = this;
            synchronized (throttlingManager) {
                long msNow = this.getMilliSecondDiff();
                long currentInterval = msNow / this._throtllingUnitMs;
                if (currentInterval == this._currentInternval) {
                    this._currentSize += size;
                    if (this._currentSize >= this._limit) {
                        Thread.sleep((int)(this._throtllingUnitMs - (msNow - this._currentMilliSeconds)));
                    }
                } else {
                    this._currentInternval = currentInterval;
                    this._currentMilliSeconds = msNow;
                    this._currentSize = size;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

