/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Threading;

import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Threading.EventQueue;
import Alachisoft.NCache.Common.Threading.Monitor;
import Alachisoft.NCache.Common.Threading.QueuedEvent;
import java.util.HashMap;

public class TimeScheduler
implements Runnable {
    private static final long TICK_INTERVAL = 1000L;
    private static final String THREAD_NAME = "TimeScheduler.Thread";
    private static ILogger _logger = null;
    private Thread thread = null;
    private State thread_state = State.SUSPEND;
    private long suspend_interval;
    private EventQueue queue = new EventQueue();

    public TimeScheduler(long suspend_interval) {
        this.suspend_interval = suspend_interval;
    }

    public TimeScheduler() {
        this(2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _start() {
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            if (this.thread_state != State.DISPOSED) {
                this.thread_state = State.RUN;
                this.thread = new Thread(this);
                this.thread.setName(THREAD_NAME);
                this.thread.setDaemon(true);
                this.thread.start();
            }
        }
    }

    private void _unsuspend() {
        this._start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _suspend() {
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            if (this.thread_state != State.DISPOSED) {
                this.thread_state = State.SUSPEND;
                this.thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stopping() {
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            if (this.thread_state != State.DISPOSED) {
                this.thread_state = State.STOPPING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _stop() {
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            if (this.thread_state != State.DISPOSED) {
                this.thread_state = State.STOP;
                this.thread = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block16: while (true) {
            try {
                while (true) {
                    TimeScheduler timeScheduler = this;
                    synchronized (timeScheduler) {
                        if (this.thread == null) {
                            return;
                        }
                    }
                    Task task = null;
                    boolean lockReAcquired = true;
                    Object object = this.queue;
                    synchronized (object) {
                        QueuedEvent e;
                        if (this.queue.getIsEmpty()) {
                            long startTime = System.nanoTime();
                            Monitor.wait(this.queue);
                            long endTime = System.nanoTime();
                            boolean bl = lockReAcquired = endTime - startTime < this.suspend_interval;
                        }
                        if (lockReAcquired && (e = this.queue.Peek()) != null) {
                            long elapsedTime;
                            QueuedEvent queuedEvent = e;
                            synchronized (queuedEvent) {
                                task = e.Task;
                                if (task.IsCancelled()) {
                                    this.queue.Pop();
                                    continue;
                                }
                                elapsedTime = e.getElapsedTime();
                                if (elapsedTime >= e.getInterval()) {
                                    this.queue.Pop();
                                    if (e.ReQueue()) {
                                        this.queue.Push(e);
                                    }
                                }
                            }
                            if (elapsedTime < e.getInterval()) {
                                Monitor.wait(this.queue, e.getInterval() - elapsedTime);
                                continue;
                            }
                        }
                    }
                    object = this;
                    synchronized (object) {
                        if (this.queue.getIsEmpty() && !lockReAcquired) {
                            this._suspend();
                            return;
                        }
                    }
                    try {
                        if (task == null) continue block16;
                        task.Run();
                        continue block16;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void AddTask(Task t, boolean relative) {
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            if (this.thread_state == State.DISPOSED) {
                return;
            }
            long interval = t.GetNextInterval();
            if (interval < 0L) {
                return;
            }
            this.queue.Push(new QueuedEvent(t));
            switch (this.thread_state) {
                case RUN: {
                    break;
                }
                case SUSPEND: {
                    this._unsuspend();
                    break;
                }
                case STOPPING: {
                    break;
                }
            }
        }
    }

    public final void AddTask(Task t) {
        this.AddTask(t, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Start() {
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            switch (this.thread_state) {
                case DISPOSED: {
                    break;
                }
                case RUN: {
                    break;
                }
                case SUSPEND: {
                    this._unsuspend();
                    break;
                }
                case STOPPING: {
                    break;
                }
                case STOP: {
                    this._start();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void Stop() throws InterruptedException {
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            switch (this.thread_state) {
                case RUN: {
                    this._stopping();
                    break;
                }
                case SUSPEND: {
                    this._stop();
                    return;
                }
                case STOPPING: {
                    return;
                }
                case STOP: {
                    return;
                }
                case DISPOSED: {
                    return;
                }
            }
            this.thread.interrupt();
        }
        this.thread.join();
        timeScheduler = this;
        synchronized (timeScheduler) {
            this.queue.Clear();
            this._stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() throws InterruptedException {
        Thread tmp = null;
        TimeScheduler timeScheduler = this;
        synchronized (timeScheduler) {
            if (this.thread_state == State.DISPOSED) {
                return;
            }
            tmp = this.thread;
            this.thread_state = State.DISPOSED;
            this.thread = null;
            if (tmp != null) {
                tmp.interrupt();
            }
        }
        if (tmp != null) {
            tmp.join();
            this.queue.Clear();
        }
    }

    public static interface Task {
        public boolean IsCancelled();

        public long GetNextInterval();

        public void Run();
    }

    private static enum State {
        RUN(0),
        SUSPEND(1),
        STOPPING(2),
        STOP(3),
        DISPOSED(4);

        private static HashMap<Integer, State> mappings;
        private int intValue;

        private State(int value) {
            this.intValue = value;
            State.getMappings().put(value, this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static HashMap<Integer, State> getMappings() {
            if (mappings != null) return mappings;
            Class<State> clazz = State.class;
            synchronized (State.class) {
                if (mappings != null) return mappings;
                mappings = new HashMap();
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        public static State forValue(int value) {
            return State.getMappings().get(value);
        }

        public int getValue() {
            return this.intValue;
        }
    }
}

