/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Common.Util;

import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Logger.EventLogger;
import java.util.ArrayList;
import java.util.LinkedList;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class BufferPool {
    private static final int DEFAULT_BUFFER_SIZE = 524288;
    private static final int DEFAULT_POOL_SIZE = 40;
    private static int _bufferSize = 524288;
    private static int _poolSize = 40;
    private static LinkedList _pool = new LinkedList();
    private static Object _sync_lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void AllocateNewBuffers() {
        Object object = _sync_lock;
        synchronized (object) {
            ArrayList newBuffers = new ArrayList();
            for (int i = 1; i <= _poolSize; ++i) {
                try {
                    byte[] buffer = new byte[_bufferSize];
                    _pool.offer(buffer);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    EventLogger.LogEvent("BufferPool can't allocate new buffer", EventType.ERROR);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] CheckoutBuffer(int size) {
        if (size != -1 && size > _bufferSize) {
            return new byte[size];
        }
        Object object = _sync_lock;
        synchronized (object) {
            if (_pool.isEmpty()) {
                BufferPool.AllocateNewBuffers();
            }
            if (_pool.size() > 0) {
                Object tempVar = _pool.poll();
                Object object2 = tempVar instanceof byte[] ? tempVar : null;
                return (byte[])object2;
            }
            return new byte[_bufferSize];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void CheckinBuffer(byte[] buffer) {
        if (buffer == null) {
            return;
        }
        if (buffer.length > _bufferSize) {
            return;
        }
        Object object = _sync_lock;
        synchronized (object) {
            _pool.offer(buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void Clear() {
        Object object = _sync_lock;
        synchronized (object) {
            _pool.clear();
        }
    }

    static {
        String temp = "";
        if (!DotNetToJavaStringHelper.isNullOrEmpty(temp)) {
            int bufferSize = 524288;
            RefObject<Integer> tempRef_bufferSize = new RefObject<Integer>(bufferSize);
            boolean tempVar = false;
            try {
                Integer.parseInt(temp);
                tempVar = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            bufferSize = (Integer)tempRef_bufferSize.argvalue;
            if (tempVar) {
                _bufferSize = bufferSize;
            }
        }
        if (!DotNetToJavaStringHelper.isNullOrEmpty(temp = "")) {
            int poolSize = 40;
            RefObject<Integer> tempRef_poolSize = new RefObject<Integer>(poolSize);
            boolean tempVar2 = false;
            try {
                Integer.parseInt(temp);
                tempVar2 = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            poolSize = (Integer)tempRef_poolSize.argvalue;
            if (tempVar2) {
                _poolSize = poolSize;
            }
        }
        BufferPool.AllocateNewBuffers();
    }
}

