/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common;

import java.util.Iterator;

public class Tokenizer
implements Iterator {
    private String text;
    private char[] delims;
    private String[] tokens;
    private int index;

    public Tokenizer(String text, String delimiters) {
        this.text = text;
        this.delims = delimiters.toCharArray();
        this.tokens = text.split(delimiters);
        if (this.tokens.length == 1 && this.tokens[0].isEmpty()) {
            this.tokens = new String[0];
        }
        this.index = -1;
    }

    public final String next() {
        return this.tokens[this.index];
    }

    public final int getCount() {
        if (this.index < this.tokens.length) {
            return this.tokens.length - this.index - 1;
        }
        return 0;
    }

    @Override
    public final boolean hasNext() {
        if (this.index < this.tokens.length - 1) {
            ++this.index;
            return true;
        }
        return false;
    }

    public final Object getCurrent() {
        return this.next();
    }

    public final boolean MoveNext() {
        return this.hasNext();
    }

    public final void Reset() {
        this.index = -1;
    }

    @Override
    @Deprecated
    public final void remove() {
    }
}

