/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.customcounters.systemcounters;

import Alachisoft.NCache.Common.Common;
import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Logger.EventLogger;
import com.alachisoft.ncache.common.caching.statistics.customcounters.InstantaneousCounter;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.util.List;
import org.hyperic.sigar.Sigar;

public abstract class SystemCounter
extends InstantaneousCounter {
    public static List<MemoryPoolMXBean> m;
    private static Sigar sigar;
    private static java.lang.management.OperatingSystemMXBean oSMXBean;
    private static MemoryMXBean memoryMXBean;
    private static MemoryUsage memoryUsage;

    public SystemCounter(String name, String instance) {
        super(name, instance);
    }

    public static Sigar getSigar() {
        return sigar;
    }

    public static java.lang.management.OperatingSystemMXBean getJavaOSMXBean() {
        return oSMXBean;
    }

    public static OperatingSystemMXBean getSunOSMXBean() {
        try {
            if (oSMXBean != null) {
                return (OperatingSystemMXBean)oSMXBean;
            }
        }
        catch (Throwable e) {
            e.getMessage();
        }
        return null;
    }

    public static MemoryMXBean getMemoryMXBean() {
        return memoryMXBean;
    }

    @Override
    protected abstract void calculate(double var1);

    @Override
    protected void flipChanged() {
        this.calculate(this._value);
    }

    @Override
    public void decrement() {
    }

    @Override
    public void decrementBy(double value) {
    }

    @Override
    public double getValue() {
        this.updateIfFlipChanged();
        return this._value;
    }

    @Override
    public void setValue(double _value) {
        this._value = Common.roundOff(_value, 1);
    }

    public double toMegaBytes(double bytes) {
        return bytes / 1048576.0;
    }

    static {
        sigar = null;
        try {
            sigar = new Sigar();
        }
        catch (Throwable e) {
            EventLogger.LogEvent("System counters will not be published on JMX or snmp.", EventType.ERROR);
        }
        try {
            oSMXBean = ManagementFactory.getOperatingSystemMXBean();
            memoryMXBean = ManagementFactory.getMemoryMXBean();
            m = ManagementFactory.getMemoryPoolMXBeans();
        }
        catch (Throwable e) {
            EventLogger.LogEvent("System counters will not be published on JMX.", EventType.ERROR);
        }
    }
}

