/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.caching.statistics.monitoring;

import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Logger.JLevel;
import Alachisoft.NCache.Common.PortPool;
import Alachisoft.NCache.Common.ServicePropValues;
import com.alachisoft.ncache.common.caching.statistics.customcounters.PerformanceCounter;
import com.alachisoft.ncache.common.caching.statistics.monitoring.MonitorMBean;
import com.alachisoft.ncache.common.caching.statistics.operations.Operations;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.util.logging.Level;
import org.vafer.jmx2snmp.jmx.JmxServer;
import org.weakref.jmx.MBeanExporter;
import org.weakref.jmx.Managed;

public abstract class Monitor
implements MonitorMBean {
    static JmxServer jmxServer;
    private static int jmxPort;
    private static boolean jmxStarted;
    private final String exportStringPrefix = "NCache:name=ncache.";
    MBeanExporter exporter;
    private InetAddress statsServerIp;
    private String nodeName;
    private ILogger logger;

    public Monitor(String nodeName) {
        this.nodeName = nodeName;
        this.statsServerIp = ServicePropValues.getStatsServerIp();
        if (jmxPort == 0) {
            jmxPort = PortPool.getInstance().getJMXPort(this.statsServerIp);
        }
    }

    public Monitor(String nodeName, ILogger logger) {
        this.nodeName = nodeName;
        this.logger = logger;
        this.statsServerIp = ServicePropValues.getStatsServerIp();
        if (jmxPort == 0) {
            jmxPort = PortPool.getInstance().getJMXPort(this.statsServerIp);
        }
    }

    public static int getJmxPort() {
        return jmxPort;
    }

    public InetAddress getStatsServerIp() {
        return this.statsServerIp;
    }

    abstract void setPort();

    public String getExportStringPrefix() {
        return "NCache:name=ncache.";
    }

    @Override
    public void registerCounter(Operations operation, PerformanceCounter perfCounter) throws Exception {
        if (operation == null || perfCounter == null) {
            throw new Exception("Opertation or perfcounter cannot be null");
        }
        this.getCounterStore().put((Enum)((Object)operation), perfCounter);
    }

    @Override
    public void unRegisterCounter(Operations operation) {
        this.getCounterStore().remove(operation);
    }

    @Override
    public void startJMX() {
        if (jmxStarted) {
            return;
        }
        try {
            jmxServer = new JmxServer(this.getStatsServerIp(), 0, jmxPort);
            jmxServer.start();
            jmxStarted = true;
        }
        catch (Exception exception) {
            this.Log(Monitor.class.getCanonicalName().toString() + "Error while attempting to start JMX", exception.getMessage(), JLevel.SEVERE);
        }
    }

    @Override
    public void stopJMX() {
        try {
            if (jmxServer != null) {
                jmxServer.stop();
            }
        }
        catch (Exception exception) {
            this.Log(Monitor.class.getCanonicalName().toString() + "Error while attempting to stop JMX", exception.getMessage(), JLevel.Error);
        }
    }

    @Override
    public Boolean registerNode() {
        try {
            String exportString = this.getExportString();
            this.exporter = new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
            this.exporter.export(exportString, (Object)this);
        }
        catch (Throwable t) {
            this.Log(t.getMessage(), JLevel.Error);
            return false;
        }
        return true;
    }

    @Override
    public Boolean unRegisterNode() {
        try {
            this.exporter.unexport(this.getExportString());
        }
        catch (Exception exception) {
            this.Log(exception.getMessage(), JLevel.Error);
            return false;
        }
        return true;
    }

    @Override
    public double getCounter(Operations operation) {
        return ((PerformanceCounter)this.getCounterStore().get(operation)).getValue();
    }

    @Override
    @Managed(description="Name of this running node. ", name="Node Name")
    public String getNodeName() {
        return this.nodeName;
    }

    public void Log(String message, Level level) {
        this.Log(null, message, level);
    }

    public void Log(String moduleName, String message, Level level) {
        if (this.logger != null) {
            if (level.equals(JLevel.ALL)) {
                if (moduleName == null) {
                    this.logger.Debug(message);
                } else {
                    this.logger.Debug(moduleName, message);
                }
            } else if (level.equals(JLevel.CriticalInfo)) {
                if (moduleName == null) {
                    this.logger.CriticalInfo(message);
                } else {
                    this.logger.CriticalInfo(moduleName, message);
                }
            } else if (level.equals(JLevel.Error)) {
                if (moduleName == null) {
                    this.logger.Error(message);
                } else {
                    this.logger.Error(moduleName, message);
                }
            } else if (level.equals(JLevel.SEVERE)) {
                if (moduleName == null) {
                    this.logger.Fatal(message);
                } else {
                    this.logger.Fatal(moduleName, message);
                }
            } else if (moduleName == null) {
                this.logger.Info(message);
            } else {
                this.logger.Info(moduleName, message);
            }
        }
    }

    static {
        jmxStarted = false;
        jmxPort = 0;
    }
}

