/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.common.commandline;

import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import com.alachisoft.ncache.common.commandline.ArgumentAttributeAnnotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class CommandLineArgumentParser {
    public static void Parse(Object obj, String[] args) throws IllegalArgumentException, Exception {
        ConfigurationBuilder configbuilder = new ConfigurationBuilder();
        Class<?> type = obj.getClass();
        Method[] objMethods = type.getMethods();
        ArgumentAttributeAnnotation orphanAnnotation = null;
        Method orphanMethod = null;
        if (objMethods != null) {
            for (int i = 0; i < args.length; ++i) {
                Boolean isAssinged = false;
                for (Method objMethod : objMethods) {
                    ArgumentAttributeAnnotation customAnnotation = objMethod.getAnnotation(ArgumentAttributeAnnotation.class);
                    if (customAnnotation == null) continue;
                    try {
                        List<Class<?>> parameters = Arrays.asList(objMethod.getParameterTypes());
                        if (customAnnotation.shortNotation().equals(args[i].toLowerCase()) || customAnnotation.fullNotation().toLowerCase().equals(args[i].toLowerCase())) {
                            if (parameters.isEmpty()) continue;
                            Class<?> firstParam = parameters.get(0);
                            if (firstParam.equals(Boolean.TYPE) || firstParam.equals(Boolean.class)) {
                                Boolean defaultValue = Boolean.parseBoolean(customAnnotation.defaultValue());
                                objMethod.invoke(obj, defaultValue == false);
                                isAssinged = true;
                                break;
                            }
                            int index = i + 1;
                            if (index > args.length - 1) continue;
                            Object value = configbuilder.ConvertToPrimitive(firstParam, args[++i], null);
                            objMethod.invoke(obj, value);
                            isAssinged = true;
                            break;
                        }
                        if (customAnnotation.shortNotation() == null || !customAnnotation.shortNotation().equals("") || orphanAnnotation != null || isAssinged.booleanValue() || parameters.size() <= 0) continue;
                        orphanAnnotation = customAnnotation;
                        orphanMethod = objMethod;
                    }
                    catch (Exception e) {
                        throw new Exception("Can not set the value for attribute " + customAnnotation.shortNotation() + " Errror :" + e.getMessage());
                    }
                }
                if (isAssinged.booleanValue()) continue;
                if (orphanAnnotation != null && orphanMethod != null) {
                    if (args[i].toString().startsWith("-")) {
                        throw new IllegalArgumentException("Invalid argument: '" + args[i].toString() + "'");
                    }
                    Class<?> parameter = orphanMethod.getParameterTypes()[0];
                    Object value = configbuilder.ConvertToPrimitive(parameter, args[i], null);
                    orphanMethod.invoke(obj, value);
                    continue;
                }
                if (!args[i].toString().startsWith("-")) continue;
                throw new IllegalArgumentException("Invalid argument: '" + args[i].toString() + "'");
            }
        }
    }
}

