/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.ncactivate.utils;

import com.alachisoft.ncache.licensing.config.ConfigHandler;
import com.alachisoft.ncache.licensing.config.InfoType;
import com.alachisoft.ncache.licensing.config.LicenseInfo;
import com.alachisoft.ncache.licensing.config.NCacheInfo;
import com.alachisoft.ncache.ncactivate.utils.RegKeys;
import com.alachisoft.ncache.runtime.util.RuntimeUtil;
import java.nio.file.Paths;

public class RegUtil {
    private static final String NCInfoFileOnLinux = "/usr/lib/ncinfo.xml";
    private static final String LicenseInfoFileOnLinux = "/usr/lib/nclicense.xml";
    private static final String LicenseInfoFileOnWindows = Paths.get("config", "nclicense.xml").toString();
    public static String notFound = "";
    public static NCacheInfo nCacheInfo;
    public static LicenseInfo licenseInfo;
    public static String winStub;
    public static String linuxStub;
    private static String _installDir;
    private static boolean loaded;

    public static String getNCHome() {
        String ncHome = System.getenv("NCHOME");
        if (ncHome == null && RuntimeUtil.getCurrentOS() == RuntimeUtil.OS.Linux) {
            RegUtil.LoadRegistry();
            if (nCacheInfo != null) {
                ncHome = nCacheInfo.getProduct().getInstallDir();
            }
        }
        return ncHome;
    }

    public static void LoadRegistry() {
        if (loaded) {
            return;
        }
        try {
            loaded = true;
            if (RuntimeUtil.getCurrentOS() == RuntimeUtil.OS.Linux) {
                nCacheInfo = ConfigHandler.readNCacheInfo(NCInfoFileOnLinux);
                licenseInfo = ConfigHandler.readLicenseInfo(LicenseInfoFileOnLinux);
            } else if (RuntimeUtil.getCurrentOS() == RuntimeUtil.OS.Windows) {
                String path = Paths.get(RegUtil.getNCHome(), LicenseInfoFileOnWindows).toString();
                nCacheInfo = ConfigHandler.readNCacheInfo(path);
                licenseInfo = ConfigHandler.readLicenseInfo(path);
            }
        }
        catch (Exception e) {
            loaded = false;
        }
    }

    public static void StoreRegistry() {
        if (nCacheInfo == null || licenseInfo == null) {
            return;
        }
        ConfigHandler.writeNCacheInfo(NCInfoFileOnLinux, RegUtil.convertNCacheDomToXML());
        ConfigHandler.writeNCacheInfo(NCInfoFileOnLinux, RegUtil.convertNCacheDomToXML());
    }

    public static String getKey(InfoType Type2, RegKeys RegKey) {
        RegUtil.LoadRegistry();
        if (nCacheInfo == null) {
            return "";
        }
        switch (Type2) {
            case PRODUCT: {
                return nCacheInfo.getProduct().getValue(RegKey);
            }
            case DEPLOYMENT: {
                return nCacheInfo.getDeploymentInfo().getValue(RegKey);
            }
            case USER: {
                return nCacheInfo.getUserInfo().getValue(RegKey);
            }
            case LICENSE: {
                return licenseInfo.getValue(RegKey);
            }
        }
        return "";
    }

    public static void setKey(InfoType type, RegKeys regKey, String value) {
        if (nCacheInfo == null) {
            return;
        }
        switch (type) {
            case PRODUCT: {
                nCacheInfo.getProduct().setValue(regKey, value);
            }
            case DEPLOYMENT: {
                nCacheInfo.getDeploymentInfo().setValue(regKey, value);
            }
            case USER: {
                nCacheInfo.getUserInfo().setValue(regKey, value);
            }
        }
    }

    public static String getInstallCode() {
        RegUtil.LoadRegistry();
        String installCode = null;
        if (nCacheInfo != null && nCacheInfo.getProduct() != null) {
            installCode = nCacheInfo.getProduct().getInstallCode();
        }
        if (installCode != null) {
            installCode = installCode.trim();
        }
        return installCode;
    }

    private static String getInstallDir() {
        RegUtil.LoadRegistry();
        if (_installDir == null) {
            if (nCacheInfo != null) {
                // empty if block
            }
            _installDir = nCacheInfo.getProduct().getInstallDir();
        }
        return _installDir;
    }

    private static String convertNCacheDomToXML() {
        return nCacheInfo.getXmlString();
    }

    static {
        winStub = "ncstub.bin";
        linuxStub = ".ncstub.so";
    }
}

