/*
 * Decompiled with CFR 0.152.
 */
package Alachisoft.NCache.Storage;

import Alachisoft.NCache.Common.ISizable;
import Alachisoft.NCache.Common.Logger.ILogger;
import Alachisoft.NCache.Common.Monitoring.ServerMonitor;
import Alachisoft.NCache.Common.Propagator.IAlertPropagator;
import Alachisoft.NCache.Storage.StorageProviderBase;
import Alachisoft.NCache.Storage.StoreAddResult;
import Alachisoft.NCache.Storage.StoreInsResult;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ClrHeapStorageProvider
extends StorageProviderBase {
    protected HashMap _itemDict = new HashMap(25000, 0.7f);

    public ClrHeapStorageProvider() {
    }

    public ClrHeapStorageProvider(long maxDataSize) {
        super(maxDataSize);
    }

    public ClrHeapStorageProvider(Map properties, boolean evictionEnabled, ILogger NCacheLog, IAlertPropagator alertPropagator) {
        super(properties, evictionEnabled, NCacheLog, alertPropagator);
    }

    @Override
    public void dispose() {
        this._itemDict.clear();
        this._itemDict = null;
        super.dispose();
    }

    @Override
    public long getCount() {
        return this._itemDict.size();
    }

    @Override
    public void Clear() {
        this._itemDict.clear();
        super.Cleared();
    }

    @Override
    public boolean Contains(Object key) {
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Store.Cont", (String)"");
        }
        return this._itemDict.containsKey(key);
    }

    @Override
    public Object Get(Object key) {
        try {
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"Store.Get", (String)"");
            }
            return this._itemDict.get(key);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public int GetItemSize(Object key) {
        try {
            ISizable item = this._itemDict.get(key) instanceof ISizable ? this._itemDict.get(key) : null;
            return item != null ? item.getSize() : 0;
        }
        catch (Exception e) {
            return 0;
        }
    }

    @Override
    public StoreAddResult Add(Object key, Object item) {
        try {
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"Store.Add", (String)"");
            }
            if (this._itemDict.containsKey(key)) {
                return StoreAddResult.KeyExists;
            }
            StorageProviderBase.StoreStatus status = this.HasSpace((ISizable)item);
            if (this._reportCacheNearEviction) {
                this.CheckForStoreNearEviction();
            }
            if (status == StorageProviderBase.StoreStatus.HasNotEnoughSpace) {
                return StoreAddResult.NotEnoughSpace;
            }
            this._itemDict.put(key, item);
            super.Added((ISizable)(item instanceof ISizable ? item : null));
            if (status == StorageProviderBase.StoreStatus.NearEviction) {
                return StoreAddResult.SuccessNearEviction;
            }
        }
        catch (OutOfMemoryError e) {
            return StoreAddResult.NotEnoughSpace;
        }
        catch (RuntimeException e) {
            throw e;
        }
        return StoreAddResult.Success;
    }

    @Override
    public StoreInsResult Insert(Object key, Object item) {
        try {
            Object oldItem;
            if (ServerMonitor.getMonitorActivity()) {
                ServerMonitor.LogClientActivity((String)"Store.Insert", (String)"");
            }
            StorageProviderBase.StoreStatus status = this.HasSpace((ISizable)((oldItem = this._itemDict.get(key)) instanceof ISizable ? oldItem : null), (ISizable)item);
            if (this._reportCacheNearEviction) {
                this.CheckForStoreNearEviction();
            }
            if (status == StorageProviderBase.StoreStatus.HasNotEnoughSpace) {
                return StoreInsResult.NotEnoughSpace;
            }
            this._itemDict.put(key, item);
            super.Inserted((ISizable)(oldItem instanceof ISizable ? oldItem : null), (ISizable)(item instanceof ISizable ? item : null));
            if (status == StorageProviderBase.StoreStatus.NearEviction) {
                return oldItem != null ? StoreInsResult.SuccessOverwriteNearEviction : StoreInsResult.SuccessNearEviction;
            }
            return oldItem != null ? StoreInsResult.SuccessOverwrite : StoreInsResult.Success;
        }
        catch (OutOfMemoryError e) {
            return StoreInsResult.NotEnoughSpace;
        }
        catch (RuntimeException e) {
            throw e;
        }
    }

    @Override
    public Object Remove(Object key) {
        Object e;
        if (ServerMonitor.getMonitorActivity()) {
            ServerMonitor.LogClientActivity((String)"Store.Remove", (String)"");
        }
        if ((e = this.Get(key)) != null) {
            this._itemDict.remove(key);
            super.Removed((ISizable)(e instanceof ISizable ? e : null));
        }
        return e;
    }

    @Override
    public Iterator GetEnumerator() {
        return this._itemDict.entrySet().iterator();
    }

    @Override
    public Object[] getKeys() {
        return this._itemDict.keySet().toArray();
    }
}

