/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.hibernate.configuration;

import Alachisoft.NCache.Common.Configuration.ConfigurationBuilder;
import com.alachisoft.ncache.hibernate.configuration.ApplicationConfiguration;
import com.alachisoft.ncache.hibernate.configuration.DatabaseDependency;
import com.alachisoft.ncache.hibernate.configuration.DatabaseDependencyConfigurationManager;
import com.alachisoft.ncache.hibernate.configuration.RegionConfigurationManager;
import com.alachisoft.ncache.hibernate.configuration.RegionConfiguraton;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.dependencies.DBCacheDependency;
import com.alachisoft.ncache.runtime.dependencies.DBDependencyFactory;
import com.alachisoft.ncache.runtime.dependencies.OracleCacheDependency;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.io.File;
import java.io.FileNotFoundException;

public class ConfigurationManager {
    private static ConfigurationManager _singleton;
    private static Object _singletonLock;
    private ApplicationConfiguration _appConfig = null;
    private RegionConfigurationManager _regionConfigManager = null;
    private DatabaseDependencyConfigurationManager _dbConfigManager = null;

    private ConfigurationManager() throws ConfigurationException, FileNotFoundException, Exception {
        String configFilePath = this.GetFilePah("NCacheHibernate.xml");
        ConfigurationBuilder configBuilder = new ConfigurationBuilder(configFilePath);
        configBuilder.RegisterRootConfigurationObject(ApplicationConfiguration.class);
        configBuilder.ReadConfiguration();
        Object[] configuraion = configBuilder.getConfiguration();
        boolean appConfigFound = false;
        if (configuraion != null && configuraion.length > 0) {
            for (int i = 0; i < configuraion.length; ++i) {
                this._appConfig = (ApplicationConfiguration)configuraion[i];
                if (this._appConfig == null || this._appConfig.getApplicationID() == null) continue;
                appConfigFound = true;
                break;
            }
        }
        if (!appConfigFound) {
            throw new ConfigurationException("Invalid value of ncache.application_id. Applicaion configuration not found for application-id = ");
        }
        if (this._appConfig.getDefaultRegion() == null || this._appConfig.getDefaultRegion().isEmpty()) {
            throw new ConfigurationException("default-region cannot be null for application-id = " + this._appConfig.getApplicationID());
        }
        this._regionConfigManager = new RegionConfigurationManager(this._appConfig.getCacheRegions());
        if (!this._regionConfigManager.contains(this._appConfig.getDefaultRegion())) {
            throw new ConfigurationException("Region's configuration not specified for default-region : " + this._appConfig.getDefaultRegion());
        }
        this._dbConfigManager = new DatabaseDependencyConfigurationManager(this._appConfig.getDatabaseDependencies());
    }

    private String GetFilePah(String fileName) throws FileNotFoundException {
        Object filePath = "";
        if (new File(fileName).exists()) {
            filePath = fileName;
        } else if (new File(".\\bin\\" + fileName).exists()) {
            filePath = ".\\bin\\" + fileName;
        } else if (new File(System.getenv("NCHOME") + "\\config\\" + fileName).exists()) {
            filePath = System.getenv("NCHOME") + "\\config\\" + fileName;
        } else {
            String envVatiableError = "";
            if (System.getenv("NCHOME") == null || System.getenv("NCHOME").isEmpty()) {
                envVatiableError = " Envronment variable NCHOME not set to a valid directory path.";
            }
            throw new FileNotFoundException(fileName + " file not found.");
        }
        return filePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationManager getInstance() throws ConfigurationException, FileNotFoundException, Exception {
        Object object = _singletonLock;
        synchronized (object) {
            if (_singleton == null) {
                _singleton = new ConfigurationManager();
            }
            return _singleton;
        }
    }

    public RegionConfiguraton getRegionConfiguration(String regionName) {
        RegionConfiguraton rConfig = this._regionConfigManager.getRegionConfig(regionName);
        if (rConfig == null) {
            rConfig = this._regionConfigManager.getRegionConfig(this._appConfig.getDefaultRegion());
        }
        return rConfig;
    }

    public CacheDependency getCacheDependency(String entityName, String primaryKey) {
        DatabaseDependency dependency = this._dbConfigManager.getDependency(entityName);
        if (dependency == null) {
            return null;
        }
        String connectionString = dependency.getConnectionString();
        if (dependency.getType().equalsIgnoreCase("oracle")) {
            String command = dependency.getSqlStatement();
            String[] arrPrimaryKeys = primaryKey.split(dependency.getCompositeKeySeperaor());
            for (int i = arrPrimaryKeys.length; i > 0; --i) {
                String t = this.pad("?", i - 1, "?");
                command = command.replace(t, arrPrimaryKeys[i - 1]);
            }
            return new OracleCacheDependency(connectionString, command);
        }
        if (dependency.getType().equalsIgnoreCase("oledb")) {
            String dbCacheKey = dependency.getCacheKeyFormat().replace("[pk]", primaryKey);
            dbCacheKey = dbCacheKey.replace("[en]", entityName);
            DBCacheDependency oledependency = DBDependencyFactory.createOleDbCacheDependency((String)connectionString, (String)dbCacheKey);
            return DBDependencyFactory.createOleDbCacheDependency((String)connectionString, (String)dbCacheKey);
        }
        return null;
    }

    public String getCacheKey(Object key) {
        Object cacheKey = null;
        String[] keyParts = key.toString().split("#");
        if (keyParts.length > 1) {
            cacheKey = this._dbConfigManager.getCacheKeyFormat(keyParts[0]).replace("[en]", keyParts[0]);
            cacheKey = ((String)cacheKey).replace("[pk]", keyParts[1]);
        } else {
            cacheKey = "HibernateNCache:" + key.toString();
            if (!this._appConfig.getKeyCaseSensitivity()) {
                cacheKey = ((String)cacheKey).toLowerCase();
            }
        }
        return cacheKey;
    }

    public boolean isExceptionEnabled() {
        return this._appConfig.getCacheExceptionEnabled();
    }

    private String pad(String str, int size, String padChar) {
        StringBuffer padded = new StringBuffer(str);
        while (padded.length() < size + str.length()) {
            padded.append(padChar);
        }
        return padded.toString();
    }

    static {
        _singletonLock = new Object();
    }
}

