/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.hibernate.configuration;

import com.alachisoft.ncache.hibernate.configuration.DatabaseDependencies;
import com.alachisoft.ncache.hibernate.configuration.DatabaseDependency;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import java.util.HashMap;

public class DatabaseDependencyConfigurationManager {
    HashMap dependencyHM = new HashMap();
    private String _defaultCacheKeyFormat = "HibernateNCache:[en]#[pk]";

    public DatabaseDependencyConfigurationManager(DatabaseDependencies dependencies) throws ConfigurationException {
        DatabaseDependency[] dbDependencies;
        if (dependencies != null && (dbDependencies = dependencies.getDependencies()) != null) {
            for (int i = 0; i < dbDependencies.length; ++i) {
                this.validateDependency(dbDependencies[i]);
                this.dependencyHM.put(dbDependencies[i].getEntityName(), dbDependencies[i]);
            }
        }
    }

    public DatabaseDependency getDependency(String entityName) {
        Object dependency = this.dependencyHM.get(entityName);
        if (dependency == null) {
            return null;
        }
        return (DatabaseDependency)dependency;
    }

    private void validateDependency(DatabaseDependency dependency) throws ConfigurationException {
        if (dependency.getEntityName() == null || dependency.getEntityName().isEmpty()) {
            throw new ConfigurationException("entity-name cannot be empty in dependency.");
        }
        if (this.dependencyHM.containsKey(dependency.getEntityName())) {
            throw new ConfigurationException("Multiple dependencies can not be added for same object type : " + dependency.getEntityName());
        }
        if (dependency.getType() == null || dependency.getType().isEmpty()) {
            throw new ConfigurationException("dependency type cannot be empty in dependency: " + dependency.getEntityName());
        }
        if (!dependency.getType().equalsIgnoreCase("oracle") && !dependency.getType().equalsIgnoreCase("oledb")) {
            throw new ConfigurationException("Invalid dependency type.");
        }
        if (!dependency.getType().equalsIgnoreCase("oledb") && (dependency.getSqlStatement() == null || dependency.getSqlStatement().isEmpty())) {
            throw new ConfigurationException("sql-statement cannot be empty for oracle dependency: " + dependency.getEntityName());
        }
        if (dependency.getCacheKeyFormat() == null || dependency.getCacheKeyFormat().isEmpty() || !dependency.getCacheKeyFormat().contains("[pk]")) {
            throw new ConfigurationException("Invalid cache-key-format in dependency " + dependency.getEntityName() + ". cache-key-format must include [pk] tag.");
        }
        if (dependency.getCompositeKeySeperaor().length() > 1) {
            throw new ConfigurationException("Invalid value for composite-key-seperator in dependency " + dependency.getEntityName() + ". Seperator must be one character long.");
        }
    }

    public String getCacheKeyFormat(String entityName) {
        if (entityName == null || entityName.isEmpty() || !this.dependencyHM.containsKey(entityName)) {
            return this._defaultCacheKeyFormat;
        }
        return ((DatabaseDependency)this.dependencyHM.get(entityName)).getCacheKeyFormat();
    }
}

