/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.hibernate.configuration;

import com.alachisoft.ncache.hibernate.configuration.CacheRegions;
import com.alachisoft.ncache.hibernate.configuration.RegionConfiguraton;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;

public class RegionConfigurationManager {
    RegionConfiguraton[] _regions = null;

    public RegionConfigurationManager(CacheRegions regions) throws ConfigurationException {
        if (regions == null || regions.getRegions() == null) {
            throw new ConfigurationException("cache-regions not specified in application config.");
        }
        this._regions = regions.getRegions();
        for (int i = 0; i < this._regions.length; ++i) {
            this.validateRegionConfig(this._regions[i]);
        }
    }

    public RegionConfiguraton getRegionConfig(String regionName) {
        for (int i = 0; i < this._regions.length; ++i) {
            if (!this._regions[i].getRegionName().equals(regionName)) continue;
            return this._regions[i];
        }
        return null;
    }

    private void validateRegionConfig(RegionConfiguraton region) throws ConfigurationException {
        if (region.getRegionName() == null || region.getRegionName().isEmpty()) {
            throw new ConfigurationException("region-name cannot be null or empty.");
        }
        if (region.getCacheName() == null || region.getRegionName().isEmpty()) {
            throw new ConfigurationException("cache-name cannot be null in region = " + region.getRegionName());
        }
        if (!(region.getExpirationType().equalsIgnoreCase("absolute") || region.getExpirationType().equalsIgnoreCase("sliding") || region.getExpirationType().equalsIgnoreCase("none"))) {
            throw new ConfigurationException("Invalid value for expiraion-type in region = " + region.getRegionName());
        }
        if (!"none".equals(region.getExpirationType().toLowerCase()) && region.getExpirationPeriod() <= 0) {
            throw new ConfigurationException("Invalid value for expiraion-period in region = " + region.getRegionName() + ". Expiraion period must be greater than zero.");
        }
        if (region.getPriority().equalsIgnoreCase("abovenormal")) {
            region.setCacheItemPriority(CacheItemPriority.AboveNormal);
        } else if (region.getPriority().equalsIgnoreCase("belownormal")) {
            region.setCacheItemPriority(CacheItemPriority.BelowNormal);
        } else if (region.getPriority().equalsIgnoreCase("default")) {
            region.setCacheItemPriority(CacheItemPriority.Default);
        } else if (region.getPriority().equalsIgnoreCase("high")) {
            region.setCacheItemPriority(CacheItemPriority.High);
        } else if (region.getPriority().equalsIgnoreCase("low")) {
            region.setCacheItemPriority(CacheItemPriority.Low);
        } else if (region.getPriority().equalsIgnoreCase("normal")) {
            region.setCacheItemPriority(CacheItemPriority.Normal);
        } else if (region.getPriority().equalsIgnoreCase("notremovable")) {
            region.setCacheItemPriority(CacheItemPriority.NotRemovable);
        } else {
            throw new ConfigurationException("Invalid value for priority in region = " + region.getRegionName());
        }
    }

    public boolean contains(String regionName) {
        return this.getRegionConfig(regionName) != null;
    }
}

