/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheStream;
import com.alachisoft.ncache.client.CacheStreamAttributes;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.datastructures.DataStructureManager;
import com.alachisoft.ncache.client.services.MessagingService;
import com.alachisoft.ncache.client.services.NotificationService;
import com.alachisoft.ncache.client.services.SearchService;
import com.alachisoft.ncache.runtime.caching.CacheItemAttributes;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;

public interface Cache
extends Enumeration,
AutoCloseable {
    public long getCount() throws CacheException;

    public ClientInfo getClientInfo() throws CacheException;

    public List<ClientInfo> getConnectedClientList() throws CacheException;

    public MessagingService getMessagingService() throws CacheException;

    public SearchService getSearchService() throws CacheException;

    public NotificationService getNotificationService() throws CacheException;

    public DataStructureManager getDataStructuresManager() throws CacheException;

    public CacheItemVersion add(String var1, Object var2) throws CacheException, IllegalArgumentException;

    public CacheItemVersion add(String var1, CacheItem var2) throws CacheException, IllegalArgumentException;

    public CacheItemVersion add(String var1, CacheItem var2, WriteThruOptions var3) throws CacheException, IllegalArgumentException;

    public Map<String, Exception> addBulk(Map<String, CacheItem> var1) throws CacheException, IllegalArgumentException;

    public Map<String, Exception> addBulk(Map<String, CacheItem> var1, WriteThruOptions var2) throws CacheException, IllegalArgumentException;

    public FutureTask<CacheItemVersion> addAsync(String var1, Object var2) throws CacheException, IllegalArgumentException;

    public FutureTask<CacheItemVersion> addAsync(String var1, CacheItem var2) throws CacheException, IllegalArgumentException;

    public FutureTask<CacheItemVersion> addAsync(String var1, CacheItem var2, WriteThruOptions var3) throws CacheException, IllegalArgumentException;

    public CacheItemVersion insert(String var1, Object var2) throws CacheException, IllegalArgumentException;

    public CacheItemVersion insert(String var1, CacheItem var2) throws CacheException, IllegalArgumentException;

    public CacheItemVersion insert(String var1, CacheItem var2, WriteThruOptions var3) throws CacheException, IllegalArgumentException;

    public CacheItemVersion insert(String var1, CacheItem var2, WriteThruOptions var3, LockHandle var4, boolean var5) throws CacheException, IllegalArgumentException;

    public Map<String, Exception> insertBulk(Map<String, CacheItem> var1) throws CacheException, IllegalArgumentException;

    public Map<String, Exception> insertBulk(Map<String, CacheItem> var1, WriteThruOptions var2) throws CacheException, IllegalArgumentException;

    public FutureTask<CacheItemVersion> insertAsync(String var1, Object var2) throws CacheException, IllegalArgumentException;

    public FutureTask<CacheItemVersion> insertAsync(String var1, CacheItem var2) throws CacheException, IllegalArgumentException;

    public FutureTask<CacheItemVersion> insertAsync(String var1, CacheItem var2, WriteThruOptions var3) throws CacheException, IllegalArgumentException;

    public boolean updateAttributes(String var1, CacheItemAttributes var2) throws CacheException, IllegalArgumentException;

    public <T> T get(String var1, Class<?> var2) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> T get(String var1, ReadThruOptions var2, Class<?> var3) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> T get(String var1, boolean var2, TimeSpan var3, LockHandle var4, Class<?> var5) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> T get(String var1, CacheItemVersion var2, ReadThruOptions var3, Class<?> var4) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> Map<String, T> getBulk(Iterable<String> var1, Class<?> var2) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> Map<String, T> getBulk(Iterable<String> var1, ReadThruOptions var2, Class<?> var3) throws CacheException, IllegalArgumentException, ClassCastException;

    public CacheItem getCacheItem(String var1) throws CacheException, IllegalArgumentException;

    public CacheItem getCacheItem(String var1, ReadThruOptions var2) throws CacheException, IllegalArgumentException;

    public CacheItem getCacheItem(String var1, CacheItemVersion var2, ReadThruOptions var3) throws CacheException, IllegalArgumentException;

    public CacheItem getCacheItem(String var1, boolean var2, TimeSpan var3, LockHandle var4) throws CacheException, IllegalArgumentException;

    public Map<String, CacheItem> getCacheItemBulk(Iterable<String> var1) throws CacheException, IllegalArgumentException, ClassCastException;

    public Map<String, CacheItem> getCacheItemBulk(Iterable<String> var1, ReadThruOptions var2) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> T getIfNewer(String var1, CacheItemVersion var2, Class<?> var3) throws CacheException;

    public void delete(String var1) throws CacheException, IllegalArgumentException;

    public void delete(String var1, WriteThruOptions var2) throws CacheException, IllegalArgumentException;

    public void delete(String var1, LockHandle var2, CacheItemVersion var3, WriteThruOptions var4) throws CacheException, IllegalArgumentException;

    public FutureTask deleteAsync(String var1) throws CacheException, IllegalArgumentException;

    public FutureTask deleteAsync(String var1, WriteThruOptions var2) throws CacheException, IllegalArgumentException;

    public void deleteBulk(Iterable<String> var1) throws CacheException, IllegalArgumentException, ClassCastException;

    public void deleteBulk(Iterable<String> var1, WriteThruOptions var2) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> T remove(String var1, Class<?> var2) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> T remove(String var1, WriteThruOptions var2, Class<?> var3) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> T remove(String var1, LockHandle var2, CacheItemVersion var3, WriteThruOptions var4, Class<?> var5) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> Map<String, T> removeBulk(Iterable<String> var1, Class<?> var2) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> Map<String, T> removeBulk(Iterable<String> var1, WriteThruOptions var2, Class<?> var3) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> FutureTask<T> removeAsync(String var1, Class<?> var2) throws CacheException, IllegalArgumentException, ClassCastException;

    public <T> FutureTask<T> removeAsync(String var1, WriteThruOptions var2, Class<?> var3) throws CacheException, IllegalArgumentException, ClassCastException;

    public boolean contains(String var1) throws CacheException, IllegalArgumentException;

    public Map<String, Boolean> containsBulk(Iterable<String> var1) throws CacheException;

    public void clear() throws CacheException;

    public void clearClientCache() throws CacheException;

    public void unlock(String var1) throws CacheException, IllegalArgumentException;

    public void unlock(String var1, LockHandle var2) throws CacheException, IllegalArgumentException;

    public boolean lock(String var1, TimeSpan var2, LockHandle var3) throws CacheException, IllegalArgumentException;

    public CacheStream getCacheStream(String var1, CacheStreamAttributes var2) throws CacheException, IllegalArgumentException;

    public Iterator asJsonIterator();
}

