/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import com.alachisoft.ncache.client.Cache;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.DisconnectedClientCache;
import com.alachisoft.ncache.client.internal.util.ConfigReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import tangible.DotNetToJavaStringHelper;
import tangible.RefObject;

public class CacheCollection
implements Iterable<CacheImpl> {
    private HashMap caches = new HashMap(8);

    public void addCache(String cacheId, CacheImpl c) {
        this.caches.put(cacheId.toLowerCase(), c);
    }

    public boolean contains(String cacheId) {
        return this.caches.containsKey(cacheId.toLowerCase());
    }

    public CacheImpl removeCache(String cacheId) {
        return (CacheImpl)this.caches.remove(cacheId.toLowerCase());
    }

    public int size() {
        return this.caches.size();
    }

    public Collection values() {
        return this.caches.values();
    }

    public CacheImpl getCache(String cacheId) {
        return (CacheImpl)this.caches.get(cacheId.toLowerCase());
    }

    public CacheImpl getCache(String cacheId, boolean useClientCache) throws Exception {
        String clientCache = "";
        boolean isPessimistic = false;
        RefObject tempRef_clientCache = new RefObject((Object)clientCache);
        RefObject tempRef_isPessimistic = new RefObject((Object)isPessimistic);
        boolean tempVar = useClientCache && this.hasClientCache(cacheId, (RefObject<String>)tempRef_clientCache, (RefObject<Boolean>)tempRef_isPessimistic);
        clientCache = (String)tempRef_clientCache.argvalue;
        isPessimistic = (Boolean)tempRef_isPessimistic.argvalue;
        if (tempVar && !DotNetToJavaStringHelper.isNullOrEmpty((String)clientCache)) {
            Object tempClientCache = this.caches.get(clientCache.toLowerCase());
            Object tempCacheId = this.caches.get(cacheId.toLowerCase());
            CacheImpl l1 = tempClientCache instanceof CacheImpl ? (CacheImpl)tempClientCache : null;
            CacheImpl l2 = tempCacheId instanceof CacheImpl ? (CacheImpl)tempCacheId : null;
            return new DisconnectedClientCache(l2, l1, l2.getSecurityParameters().getUserID(), l2.getSecurityParameters().getPassword(), isPessimistic);
        }
        return this.caches.get(cacheId.toLowerCase()) instanceof Cache ? (CacheImpl)this.caches.get(cacheId.toLowerCase()) : null;
    }

    @Override
    public Iterator<CacheImpl> iterator() {
        return new CacheIterator();
    }

    public boolean hasClientCache(String cacheId, RefObject<String> clientCacheID, RefObject<Boolean> isPessimistic) throws Exception {
        if (cacheId == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: cacheId");
        }
        clientCacheID.argvalue = ConfigReader.ClientCacheID("client.ncconf", cacheId, isPessimistic).trim().toString();
        return ((String)clientCacheID.argvalue).length() > 0;
    }

    private class CacheIterator
    implements Iterator<CacheImpl> {
        private HashMap _caches;
        Iterator keys;

        private CacheIterator() {
            this._caches = (HashMap)CacheCollection.this.caches.clone();
            this.keys = this._caches.keySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.keys.hasNext();
        }

        @Override
        public CacheImpl next() {
            return (CacheImpl)this._caches.get((String)this.keys.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

