/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client;

import Alachisoft.NCache.Caching.EventCacheEntry;
import Alachisoft.NCache.Caching.EventId;
import Alachisoft.NCache.Caching.Queries.QueryChangeType;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.EventCacheItem;
import com.alachisoft.ncache.client.MessageItem;
import com.alachisoft.ncache.client.internal.caching.CacheItemRemovedReason;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.messaging.MessageCollectionEventItem;
import com.alachisoft.ncache.client.internal.messaging.MessageEventItem;
import com.alachisoft.ncache.common.protobuf.BulkEventItemResponseProtocol;
import com.alachisoft.ncache.common.protobuf.EventCacheItemCommandProtocol;
import com.alachisoft.ncache.common.protobuf.EventIdProtocol;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.MessageEventArgs;
import com.alachisoft.ncache.runtime.caching.datasource.ResyncOptions;
import com.alachisoft.ncache.runtime.events.EventType;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import tangible.DotNetToJavaStringHelper;

public final class EventUtil {
    public static EventId convertToEventID(BulkEventItemResponseProtocol.BulkEventItemResponse eventItem, Alachisoft.NCache.Persistence.EventType eventType) {
        EventId eventId = new EventId();
        switch (eventType) {
            case ITEM_ADDED_EVENT: {
                EventIdProtocol.EventId varEventId = eventItem.getItemAddedEvent().getEventId();
                eventId.setEventUniqueID(varEventId.getEventUniqueId());
                eventId.setEventCounter(varEventId.getEventCounter());
                eventId.setOperationCounter(varEventId.getOperationCounter());
                eventId.setEventType(Alachisoft.NCache.Persistence.EventType.ITEM_ADDED_EVENT);
                break;
            }
            case ITEM_UPDATED_EVENT: {
                EventIdProtocol.EventId varEventId = eventItem.getItemUpdatedEvent().getEventId();
                eventId.setEventUniqueID(varEventId.getEventUniqueId());
                eventId.setEventCounter(varEventId.getEventCounter());
                eventId.setOperationCounter(varEventId.getOperationCounter());
                eventId.setEventType(Alachisoft.NCache.Persistence.EventType.ITEM_UPDATED_EVENT);
                break;
            }
            case ITEM_UPDATED_CALLBACK: {
                EventIdProtocol.EventId varEventId = eventItem.getItemUpdatedCallback().getEventId();
                eventId.setEventUniqueID(varEventId.getEventUniqueId());
                eventId.setEventCounter(varEventId.getEventCounter());
                eventId.setOperationCounter(varEventId.getOperationCounter());
                eventId.setEventType(Alachisoft.NCache.Persistence.EventType.ITEM_UPDATED_CALLBACK);
                break;
            }
            case CQ_CALLBACK: {
                EventIdProtocol.EventId varEventId = eventItem.getCQCallback().getEventId();
                eventId.setEventUniqueID(varEventId.getEventUniqueId());
                eventId.setEventCounter(varEventId.getEventCounter());
                eventId.setOperationCounter(varEventId.getOperationCounter());
                eventId.setEventType(Alachisoft.NCache.Persistence.EventType.CQ_CALLBACK);
                eventId.setQueryChangeType(QueryChangeType.forValue((int)eventItem.getCQCallback().getChangeType()));
                eventId.setQueryId(eventItem.getCQCallback().getQueryId());
                break;
            }
            case ITEM_REMOVED_CALLBACK: {
                EventIdProtocol.EventId varEventId = eventItem.getItemRemoveCallback().getEventId();
                eventId.setEventUniqueID(varEventId.getEventUniqueId());
                eventId.setEventCounter(varEventId.getEventCounter());
                eventId.setOperationCounter(varEventId.getOperationCounter());
                eventId.setEventType(Alachisoft.NCache.Persistence.EventType.ITEM_REMOVED_CALLBACK);
                break;
            }
            case ITEM_REMOVED_EVENT: {
                EventIdProtocol.EventId varEventId = eventItem.getItemRemovedEvent().getEventId();
                eventId.setEventUniqueID(varEventId.getEventUniqueId());
                eventId.setEventCounter(varEventId.getEventCounter());
                eventId.setOperationCounter(varEventId.getOperationCounter());
                eventId.setEventType(Alachisoft.NCache.Persistence.EventType.ITEM_REMOVED_EVENT);
                break;
            }
            case CACHE_CLEARED_EVENT: {
                EventIdProtocol.EventId varEventId = eventItem.getCacheClearedEvent().getEventId();
                eventId.setEventUniqueID(varEventId.getEventUniqueId());
                eventId.setEventCounter(varEventId.getEventCounter());
                eventId.setOperationCounter(varEventId.getOperationCounter());
                eventId.setEventType(Alachisoft.NCache.Persistence.EventType.CACHE_CLEARED_EVENT);
            }
        }
        return eventId;
    }

    public static EventCacheItem convertToEventEntry(EventCacheItemCommandProtocol.EventCacheItem cacheItem) {
        byte[] objectValue = null;
        if (cacheItem == null) {
            return null;
        }
        EventCacheItem eventCacheItem = new EventCacheItem();
        eventCacheItem.setCacheItemPriority(CacheItemPriority.forValue((int)cacheItem.getPriority()));
        eventCacheItem.setCacheItemVersion(new CacheItemVersion(cacheItem.getItemVersion()));
        eventCacheItem.setGroup(DotNetToJavaStringHelper.isNullOrEmpty((String)cacheItem.getGroup()) ? null : cacheItem.getGroup());
        eventCacheItem.setReSyncExpiredItems(cacheItem.getResyncExpiredItems());
        eventCacheItem.setResyncOptions(new ResyncOptions(cacheItem.getResyncExpiredItems(), cacheItem.getResyncProviderName()));
        List cacheItemValueList = cacheItem.getValueList();
        ArrayList<byte[]> bite = new ArrayList<byte[]>();
        for (ByteString byteString : cacheItemValueList) {
            bite.add(byteString.toByteArray());
        }
        if (cacheItemValueList != null && !cacheItemValueList.isEmpty()) {
            UserBinaryObject ubObject = UserBinaryObject.createUserBinaryObject(Arrays.asList(bite.toArray()));
            objectValue = ubObject.getFullObject();
            eventCacheItem.setValue(objectValue);
        }
        return eventCacheItem;
    }

    public static EventCacheItem convertToItem(EventCacheEntry entry) {
        byte[] objectValue = null;
        EventCacheItem item = new EventCacheItem();
        item.setCacheItemPriority(CacheItemPriority.forValue((int)entry.getPriority()));
        CacheItemVersion version = new CacheItemVersion(entry.getVersion());
        version.setVersion(entry.getVersion());
        item.setCacheItemVersion(version);
        item.setGroup(entry.getGroup());
        item.setReSyncExpiredItems(entry.getReSyncExpiredItems());
        item.setResyncOptions(new ResyncOptions(entry.getReSyncExpiredItems(), entry.getReSyncProviderCacheItem()));
        if (entry.getValue() != null) {
            UserBinaryObject ubObject = (UserBinaryObject)(entry.getValue() instanceof UserBinaryObject ? entry.getValue() : null);
            if (ubObject != null) {
                objectValue = ubObject.getFullObject();
                item.setValue(objectValue);
            } else {
                item.setValue(entry.getValue());
            }
        }
        return item;
    }

    public static CacheItemRemovedReason convertToCIRemoveReason(CacheItemRemovedReason reason) {
        switch (reason) {
            case DependencyChanged: {
                return CacheItemRemovedReason.DependencyChanged;
            }
            case DependencyInvalid: {
                return CacheItemRemovedReason.DependencyChanged;
            }
            case Expired: {
                return CacheItemRemovedReason.Expired;
            }
            case Removed: {
                return CacheItemRemovedReason.Removed;
            }
            case Underused: {
                return CacheItemRemovedReason.Underused;
            }
        }
        return CacheItemRemovedReason.Underused;
    }

    public static EventType getEventType(EnumSet<EventType> eventEnumSet) {
        if (eventEnumSet.contains(EventType.ItemAdded)) {
            return EventType.ItemAdded;
        }
        if (eventEnumSet.contains(EventType.ItemRemoved)) {
            return EventType.ItemRemoved;
        }
        if (eventEnumSet.contains(EventType.ItemUpdated)) {
            return EventType.ItemUpdated;
        }
        return EventType.ItemAdded;
    }

    public static EventType getEventType(EventTypeInternal eventType) {
        EventType type = EventType.ItemAdded;
        if (eventType == EventTypeInternal.ItemAdded) {
            type = EventType.ItemAdded;
        } else if (eventType == EventTypeInternal.ItemUpdated) {
            type = EventType.ItemUpdated;
        } else if (eventType == EventTypeInternal.ItemRemoved) {
            type = EventType.ItemRemoved;
        }
        return type;
    }

    public static EventTypeInternal getEventTypeInternal(EnumSet<EventType> eventType) {
        EventTypeInternal eventTypeInternal = EventTypeInternal.None;
        for (EventType type : EventType.values()) {
            if (type == EventType.ItemAdded) {
                eventTypeInternal = EventTypeInternal.ItemAdded;
                continue;
            }
            if (type == EventType.ItemUpdated) {
                eventTypeInternal = EventTypeInternal.ItemUpdated;
                continue;
            }
            if (type != EventType.ItemRemoved) continue;
            eventTypeInternal = EventTypeInternal.ItemRemoved;
        }
        return eventTypeInternal;
    }

    public static EnumSet<EventTypeInternal> getEventTypeInternalEnumSet(EnumSet<EventType> eventTypes) {
        if (eventTypes == null) {
            return EnumSet.of(EventTypeInternal.None);
        }
        EnumSet<EventTypeInternal> eventTypeInternalEnumSet = EnumSet.noneOf(EventTypeInternal.class);
        for (EventType type : eventTypes) {
            eventTypeInternalEnumSet.add(EventTypeInternal.forValue(type.getValue()));
        }
        return eventTypeInternalEnumSet;
    }

    public static EventTypeInternal getEventTypeInternal(EventType eventType) {
        EventTypeInternal eventTypeInternal = EventTypeInternal.None;
        if (eventType == EventType.ItemAdded) {
            eventTypeInternal = EventTypeInternal.ItemAdded;
        } else if (eventType == EventType.ItemUpdated) {
            eventTypeInternal = EventTypeInternal.ItemUpdated;
        } else if (eventType == EventType.ItemRemoved) {
            eventTypeInternal = EventTypeInternal.ItemRemoved;
        }
        return eventTypeInternal;
    }

    public static MessageItemType getMessageItemType(MessageItem messageItem) {
        if (messageItem != null && messageItem.getPayload() != null) {
            if (messageItem.getPayload() instanceof MessageEventItem[]) {
                return MessageItemType.MessageEventItems;
            }
            if (messageItem.getPayload() instanceof MessageEventItem) {
                return MessageItemType.MessageEventItem;
            }
            if (messageItem.getPayload() instanceof MessageCollectionEventItem) {
                return MessageItemType.MessageEventCollection;
            }
            if (messageItem.getPayload() instanceof MessageCollectionEventItem[]) {
                return MessageItemType.MessageEventCollections;
            }
            return MessageItemType.MessageItems;
        }
        return MessageItemType.MessageItems;
    }

    public static MessageItemType getMessageItemType(MessageEventArgs messageEventArgs) {
        if (messageEventArgs != null && messageEventArgs.getMessage() != null && messageEventArgs.getMessage().getPayload() != null) {
            if (messageEventArgs.getMessage().getPayload() instanceof MessageEventItem[]) {
                return MessageItemType.MessageEventItems;
            }
            if (messageEventArgs.getMessage().getPayload() instanceof MessageEventItem) {
                return MessageItemType.MessageEventItem;
            }
            if (messageEventArgs.getMessage().getPayload() instanceof MessageCollectionEventItem) {
                return MessageItemType.MessageEventCollection;
            }
            if (messageEventArgs.getMessage().getPayload() instanceof MessageCollectionEventItem[]) {
                return MessageItemType.MessageEventCollections;
            }
            return MessageItemType.MessageItems;
        }
        return MessageItemType.MessageItems;
    }

    public static enum MessageItemType {
        MessageEventItem,
        MessageEventItems,
        MessageItems,
        MessageEventCollection,
        MessageEventCollections;


        public static MessageItemType forValue(int value) {
            return MessageItemType.values()[value];
        }

        public int getValue() {
            return this.ordinal();
        }
    }
}

