/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CallbackEntry;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.CompressionUtil;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.IDisposable;
import Alachisoft.NCache.Common.Stats.UsageStats;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import com.alachisoft.ncache.client.CacheClearedListener;
import com.alachisoft.ncache.client.CacheClientConnectivityChangedListener;
import com.alachisoft.ncache.client.CacheStatusEventListener;
import com.alachisoft.ncache.client.CacheStatusNotificationType;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.ClusterEvent;
import com.alachisoft.ncache.client.ConnectivityStatus;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ContinuousQueryManager;
import com.alachisoft.ncache.client.internal.caching.EventManager;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.ArrayList;

class CacheEventsListener
implements IDisposable {
    private CacheImpl _parent;
    private EventManager _eventManager;
    private ContinuousQueryManager continuousQueryManager;

    public CacheEventsListener(CacheImpl parent, EventManager eventManager) {
        this._parent = parent;
        this._eventManager = eventManager;
        this.continuousQueryManager = this._parent._cqManager;
    }

    public void dispose() {
    }

    public void onCacheStopped(final String cacheId, boolean notifyAsync) {
        try {
            ArrayList<CacheStatusEventListener> listeners = this._parent.getCacheStoppedListeners();
            if (listeners != null && !listeners.isEmpty()) {
                for (final CacheStatusEventListener listener : listeners) {
                    if (notifyAsync) {
                        Runnable runable = new Runnable(){

                            @Override
                            public void run() {
                                listener.onCacheStatusChanged(new ClusterEvent(this, CacheStatusNotificationType.CacheStopped, cacheId));
                            }
                        };
                        ThreadPool.getInstance().executeTask(runable);
                        continue;
                    }
                    listener.onCacheStatusChanged(new ClusterEvent(this, CacheStatusNotificationType.CacheStopped, cacheId));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void OnPollNotified(short callbackId, EventTypeInternal eventType) {
        this._eventManager.raisePollNotification(callbackId, eventType);
    }

    public void OnCacheCleared(boolean notifyAsync) {
        try {
            ArrayList<CacheClearedListener> listeners = this._parent.getCacheClearedListeners();
            if (listeners != null && !listeners.isEmpty()) {
                for (final CacheClearedListener listener : listeners) {
                    if (notifyAsync) {
                        Runnable runable = new Runnable(){

                            @Override
                            public void run() {
                                listener.onCacheCleared();
                            }
                        };
                        ThreadPool.getInstance().executeTask(runable);
                        continue;
                    }
                    listener.onCacheCleared();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Object GetObject(Object value, BitSet Flag) throws Exception {
        try {
            if (value instanceof CallbackEntry) {
                value = ((CallbackEntry)value).getValue();
            }
            if (value instanceof UserBinaryObject) {
                value = ((UserBinaryObject)value).getFullObject();
            }
            if (Flag.IsBitSet(Byte.parseByte(String.valueOf(this._parent.getCompressionEnabled())))) {
                value = CompressionUtil.Decompress((byte[])((byte[])value));
            }
            if (this._parent.getCacheImpl().getEncryptionEnabled()) {
                UsageStats statsEncryption = new UsageStats();
                statsEncryption.BeginSample();
                value = CacheHelper.DecryptData((byte[])value, this._parent.getSerializationContext());
                statsEncryption.EndSample();
            }
            return this._parent.safeDeserialize(value, this._parent.getSerializationContext(), Flag, UserObjectType.CacheItem, null);
        }
        catch (RuntimeException ex) {
            return value;
        }
    }

    public void OnReregisterTopic() throws CacheException {
        this._parent._messagingService.OnReregisterTopic();
    }

    public void OnClientConnectivityChange(final String cacheId, final ClientInfo clientInfo, ConnectivityStatus status) {
        ArrayList<CacheClientConnectivityChangedListener> changedListeners = this._parent.getCacheClientConnectivityChangedListeners();
        if (changedListeners != null && !changedListeners.isEmpty()) {
            for (final CacheClientConnectivityChangedListener listener : changedListeners) {
                Runnable threadAsync = new Runnable(){

                    @Override
                    public void run() {
                        listener.onClientConnectivityChanged(cacheId, clientInfo);
                    }
                };
                ThreadPool.getInstance().executeTask(threadAsync);
            }
        }
    }
}

