/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Common.Base64;
import Alachisoft.NCache.Common.EncryptionUtil;
import com.alachisoft.ncache.client.Credentials;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ValueEmissary;
import com.alachisoft.ncache.client.internal.datastructure.DataTypeCreator;
import com.alachisoft.ncache.client.internal.util.ConfigReader;
import com.alachisoft.ncache.common.caching.EntryType;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.encryption.EncryptionMgr;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CacheHelper {
    public static String _clientCacheID = "";

    public static byte[] EncryptData(byte[] data, String cacheName) {
        byte[] bite = EncryptionMgr.Encryption((byte[])data, (String)cacheName);
        return bite;
    }

    public static byte[] DecryptData(byte[] data, String cacheName) {
        byte[] bite = EncryptionMgr.Decrypt((byte[])data, (String)cacheName);
        return bite;
    }

    public static <T> T getObjectOrInitializedCollection(String key, EntryType entryType, Object obj, CacheImpl cache, Class<?> cls) throws OperationFailedException {
        switch (entryType) {
            case CacheItem: {
                return (T)obj;
            }
        }
        return (T)DataTypeCreator.createDataTypeHandle(entryType, key, cache, cls);
    }

    public static <T> T getSafeValue(Object value) {
        return (T)(value != null ? value : null);
    }

    public static Object getObjectOrDataTypeForCacheItem(String key, EntryType entryType, Object obj) {
        if (obj.getClass() == ValueEmissary.class) {
            return obj;
        }
        ValueEmissary valueEmissary = new ValueEmissary();
        valueEmissary.setKey(key);
        valueEmissary.setData(obj);
        valueEmissary.setType(entryType);
        return valueEmissary;
    }

    public static byte EvaluateExpirationParameters(Date absoluteExpiration, TimeSpan slidingExpiration) {
        if (CacheImpl.NoAbsoluteExpiration.equals(absoluteExpiration) && CacheImpl.NoSlidingExpiration.equals(slidingExpiration)) {
            return 2;
        }
        if (CacheImpl.NoAbsoluteExpiration.equals(absoluteExpiration)) {
            if (slidingExpiration != CacheImpl.DefaultSliding && slidingExpiration != CacheImpl.DefaultSlidingLonger && slidingExpiration.compareTo(TimeSpan.Zero) < 0) {
                throw new IllegalArgumentException("slidingExpiration");
            }
            return 0;
        }
        if (CacheImpl.NoSlidingExpiration.equals(slidingExpiration)) {
            return 1;
        }
        throw new IllegalArgumentException("You cannot set both sliding and absolute expirations on the same cache item.");
    }

    public static ArrayList<Credentials> LoadCredentialsFromConfig(String cacheId) throws ConfigurationException {
        ArrayList<Credentials> paramsList = new ArrayList<Credentials>();
        paramsList.add(new Credentials("", ""));
        paramsList.add(new Credentials("", ""));
        try {
            HashMap tbl = ConfigReader.ReadSecurityParams("client.ncconf", cacheId);
            if (tbl != null) {
                String sec_password;
                String pri_password;
                HashMap primary_user = (HashMap)tbl.get("pri-user");
                HashMap secondary_user = (HashMap)tbl.get("sec-user");
                if (primary_user != null && primary_user.containsKey("user-id") && primary_user.containsKey("password") && !(pri_password = (String)primary_user.get("password")).equals("")) {
                    paramsList.set(0, new Credentials((String)primary_user.get("user-id"), EncryptionUtil.Decrypt((byte[])Base64.decode((String)pri_password))));
                }
                if (secondary_user != null && secondary_user.containsKey("user-id") && secondary_user.containsKey("password") && !(sec_password = (String)secondary_user.get("password")).equals("")) {
                    paramsList.set(1, new Credentials((String)secondary_user.get("user-id"), EncryptionUtil.Decrypt((byte[])Base64.decode((String)sec_password))));
                }
            }
            return paramsList;
        }
        catch (ConfigurationException e) {
            throw new ConfigurationException("An error occured while reading client.ncconf. " + e.getMessage());
        }
    }

    public static Map bulkGetObjectOrInitializedCollection(Map returnItems, CacheImpl parent) throws OperationFailedException {
        HashMap updatedMap = new HashMap();
        Iterator iterator = returnItems.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            CompressedValueEntry cmpEntry = (CompressedValueEntry)entry.getValue();
            cmpEntry.setValue(CacheHelper.getObjectOrInitializedCollection(entry.getKey().toString(), cmpEntry.getType(), cmpEntry.getValue(), parent, null));
            updatedMap.put(entry.getKey(), entry.getValue());
        }
        return updatedMap;
    }

    public static String[] getTags(Tag[] tags) {
        String[] sTags = new String[tags.length];
        for (int i = 0; i < tags.length; ++i) {
            sTags[i] = tags[i].getTagName();
        }
        return sTags;
    }
}

