/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.EncryptionUtil;
import Alachisoft.NCache.Common.Enum.SerializationFormat;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheItemWrapperInternal;
import com.alachisoft.ncache.client.CacheReader;
import com.alachisoft.ncache.client.CacheStream;
import com.alachisoft.ncache.client.CacheStreamAttributes;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.ContinuousQuery;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.datastructures.DataStructureManager;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ClientCacheSearchService;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.RemoteCache;
import com.alachisoft.ncache.client.internal.caching.TargetMethodAttribute;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.client.services.MessagingService;
import com.alachisoft.ncache.client.services.NotificationService;
import com.alachisoft.ncache.client.services.SearchService;
import com.alachisoft.ncache.common.caching.EntryType;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.CacheItemAttributes;
import com.alachisoft.ncache.runtime.caching.DataSourceModifiedListener;
import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.caching.datasource.ResyncOptions;
import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationType;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.errorhandling.ErrorMessages;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.alachisoft.ncache.security.encryption.EncryptionMgr;
import com.alachisoft.ncache.serialization.standard.CompactBinaryFormatter;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.FutureTask;
import tangible.RefObject;

public class ClientCache
extends CacheImpl {
    private CacheImpl _nearCache;
    private CacheImpl _farCache;
    private boolean _isPessimistic = false;
    private SearchService _searchService;
    private boolean _sldDefaultEnabled;
    private boolean _sldLongerEnabled;
    private boolean _absDefaultEnabled;
    private boolean _absLongerEnabled;
    private long _sldDefault;
    private long _sldLonger;
    private long _absDefault;
    private long _absLonger;
    private String _userId;
    private byte[] _password;

    public ClientCache(CacheImpl l2, CacheImpl nearCache, String userid, String password, boolean isPessimistic) throws Exception {
        if (nearCache == null) {
            throw new OperationFailedException(10007, ErrorMessages.getErrorMessage((int)10007, (String[])new String[0]));
        }
        if (l2 == null) {
            throw new OperationFailedException(10008, ErrorMessages.getErrorMessage((int)10008, (String[])new String[0]));
        }
        this._nearCache = nearCache;
        this._farCache = l2;
        this.InitializeEncryption();
        this.getClientExpiration();
        this._nearCache.setQueryTypeInfoMap(this._farCache.getQueryTypeMap());
        this._isPessimistic = isPessimistic;
        this._nearCache.setSerializationContext(this._farCache.getSerializationContext());
        this._nearCache.setSerializationFormat(this._farCache.getSerializationFormat());
        this._searchService = new ClientCacheSearchService(this._farCache, this._nearCache);
        if (userid != null) {
            this._userId = userid;
        }
        if (password != null) {
            this._password = EncryptionUtil.Encrypt((String)password);
        }
    }

    final void getClientExpiration() {
        HashMap expirationInfo = ((RemoteCache)this._farCache.getCacheImpl()).GetExpirationInfo();
        if (expirationInfo != null) {
            this._absDefault = (Long)expirationInfo.get("absDefault");
            this._absLonger = (Long)expirationInfo.get("absLonger");
            this._sldDefault = (Long)expirationInfo.get("sldDefault");
            this._sldLonger = (Long)expirationInfo.get("sldLonger");
            this._absDefaultEnabled = (Boolean)expirationInfo.get("absDefaultEnabled");
            this._absLongerEnabled = (Boolean)expirationInfo.get("absLongerEnabled");
            this._sldDefaultEnabled = (Boolean)expirationInfo.get("sldDefaultEnabled");
            this._sldLongerEnabled = (Boolean)expirationInfo.get("sldLongerEnabled");
        }
    }

    final Map<String, Exception> insertBulkOperation(Map<String, CacheItem> items, WriteMode writeMode, String provider, DataSourceModifiedListener dataSourceModifiedListener, EventTypeInternal eventType, String clientId, short updateCallbackId, short removeCallbackId, short dataSourceUpdatedCallbackId) throws CacheException {
        Map<String, Exception> insertResult;
        block10: {
            if (items == null) {
                throw new IllegalArgumentException("items");
            }
            if (items.isEmpty()) {
                throw new IllegalArgumentException("Adding empty dictionary into cache.");
            }
            HashMap<String, CacheItem> itemsToUpdate = new HashMap<String, CacheItem>();
            long[] sizes = new long[items.size()];
            long[] updateSize = null;
            insertResult = null;
            try {
                this._nearCache.removeBulk(items.keySet(), null, Object.class);
                RefObject tempRef_sizes = new RefObject((Object)sizes);
                RefObject tempRef_itemVersions = new RefObject(null);
                insertResult = this._farCache.InsertBulkInternal(items, writeMode, dataSourceModifiedListener, eventType, provider, (RefObject<long[]>)tempRef_sizes, true, null, (short)-1, (short)-1, (short)-1, EventDataFilter.None, EventDataFilter.None, false, (RefObject<Map>)tempRef_itemVersions);
                if (insertResult == null || insertResult.isEmpty()) {
                    for (Map.Entry<String, CacheItem> item : items.entrySet()) {
                        if (itemsToUpdate.containsKey(item.getKey())) continue;
                        itemsToUpdate.put(item.getKey(), this.getCompatibleItem(item.getValue()));
                    }
                    updateSize = sizes;
                } else if (insertResult.size() < items.size()) {
                    updateSize = new long[items.size() - insertResult.size()];
                    for (Map.Entry<String, CacheItem> item : items.entrySet()) {
                        if (insertResult.containsKey(item.getKey())) continue;
                        CacheItem l2item = item.getValue();
                        CacheItem newItem = new CacheItem(l2item.getValue(Object.class));
                        Expiration tempVar2 = new Expiration(ExpirationType.Absolute);
                        tempVar2.setExpireAfter(TimeSpan.subtract((Date)new Date(), (Date)this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(newItem.getExpiration()), ConversionUtil.getSlidingExpiration(newItem.getExpiration()))));
                        newItem.setExpiration(tempVar2);
                        newItem.setResyncOptions(l2item.getResyncOptions());
                        newItem.setCacheItemPriority(l2item.getCacheItemPriority());
                        newItem.setSyncDependency(new CacheSyncDependency(this._farCache._cacheId, item.getKey(), this._userId, this._password));
                        if (itemsToUpdate.containsKey(item.getKey())) continue;
                        itemsToUpdate.put(item.getKey(), newItem);
                    }
                }
                if (itemsToUpdate.size() > 0) {
                    RefObject tempRef_updateSize = new RefObject((Object)updateSize);
                    tempRef_itemVersions = new RefObject(null);
                    this._nearCache.InsertBulkInternal(itemsToUpdate, WriteMode.None, null, EventTypeInternal.None, null, (RefObject<long[]>)tempRef_updateSize, true, null, (short)-1, (short)-1, (short)-1, EventDataFilter.None, EventDataFilter.None, false, (RefObject<Map>)tempRef_itemVersions);
                }
            }
            catch (CacheException e) {
                if (!this._nearCache.getExceptionEnabled()) break block10;
                throw e;
            }
        }
        return insertResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Exception> addBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws StreamNotFoundException, StreamException, ConfigurationException, CommandException, AggregateException, GeneralFailureException, OperationNotSupportedException, OperationFailedException, StreamAlreadyLockedException, LicensingException, SecurityException {
        Map<String, Exception> failedkeys;
        block9: {
            Iterator<Map.Entry<String, CacheItem>> itemVersions;
            long[] sizes = new long[items.size()];
            try {
                String providerName = null;
                itemVersions = null;
                WriteMode mode = WriteMode.None;
                DataSourceModifiedListener dataSourceModifiedCallback = null;
                EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
                RefObject tempRef_mode = new RefObject((Object)mode);
                RefObject tempRef_providerName = new RefObject(providerName);
                RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedCallback);
                RefObject tempRef_eventTypes = new RefObject(eventTypes);
                ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
                mode = (WriteMode)tempRef_mode.argvalue;
                providerName = (String)tempRef_providerName.argvalue;
                dataSourceModifiedCallback = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
                eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
                EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
                failedkeys = this._farCache.AddBulkInternal(items, mode, dataSourceModifiedCallback, eventTypeInternal, providerName, true, null, (short)-1, (short)-1, (short)-1, EventDataFilter.None, EventDataFilter.None, false);
            }
            finally {
                TargetMethodAttribute.setMethodOverload(0);
            }
            if (failedkeys == null) {
                return null;
            }
            if (failedkeys.size() == items.size()) {
                return failedkeys;
            }
            HashMap<String, CacheItem> successfullItems = new HashMap<String, CacheItem>();
            for (Map.Entry<String, CacheItem> item : items.entrySet()) {
                if (failedkeys.containsKey(item.getKey())) continue;
                CacheItem l2item = item.getValue();
                CacheItem newItem = new CacheItem(l2item.getValue(Object.class));
                newItem.setCacheItemPriority(l2item.getCacheItemPriority());
                Expiration tempVar2 = new Expiration(ExpirationType.Absolute);
                tempVar2.setExpireAfter(TimeSpan.subtract((Date)new Date(), (Date)this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(l2item.getExpiration()), ConversionUtil.getSlidingExpiration(l2item.getExpiration()))));
                newItem.setExpiration(tempVar2);
                newItem.setResyncOptions(l2item.getResyncOptions());
                newItem.setSyncDependency(new CacheSyncDependency(this._farCache._cacheId, item.getKey(), this._userId, this._password));
                if (successfullItems.containsKey(item.getKey())) continue;
                successfullItems.put(item.getKey(), item.getValue());
            }
            try {
                itemVersions = null;
                this._nearCache.AddBulkInternal(successfullItems, WriteMode.None, null, EventTypeInternal.None, null, true, null, (short)-1, (short)-1, (short)-1, EventDataFilter.None, EventDataFilter.None, false);
            }
            catch (Exception e) {
                if (!this._nearCache.getExceptionEnabled()) break block9;
                throw e;
            }
        }
        return failedkeys;
    }

    @Override
    protected CacheItemVersion addOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode writeMode, DataSourceModifiedListener onDataSourceModified, EventTypeInternal eventTypeInternal, boolean isResyncExpiredItems, String group, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUpdatedListener, CacheDataModificationListener cacheItemRemovedListener, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, RefObject<Long> size, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dsItemAddedCallbackId) throws CacheException {
        CacheItemVersion result;
        block3: {
            result = this._farCache.addOperation(key, value, dependency, syncDependency, absoluteExpiration, slidingExpiration, priority, writeMode, onDataSourceModified, eventTypeInternal, isResyncExpiredItems, group, tags, providerName, resyncProviderName, namedTags, cacheItemUpdatedListener, cacheItemRemovedListener, itemUpdateDataFilter, itemRemovedDataFilter, size, allowQueryTags, clientId, updateCallbackId, removeCallbackId, dsItemAddedCallbackId);
            if (result == null) {
                return null;
            }
            try {
                this._nearCache.insertOperation(key, value, dependency, new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(absoluteExpiration, NoSlidingExpiration), slidingExpiration, priority, WriteMode.None, null, null, isResyncExpiredItems, group, null, new CacheItemVersion(result.getVersion()), LockAccessType.DEFAULT, tags, providerName, resyncProviderName, namedTags, null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
            }
            catch (CacheException e) {
                if (!this._nearCache.getExceptionEnabled()) break block3;
                throw e;
            }
        }
        return result;
    }

    @Override
    public void clear() throws CacheException {
        this._farCache.clear();
    }

    @Override
    public FutureTask clearAsync() {
        this._farCache.clearAsync();
        return this._nearCache.clearAsync();
    }

    @Override
    public void clearClientCache() throws CacheException {
        this._nearCache.clear();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException ex) {
            throw new CacheException((Throwable)ex);
        }
        this._nearCache.clear();
    }

    @Override
    public FutureTask clearClientCacheAsync() {
        return this._nearCache.clearAsync();
    }

    @Override
    public boolean contains(String key) throws CacheException {
        return this._farCache.contains(key);
    }

    @Override
    public Map<String, Boolean> containsBulk(Iterable<String> keys) throws CacheException {
        return this._farCache.containsBulk(keys);
    }

    public final long getAbsDefault() {
        return this._absDefault;
    }

    public final void setAbsDefault(long value) {
        this._absDefault = value;
    }

    public final boolean getAbsDefaultEnabled() {
        return this._absDefaultEnabled;
    }

    public final void setAbsDefaultEnabled(boolean value) {
        this._absDefaultEnabled = value;
    }

    public final long getAbsLonger() {
        return this._absLonger;
    }

    public final void setAbsLonger(long value) {
        this._absLonger = value;
    }

    public final boolean getAbsLongerEnabled() {
        return this._absLongerEnabled;
    }

    public final void setAbsLongerEnabled(boolean value) {
        this._absLongerEnabled = value;
    }

    @Override
    public CacheImpl getCacheInstanceInternal() {
        return this._farCache;
    }

    @Override
    public ClientInfo getClientInfo() throws CacheException {
        return this._farCache.getClientInfo();
    }

    final CacheItem getCompatibleItem(CacheItem l2CacheItem) throws OperationFailedException {
        if (l2CacheItem == null) {
            return null;
        }
        CacheItem l1CacheItem = new CacheItem(l2CacheItem.getValue(Object.class));
        l1CacheItem.setCacheItemPriority(l2CacheItem.getCacheItemPriority());
        Expiration tempVar = new Expiration(ExpirationType.Absolute);
        Date expiration = this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(l2CacheItem.getExpiration()), ConversionUtil.getSlidingExpiration(l2CacheItem.getExpiration()));
        if (expiration != NoAbsoluteExpiration) {
            tempVar.setExpireAfter(TimeSpan.subtract((Date)new Date(), (Date)expiration));
            l1CacheItem.setExpiration(tempVar);
        }
        l1CacheItem.setCacheItemVersion(l2CacheItem.getCacheItemVersion());
        l1CacheItem.setGroup(l2CacheItem.getGroup());
        l1CacheItem.setTags(l2CacheItem.getTags());
        l1CacheItem.setNamedTags(l2CacheItem.getNamedTags());
        l1CacheItem.setResyncOptions(l2CacheItem.getResyncOptions() == null ? new ResyncOptions(false, null) : l2CacheItem.getResyncOptions());
        return l1CacheItem;
    }

    @Override
    public List<ClientInfo> getConnectedClientList() throws CacheException {
        return this._farCache.getConnectedClientList();
    }

    @Override
    public long getCount() throws CacheException {
        return this._farCache.getCount();
    }

    @Override
    public DataStructureManager getDataStructuresManager() {
        return this._farCache.getDataStructuresManager();
    }

    @Override
    public boolean getExceptionEnabled() {
        return this._farCache.getExceptionEnabled();
    }

    @Override
    public MessagingService getMessagingService() throws CacheException {
        return this._farCache.getMessagingService();
    }

    @Override
    public NotificationService getNotificationService() throws CacheException {
        return this._farCache.getNotificationService();
    }

    public final byte[] getPassword() {
        return this._password;
    }

    public final void setPassword(byte[] value) {
        this._password = value;
    }

    @Override
    public SearchService getSearchService() {
        return this._searchService;
    }

    @Override
    public void setSearchService(SearchService value) {
        this._searchService = value;
    }

    @Override
    public SerializationFormat getSerializationFormat() {
        return this._farCache.getSerializationFormat();
    }

    @Override
    public void setSerializationFormat(SerializationFormat value) {
        super.setSerializationFormat(value);
    }

    private Date getServerExpiration(Expiration expiration) {
        return this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(expiration), ConversionUtil.getSlidingExpiration(expiration));
    }

    private Date getServerExpiration(Date absoluteExpiration, TimeSpan slidingExpiration) {
        Calendar c = Calendar.getInstance();
        if (absoluteExpiration == defaultAbsolute && this._absDefaultEnabled) {
            NCDateTime dateTime = new NCDateTime(new Date());
            dateTime.addTicks(TimeSpan.TimeToTicks((int)0, (int)0, (int)((int)this.getAbsDefault())));
            return dateTime.getDate();
        }
        if (absoluteExpiration == defaultAbsoluteLonger && this._absLongerEnabled) {
            NCDateTime dateTime = new NCDateTime(new Date());
            dateTime.addTicks(TimeSpan.TimeToTicks((int)0, (int)0, (int)((int)this.getAbsDefault())));
            return dateTime.getDate();
        }
        if (slidingExpiration == DefaultSliding && this._sldDefaultEnabled) {
            NCDateTime dateTime = new NCDateTime(new Date());
            dateTime.addTicks(TimeSpan.TimeToTicks((int)0, (int)0, (int)((int)this.getSldDefault())));
            return dateTime.getDate();
        }
        if (slidingExpiration == DefaultSlidingLonger && this._sldLongerEnabled) {
            NCDateTime dateTime = new NCDateTime(new Date());
            dateTime.addTicks(TimeSpan.TimeToTicks((int)0, (int)0, (int)((int)this.getSldLonger())));
            return dateTime.getDate();
        }
        if (absoluteExpiration == defaultAbsolute || absoluteExpiration == defaultAbsoluteLonger || slidingExpiration == DefaultSliding || slidingExpiration == DefaultSlidingLonger) {
            return NoAbsoluteExpiration;
        }
        if (absoluteExpiration != NoAbsoluteExpiration) {
            return absoluteExpiration;
        }
        if (slidingExpiration == NoSlidingExpiration) {
            return NoAbsoluteExpiration;
        }
        NCDateTime date = new NCDateTime(new Date());
        date.addTicks(slidingExpiration._ticks);
        return date.getDate();
    }

    public final long getSldDefault() {
        return this._sldDefault;
    }

    public final void setSldDefault(long value) {
        this._sldDefault = value;
    }

    public final boolean getSldDefaultEnabled() {
        return this._sldDefaultEnabled;
    }

    public final void setSldDefaultEnabled(boolean value) {
        this._sldDefaultEnabled = value;
    }

    public final long getSldLonger() {
        return this._sldLonger;
    }

    public final void setSldLonger(long value) {
        this._sldLonger = value;
    }

    public final boolean getSldLongerEnabled() {
        return this._sldLongerEnabled;
    }

    public final void setSldLongerEnabled(boolean value) {
        this._sldLongerEnabled = value;
    }

    public final String getUserId() {
        return this._userId;
    }

    public final void setUserId(String value) {
        this._userId = value;
    }

    @Override
    public Map<String, Exception> insertBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws CacheException {
        String providerName = null;
        WriteMode mode = WriteMode.None;
        DataSourceModifiedListener dataSourceModifiedListener = null;
        EnumSet eventTypes = EnumSet.of(EventTypeInternal.None);
        RefObject tempRef_mode = new RefObject((Object)mode);
        RefObject tempRef_providerName = new RefObject(providerName);
        RefObject tempRef_dataSourceModifiedCallback = new RefObject(dataSourceModifiedListener);
        RefObject tempRef_eventTypes = new RefObject(eventTypes);
        ConversionUtil.GetWriteOptions(writeThruOptions, (RefObject<WriteMode>)tempRef_mode, (RefObject<String>)tempRef_providerName, (RefObject<DataSourceModifiedListener>)tempRef_dataSourceModifiedCallback, (RefObject<EnumSet<EventTypeInternal>>)tempRef_eventTypes);
        mode = (WriteMode)tempRef_mode.argvalue;
        providerName = (String)tempRef_providerName.argvalue;
        dataSourceModifiedListener = (DataSourceModifiedListener)tempRef_dataSourceModifiedCallback.argvalue;
        eventTypes = (EnumSet)tempRef_eventTypes.argvalue;
        EventTypeInternal eventTypeInternal = (EventTypeInternal)((Object)eventTypes.toArray()[0]);
        return this.insertBulkOperation(items, mode, providerName, dataSourceModifiedListener, eventTypeInternal, null, (short)-1, (short)-1, (short)-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected CacheItemVersion insertOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode writeMode, DataSourceModifiedListener onDataSourceModified, EventTypeInternal eventType, boolean isResyncExpiredItems, String group, LockHandle lockHandle, CacheItemVersion version, LockAccessType accessType, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUpdated, CacheDataModificationListener cacheItemRemoved, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dsItemAddedCallbackId) throws CacheException, IllegalArgumentException {
        int prevMethodOcverload;
        boolean contained;
        CacheItemVersion newVersion;
        block14: {
            newVersion = null;
            contained = false;
            prevMethodOcverload = TargetMethodAttribute.getMethodOverload();
            String lockId = lockHandle == null ? null : lockHandle.getLockId();
            try {
                contained = this._nearCache.contains(key);
            }
            catch (CacheException e) {
                if (!this._nearCache.getExceptionEnabled()) break block14;
                throw e;
            }
        }
        if (!contained) {
            try {
                TargetMethodAttribute.setMethodOverload(prevMethodOcverload);
                newVersion = this._farCache.insertOperation(key, value, dependency, syncDependency, this.getServerExpiration(absoluteExpiration, NoSlidingExpiration), slidingExpiration, priority, writeMode, onDataSourceModified, eventType, isResyncExpiredItems, group, lockHandle, version, accessType, tags, providerName, resyncProviderName, namedTags, cacheItemUpdated, cacheItemRemoved, itemUpdateDataFilter, itemRemovedDataFilter, true, null, (short)-1, (short)-1, (short)-1);
            }
            finally {
                TargetMethodAttribute.setMethodOverload(0);
            }
            if (newVersion == null) {
                return null;
            }
            try {
                this._nearCache.insertOperation(key, value, dependency, new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(absoluteExpiration, NoSlidingExpiration), slidingExpiration, priority, WriteMode.None, null, EventTypeInternal.None, isResyncExpiredItems, group, null, newVersion, LockAccessType.PRESERVE_VERSION, tags, providerName, resyncProviderName, namedTags, null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                return newVersion;
            }
            catch (CacheException e2) {
                if (!this._nearCache.getExceptionEnabled()) return newVersion;
                throw e2;
            }
        }
        try {
            this._nearCache.delete(key);
            try {
                TargetMethodAttribute.setMethodOverload(prevMethodOcverload);
                newVersion = this._farCache.insertOperation(key, value, dependency, syncDependency, this.getServerExpiration(absoluteExpiration, NoSlidingExpiration), slidingExpiration, priority, writeMode, onDataSourceModified, eventType, isResyncExpiredItems, group, lockHandle, version, accessType, tags, providerName, resyncProviderName, namedTags, cacheItemUpdated, cacheItemRemoved, itemUpdateDataFilter, itemRemovedDataFilter, true, null, (short)-1, (short)-1, (short)-1);
            }
            finally {
                TargetMethodAttribute.setMethodOverload(0);
            }
            this._nearCache.insertOperation(key, value, dependency, new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(absoluteExpiration, NoSlidingExpiration), slidingExpiration, priority, WriteMode.None, null, EventTypeInternal.None, isResyncExpiredItems, group, null, newVersion, LockAccessType.PRESERVE_VERSION, tags, providerName, resyncProviderName, namedTags, null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
            return newVersion;
        }
        catch (CacheException e3) {
            if (!this._nearCache.getExceptionEnabled()) return newVersion;
            throw e3;
        }
    }

    @Override
    public boolean updateAttributes(String key, CacheItemAttributes attributes) throws CacheException {
        boolean success;
        block6: {
            success = false;
            if (key == null) {
                throw new IllegalArgumentException();
            }
            if (attributes == null) {
                throw new IllegalArgumentException();
            }
            if (this._farCache == null) {
                throw new OperationFailedException(10008, ErrorMessages.getErrorMessage((int)10008, (String[])new String[0]));
            }
            try {
                success = this._farCache.updateAttributes(key, attributes);
                if (success) {
                    success = this._nearCache.updateAttributes(key, attributes);
                }
            }
            catch (CacheException e) {
                if (!this.getExceptionEnabled()) break block6;
                throw e;
            }
        }
        return success;
    }

    @Override
    public <T> T remove(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions, Class<?> cls) throws CacheException {
        this._nearCache.remove(key, cls);
        return this._farCache.remove(key, lockHandle, version, writeThruOptions, cls);
    }

    @Override
    public <T> Map<String, T> removeBulk(Iterable<String> keys, WriteThruOptions writeThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        this._nearCache.removeBulk(keys, cls);
        return this._farCache.removeBulk(keys, writeThruOptions, cls);
    }

    @Override
    public void delete(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions) throws CacheException {
        this._nearCache.delete(key);
        this._farCache.delete(key, lockHandle, version, writeThruOptions);
    }

    @Override
    public void deleteBulk(Iterable<String> keys, WriteThruOptions writeThruOptions) throws CacheException {
        this._nearCache.deleteBulk(keys);
        this._farCache.deleteBulk(keys, writeThruOptions);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T get(String key, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        CacheItem cacheItem;
        T result;
        block17: {
            result = null;
            cacheItem = null;
            if (readThruOptions == null) {
                readThruOptions = new ReadThruOptions(ReadMode.None);
            }
            if (this._isPessimistic) {
                CacheItemVersion version = new CacheItemVersion();
                T localItem = null;
                if (readThruOptions.getReadMode() != ReadMode.ReadThruForced) {
                    localItem = this._nearCache.get(key, version, null, cls);
                }
                try {
                    if (localItem != null) {
                        result = this._farCache.getIfNewer(key, version, cls);
                        if (result == null) {
                            if (version != null && version.getVersion() != 0L) return null;
                            return localItem;
                        }
                    } else {
                        cacheItem = this._farCache.getCacheItem(key, version, readThruOptions);
                        if (cacheItem != null) {
                            version = cacheItem.getCacheItemVersion();
                        }
                    }
                    if (cacheItem == null) return result;
                    result = cacheItem.getValue(cls);
                    try {
                        cacheItem = this.getCompatibleItem(cacheItem);
                        this._nearCache.insertOperation(key, result, cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                        return result;
                    }
                    catch (CacheException e) {
                        if (!this._nearCache.getExceptionEnabled()) return result;
                        throw e;
                    }
                }
                catch (CacheException e2) {
                    if (!this._nearCache.getExceptionEnabled()) return result;
                    throw e2;
                }
            }
            try {
                if (readThruOptions.getReadMode() != ReadMode.ReadThruForced) {
                    result = this._nearCache.get(key, null, cls);
                }
            }
            catch (CacheException e3) {
                if (!this._nearCache.getExceptionEnabled()) break block17;
                throw e3;
            }
        }
        if (result != null) {
            return result;
        }
        CacheItemVersion version = new CacheItemVersion();
        cacheItem = this._farCache.getCacheItem(key, version, readThruOptions);
        if (cacheItem == null) return result;
        result = cacheItem.getValue(cls);
        try {
            if (CacheItemWrapperInternal.GetCacheItemEntryType(cacheItem) == null || CacheItemWrapperInternal.GetCacheItemEntryType(cacheItem) != EntryType.CacheItem) return result;
            cacheItem = this.getCompatibleItem(cacheItem);
            this._nearCache.insertOperation(key, cacheItem.getValue(cls), cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
            return result;
        }
        catch (CacheException e4) {
            if (!this._nearCache.getExceptionEnabled()) return result;
            throw e4;
        }
    }

    @Override
    public <T> T get(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        T result;
        block9: {
            CacheItem cacheItem;
            block8: {
                result = null;
                cacheItem = null;
                try {
                    result = this._nearCache.get(key, null, cls);
                }
                catch (CacheException e) {
                    if (!this._nearCache.getExceptionEnabled()) break block8;
                    throw e;
                }
            }
            if (result != null) {
                if (acquireLock ? !this.lock(key, lockTimeout, lockHandle) : this.isLocked(key, lockHandle)) {
                    return null;
                }
            } else {
                cacheItem = this._farCache.getCacheItem(key, acquireLock, lockTimeout, lockHandle);
                if (cacheItem != null) {
                    result = cacheItem.getValue(cls);
                    BitSet flagmap = CacheItemWrapperInternal.getFlagValue(cacheItem);
                    long size = 0L;
                    this._farCache.safeSerialize(result, this._farCache._cacheId, flagmap, size, UserObjectType.CacheItem);
                    try {
                        cacheItem = this.getCompatibleItem(cacheItem);
                        this._nearCache.insertOperation(key, cacheItem.getValue(cls), cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, null, LockAccessType.IGNORE_LOCK, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                    }
                    catch (CacheException e2) {
                        if (!this._nearCache.getExceptionEnabled()) break block9;
                        throw e2;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public <T> T get(String key, CacheItemVersion version, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        CacheItem cacheItem;
        block8: {
            cacheItem = this._farCache.getCacheItem(key, version, readThruOptions);
            if (cacheItem != null) {
                if (version != null && cacheItem.getCacheItemVersion().getVersion() != version.getVersion() && version.getVersion() != 0L) {
                    version.setVersion(cacheItem.getCacheItemVersion().getVersion());
                    if (readThruOptions == null || readThruOptions.getReadMode() == ReadMode.None) {
                        return null;
                    }
                } else {
                    version.setVersion(cacheItem.getCacheItemVersion().getVersion());
                }
                try {
                    if (this._nearCache.contains(key)) break block8;
                    byte[] seralized = null;
                    try {
                        seralized = CompactBinaryFormatter.toByteBuffer(cacheItem.getValue(cls), (String)this._farCache._cacheId);
                    }
                    catch (IOException e) {
                        throw new OperationFailedException((Throwable)e);
                    }
                    long size = seralized instanceof byte[] ? (long)seralized.length : 0L;
                    cacheItem = this.getCompatibleItem(cacheItem);
                    this._nearCache.insertOperation(key, cacheItem.getValue(cls), cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                }
                catch (CacheException e) {
                    if (!this._nearCache.getExceptionEnabled()) break block8;
                    throw e;
                }
            }
        }
        return cacheItem != null ? (T)cacheItem.getValue(cls) : null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public <T> T getInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readOptions, Class<?> cls) throws CacheException {
        CacheItem cacheItem;
        T result;
        block14: {
            result = null;
            cacheItem = null;
            if (this._isPessimistic) {
                try {
                    CacheItem cItem = this._nearCache.getCacheItem(key, readOptions);
                    T localItem = null;
                    if (cItem != null) {
                        localItem = cItem.getValue(cls);
                        version = cItem.getCacheItemVersion();
                    }
                    if (localItem != null) {
                        result = this._farCache.getIfNewer(key, version, cls);
                        if (result == null) {
                            if (version != null) return null;
                            return localItem;
                        }
                    } else {
                        cacheItem = this._farCache.getCacheItemInternal(key, version, accessType, lockTimeout, lockHandle, readOptions);
                    }
                    if (cacheItem == null) return result;
                    result = cacheItem.getValue(cls);
                    long size = ((byte[])result).length;
                    try {
                        cacheItem = this.getCompatibleItem(cacheItem);
                        this._nearCache.insertOperation(key, result, cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                        return result;
                    }
                    catch (CacheException e) {
                        if (!this._nearCache.getExceptionEnabled()) return result;
                        throw e;
                    }
                }
                catch (CacheException e2) {
                    if (!this._nearCache.getExceptionEnabled()) return result;
                    throw e2;
                }
            }
            try {
                result = this._nearCache.get(key, readOptions, cls);
            }
            catch (CacheException e3) {
                if (!this._nearCache.getExceptionEnabled()) break block14;
                throw e3;
            }
        }
        if (result != null) {
            return result;
        }
        cacheItem = this._farCache.getCacheItem(key, readOptions);
        if (cacheItem == null) return result;
        result = cacheItem.getValue(cls);
        long size = 0L;
        try {
            cacheItem = this.getCompatibleItem(cacheItem);
            RefObject tempRef_size2 = new RefObject((Object)size);
            this._nearCache.insertOperation(key, result, cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
            size = (Long)tempRef_size2.argvalue;
            return result;
        }
        catch (CacheException e4) {
            if (!this._nearCache.getExceptionEnabled()) return result;
            throw e4;
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Iterable<String> keys, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException, IllegalArgumentException, ClassCastException {
        Map remoteResult;
        Map clientResult;
        block16: {
            block15: {
                clientResult = null;
                try {
                    clientResult = this._nearCache.getBulk(keys, null, cls);
                }
                catch (CacheException e) {
                    if (!this._nearCache.getExceptionEnabled()) break block15;
                    throw e;
                }
            }
            String[] keyList = (String[])Iterables.toArray(keys, String.class);
            if (clientResult != null && clientResult.size() == keyList.length) {
                return clientResult;
            }
            String[] remainingKeys = keyList;
            if (clientResult != null && clientResult.size() > 0) {
                remainingKeys = new String[keyList.length - clientResult.size()];
                int j = 0;
                for (int i = 0; i < keyList.length; ++i) {
                    if (clientResult.containsKey(keyList[i])) continue;
                    remainingKeys[j++] = keyList[i];
                }
            }
            if ((remoteResult = this._farCache.getBulk(Arrays.asList(remainingKeys), readThruOptions, cls)) != null && remoteResult.size() > 0) {
                HashMap<String, CacheItem> itemsdic = new HashMap<String, CacheItem>();
                Hashtable type2ExpirationMap = new Hashtable();
                for (Map.Entry entry : remoteResult.entrySet()) {
                    CacheItem l2CacheItem;
                    String key = entry.getKey();
                    CacheItem item = new CacheItem(entry.getValue());
                    item.setSyncDependency(new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password));
                    Class<?> objectType = item.getValue(cls).getClass();
                    if (!type2ExpirationMap.containsKey(objectType)) {
                        CacheItem cacheItem = this._farCache.getCacheItem(key, null);
                        type2ExpirationMap.put(objectType, cacheItem);
                    }
                    if ((l2CacheItem = (CacheItem)(type2ExpirationMap.get(objectType) instanceof CacheItem ? type2ExpirationMap.get(objectType) : null)) != null) {
                        Expiration tempVar = l2CacheItem.getExpiration();
                        item.setExpiration(tempVar);
                        item.setCacheItemPriority(l2CacheItem.getCacheItemPriority());
                        item.setGroup(l2CacheItem.getGroup());
                        item.setTags(l2CacheItem.getTags());
                        item.setNamedTags(l2CacheItem.getNamedTags());
                        item.setResyncOptions(l2CacheItem.getResyncOptions() == null ? new ResyncOptions(false, null) : l2CacheItem.getResyncOptions());
                    }
                    itemsdic.put(entry.getKey() instanceof String ? entry.getKey() : null, item);
                }
                try {
                    this._nearCache.insertBulk(itemsdic, null);
                }
                catch (CacheException e2) {
                    if (!this._nearCache.getExceptionEnabled()) break block16;
                    throw e2;
                }
            }
        }
        if (clientResult != null) {
            if (remoteResult == null) {
                remoteResult = new HashMap(clientResult);
            } else {
                for (Map.Entry entry : clientResult.entrySet()) {
                    remoteResult.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return remoteResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public CacheItem getCacheItem(String key, ReadThruOptions readThruOptions) throws CacheException, IllegalArgumentException {
        block23: {
            block24: {
                cacheItem = null;
                size = 0L;
                if (readThruOptions == null) {
                    readThruOptions = new ReadThruOptions(ReadMode.None);
                }
                if (!this._isPessimistic) ** GOTO lbl40
                version = new CacheItemVersion();
                if (readThruOptions.getReadMode() != ReadMode.ReadThruForced) {
                    cacheItem = this._nearCache.getCacheItem(key, version, null);
                }
                result = null;
                if (cacheItem == null || (result = this._farCache.getIfNewer(key, version, Object.class)) != null) break block23;
                if (version != null && version.getVersion() != 0L) break block24;
                var8_12 = cacheItem;
                TargetMethodAttribute.setMethodOverload(0);
                return var8_12;
            }
            var8_13 = null;
            TargetMethodAttribute.setMethodOverload(0);
            return var8_13;
        }
        try {
            block26: {
                block25: {
                    if ((cacheItem == null || result != null) && (cacheItem = this._farCache.getCacheItem(key, version, readThruOptions)) != null) {
                        version = cacheItem.getCacheItemVersion();
                    }
                    if (cacheItem == null) ** GOTO lbl66
                    try {
                        if (CacheItemWrapperInternal.GetCacheItemEntryType(cacheItem) == null || CacheItemWrapperInternal.GetCacheItemEntryType(cacheItem) != EntryType.CacheItem) ** GOTO lbl66
                        cacheItem = this.getCompatibleItem(cacheItem);
                        this._nearCache.insertOperation(key, cacheItem.getValue(Object.class), null, new CacheSyncDependency(this._farCache._cacheId, key), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), ClientCache.NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                    }
                    catch (CacheException e) {
                        if (!this._nearCache.getExceptionEnabled()) ** GOTO lbl66
                        throw e;
                    }
                    {
                        catch (CacheException e2) {
                            if (!this._nearCache.getExceptionEnabled()) ** GOTO lbl66
                            throw e2;
                        }
                    }
lbl40:
                    // 1 sources

                    try {
                        if (readThruOptions.getReadMode() != ReadMode.ReadThruForced) {
                            cacheItem = this._nearCache.getCacheItem(key);
                        }
                    }
                    catch (CacheException e3) {
                        if (!this._nearCache.getExceptionEnabled()) break block25;
                        throw e3;
                    }
                }
                if (cacheItem != null) {
                    e3 = cacheItem;
                    return e3;
                }
                version = new CacheItemVersion();
                cacheItem = this._farCache.getCacheItem(key, version, readThruOptions);
                if (cacheItem != null) {
                    try {
                        if (CacheItemWrapperInternal.GetCacheItemEntryType(cacheItem) != null && CacheItemWrapperInternal.GetCacheItemEntryType(cacheItem) == EntryType.CacheItem) {
                            tempVersion = cacheItem.getCacheItemVersion();
                            cacheItem = this.getCompatibleItem(cacheItem);
                            if (version.getVersion() == 0L) {
                                cacheItem.setCacheItemVersion(tempVersion);
                            }
                            this._nearCache.insertOperation(key, cacheItem.getValue(Object.class), cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), ClientCache.NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                        }
                    }
                    catch (CacheException e4) {
                        if (!this._nearCache.getExceptionEnabled()) break block26;
                        throw e4;
                    }
                }
            }
            var6_5 = cacheItem;
            return var6_5;
        }
        catch (Throwable var9_15) {
            throw var9_15;
        }
        finally {
            TargetMethodAttribute.setMethodOverload(0);
        }
    }

    @Override
    public CacheItem getCacheItem(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        return this._farCache.getCacheItem(key, acquireLock, lockTimeout, lockHandle);
    }

    @Override
    public Map<String, CacheItem> getCacheItemBulk(Iterable<String> keys, ReadThruOptions readThruOptions) throws CacheException {
        Map<String, CacheItem> remoteResult;
        Map<String, CacheItem> clientResult;
        block12: {
            clientResult = null;
            remoteResult = null;
            try {
                clientResult = this._nearCache.getCacheItemBulk(keys, null);
            }
            catch (CacheException e) {
                if (!this._nearCache.getExceptionEnabled()) break block12;
                throw e;
            }
        }
        String[] keyList = (String[])Iterables.toArray(keys, String.class);
        ArrayList<String> remainingKeys = new ArrayList<String>();
        if (clientResult != null) {
            block13: {
                if (clientResult.size() == keyList.length) {
                    return clientResult;
                }
                int j = 0;
                for (int i = 0; i < keyList.length; ++i) {
                    if (clientResult.containsKey(keyList[i])) continue;
                    remainingKeys.add(j++, keyList[i]);
                }
                if (remainingKeys.isEmpty()) {
                    return clientResult;
                }
                remoteResult = this._farCache.getCacheItemBulk(remainingKeys, readThruOptions);
                if (remoteResult != null && remoteResult.size() > 0) {
                    try {
                        this._nearCache.insertBulk(remoteResult, null);
                    }
                    catch (CacheException e2) {
                        if (!this._nearCache.getExceptionEnabled()) break block13;
                        throw e2;
                    }
                }
            }
            if (remoteResult == null) {
                remoteResult = new HashMap<String, CacheItem>(clientResult);
            } else {
                for (Map.Entry<String, CacheItem> entry : clientResult.entrySet()) {
                    remoteResult.put(entry.getKey(), entry.getValue());
                }
            }
        }
        return remoteResult;
    }

    @Override
    public CacheItem getCacheItemInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readOptions) throws CacheException {
        return this._farCache.getCacheItemInternal(key, version, accessType, lockTimeout, lockHandle, readOptions);
    }

    @Override
    public boolean lock(String key, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        return this._farCache.lock(key, lockTimeout, lockHandle);
    }

    @Override
    public void unlock(String key) throws CacheException {
        this._farCache.unlock(key);
    }

    @Override
    public void unlock(String key, LockHandle lockHandle) throws CacheException {
        this._farCache.unlock(key, lockHandle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getIfNewer(String key, CacheItemVersion version, Class<?> cls) throws CacheException {
        T result;
        block16: {
            result = null;
            CacheItem cacheItem = null;
            if (version == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: version");
            }
            try {
                if (TargetMethodAttribute.getMethodOverload() == 0) {
                    TargetMethodAttribute.setMethodOverload(2);
                }
                cacheItem = this._farCache.getCacheItem(key);
            }
            catch (CacheException e) {
                e.printStackTrace();
            }
            finally {
                TargetMethodAttribute.setMethodOverload(0);
            }
            if (cacheItem != null) {
                byte[] seralized = null;
                try {
                    seralized = CompactBinaryFormatter.toByteBuffer(cacheItem.getValue(cls), (String)this._farCache._cacheId);
                }
                catch (IOException e) {
                    throw new OperationFailedException((Throwable)e);
                }
                long size = seralized instanceof byte[] ? (long)seralized.length : 0L;
                result = cacheItem.getValue(cls);
                if (cacheItem.getCacheItemVersion() == null || cacheItem.getCacheItemVersion().getVersion() <= version.getVersion()) {
                    version.setVersion(0L);
                    return null;
                }
                version.setVersion(cacheItem.getCacheItemVersion().getVersion());
                try {
                    if (!this._nearCache.contains(key)) {
                        if (cacheItem != null) {
                            cacheItem = this.getCompatibleItem(cacheItem);
                        }
                        this._nearCache.insertOperation(key, result, cacheItem.getDependency(), new CacheSyncDependency(this._farCache._cacheId, key, this._userId, this._password), this.getServerExpiration(ConversionUtil.getAbsoluteExpiration(cacheItem.getExpiration()), NoSlidingExpiration), ConversionUtil.getSlidingExpiration(cacheItem.getExpiration()), cacheItem.getCacheItemPriority(), WriteMode.None, null, EventTypeInternal.None, cacheItem.getResyncOptions().getResyncOnExpiration(), cacheItem.getGroup(), null, version, LockAccessType.PRESERVE_VERSION, ConversionUtil.toArray(cacheItem.getTags()), null, cacheItem.getResyncOptions().getProviderName(), cacheItem.getNamedTags(), null, null, EventDataFilter.None, EventDataFilter.None, true, null, (short)-1, (short)-1, (short)-1);
                    }
                }
                catch (CacheException e) {
                    if (!this._nearCache.getExceptionEnabled()) break block16;
                    throw e;
                }
            }
        }
        return result;
    }

    @Override
    public boolean isLocked(String key, LockHandle lockHandle) throws CacheException {
        return this._farCache.isLocked(key, lockHandle);
    }

    @Override
    public CacheStream getCacheStream(String key, CacheStreamAttributes cacheStreamAttributes) throws CacheException {
        return this._farCache.getCacheStream(key, cacheStreamAttributes);
    }

    @Override
    public void addCacheNotification(String key, CacheDataModificationListener cacheDataModificationListener, EnumSet<EventType> eventType, EventDataFilter datafilter, ListenerType listenerType) throws CacheException {
        super.addCacheNotification(key, cacheDataModificationListener, eventType, datafilter, listenerType);
    }

    @Override
    public String toString() {
        return "L1 cache=" + this._nearCache.toString() + ", L2 cache=" + this._farCache.toString();
    }

    @Override
    public void close() {
        this._farCache.close();
        this._nearCache.close();
    }

    @Override
    public void raiseCustomEvent(Object notifId, Object data) throws CacheException {
        this._farCache.raiseCustomEvent(notifId, data);
    }

    @Override
    public void touch(ArrayList<String> keys) throws OperationNotSupportedException, CommandException, GeneralFailureException, StreamNotFoundException, ConfigurationException, StreamException, AggregateException, OperationFailedException, StreamAlreadyLockedException, LicensingException, SecurityException {
        this._farCache.touch(keys);
    }

    @Override
    public String getTargetCacheUniqueID() {
        return this._farCache.getTargetCacheUniqueID();
    }

    @Override
    public void makeTargetCacheActivePassive(boolean makeActive) throws Exception {
        block2: {
            try {
                this._farCache.makeTargetCacheActivePassive(makeActive);
            }
            catch (CacheException e) {
                if (!this._exceptionEnabled) break block2;
                throw e;
            }
        }
    }

    @Override
    public void InitializeEncryption() throws Exception {
        HashMap encryptionInfo = ((RemoteCache)this._farCache.getCacheImpl()).getEncryptionInfo();
        if (encryptionInfo != null && encryptionInfo.size() > 0) {
            boolean enableEncryption;
            this._nearCache._exceptionEnabled = enableEncryption = Boolean.parseBoolean((String)encryptionInfo.get("enabled"));
            EncryptionMgr.InitializeEncryption((boolean)enableEncryption, (String)((String)encryptionInfo.get("key")), (String)this._nearCache.getCacheImpl().getName(), (String)((String)encryptionInfo.get("provider")));
        }
    }

    public final Date GetCompatibleExpiration(Date absoluteExpiration, TimeSpan slidingExpiration) {
        if (!absoluteExpiration.equals(NoAbsoluteExpiration)) {
            return absoluteExpiration;
        }
        if (slidingExpiration == NoSlidingExpiration) {
            return NoAbsoluteExpiration;
        }
        return new Date(slidingExpiration.getTotalTicks());
    }

    @Override
    public CacheReader executeReaderCQ(ContinuousQuery query, boolean getData, int chunkSize) throws CacheException {
        return this._farCache.executeReaderCQ(query, getData, chunkSize);
    }

    @Override
    public void setExceptionsEnabled(boolean value) {
        this._farCache.setExceptionsEnabled(value);
    }
}

