/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CompressedValueEntry;
import Alachisoft.NCache.Common.ErrorHandling.ErrorMessages;
import com.alachisoft.ncache.client.CacheReader;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ClientRecordSetEnumerator;
import com.alachisoft.ncache.client.internal.caching.DataReaderCommon;
import com.alachisoft.ncache.runtime.JSON.JsonUtil;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import tangible.RefObject;

class ClientDataReader
extends DataReaderCommon
implements CacheReader {
    private ClientRecordSetEnumerator _clientRecordSetEnumerator;
    private Object[] _currentRow;
    private static final String keyColumnName = "$KEY$";
    private static final String valueColumnName = "$VALUE$";

    public ClientDataReader(ClientRecordSetEnumerator clientRecordSetEnumerator) {
        this(null, clientRecordSetEnumerator);
    }

    public ClientDataReader(CacheImpl cache, ClientRecordSetEnumerator clientRecordSetEnumerator) {
        this._cache = cache;
        this._clientRecordSetEnumerator = clientRecordSetEnumerator;
    }

    @Override
    public void close() {
        if (this._clientRecordSetEnumerator != null) {
            this._clientRecordSetEnumerator.dispose();
        }
    }

    @Override
    public boolean read() throws CacheException {
        if (this._clientRecordSetEnumerator == null) {
            return false;
        }
        boolean next = this._clientRecordSetEnumerator.moveNext();
        if (next) {
            this._currentRow = this._clientRecordSetEnumerator.getCurrent();
        }
        return next;
    }

    @Override
    public boolean getBoolean(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return (Boolean)this._currentRow[index];
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public String getString(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return this._currentRow[index] == null ? null : this._currentRow[index].toString();
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public BigDecimal getBigDecimal(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return (BigDecimal)this._currentRow[index];
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public double getDouble(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return (Double)this._currentRow[index];
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public short getShort(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return (Short)this._currentRow[index];
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public int getInt(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return (Integer)this._currentRow[index];
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public long getLong(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            return (Long)this._currentRow[index];
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public <T> T getValue(int index, Class<?> cls) throws ClassNotFoundException, OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow[index];
            CompressedValueEntry cmpEntry = (CompressedValueEntry)(obj instanceof CompressedValueEntry ? obj : null);
            if (cmpEntry != null) {
                try {
                    obj = this.extractFromCompressedValueEntry(cmpEntry, cls);
                }
                catch (IOException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            return (T)JsonUtil.getValueAs((Object)obj, cls);
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public <T> T getValue(String columnName, Class<?> cls) throws IOException, ClassNotFoundException, OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        int index = this.getOrdinal(columnName);
        Object obj = this._currentRow[index];
        CompressedValueEntry cmpEntry = (CompressedValueEntry)(obj instanceof CompressedValueEntry ? obj : null);
        if (cmpEntry != null) {
            obj = this.extractFromCompressedValueEntry(cmpEntry, cls);
        }
        return (T)JsonUtil.getValueAs((Object)obj, cls);
    }

    @Override
    public int getValues(Object[] objects, Class<?> cls) throws ClassNotFoundException, OperationFailedException {
        if (objects == null) {
            throw new IllegalArgumentException("objects");
        }
        if (objects.length == 0) {
            throw new IllegalArgumentException("Index was outside the bounds of the array.");
        }
        if (objects.length < this.getFieldCount()) {
            for (int i = 0; i < objects.length; ++i) {
                objects[i] = this.getSingleValue(i, cls == null ? Object.class : cls);
            }
            return objects.length;
        }
        for (int i = 0; i < this.getFieldCount(); ++i) {
            objects[i] = this.getSingleValue(i, cls == null ? Object.class : cls);
        }
        return this.getFieldCount();
    }

    private <T> T getSingleValue(int index, Class<?> cls) throws ClassNotFoundException, OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow[index];
            CompressedValueEntry cmpEntry = (CompressedValueEntry)(obj instanceof CompressedValueEntry ? obj : null);
            if (cmpEntry != null) {
                try {
                    obj = this.extractObjectFromCompressedValueEntry(cmpEntry, cls);
                }
                catch (IOException e) {
                    throw new OperationFailedException((Throwable)e);
                }
            }
            return (T)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public String getName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getFieldCount()) {
            String columnName = "";
            switch (columnIndex) {
                case 0: {
                    columnName = keyColumnName;
                    break;
                }
                case 1: {
                    columnName = valueColumnName;
                }
            }
            return columnName;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public int getOrdinal(String columnName) {
        if (columnName.equalsIgnoreCase(keyColumnName)) {
            return 0;
        }
        if (columnName.equalsIgnoreCase(valueColumnName)) {
            return 1;
        }
        throw new IllegalArgumentException("Invalid columnName. Specified column does not exist in RecordSet.");
    }

    @Override
    public boolean getIsClosed() {
        return this._clientRecordSetEnumerator == null;
    }

    @Override
    public Date getDate(int index) throws OperationFailedException {
        if (this._currentRow == null) {
            throw new OperationFailedException(25029, ErrorMessages.getErrorMessage((int)25029, (String[])new String[0]));
        }
        if (index >= 0 && index < this.getFieldCount()) {
            Object obj = this._currentRow[index];
            return (Date)obj;
        }
        throw new IllegalArgumentException("Invalid index. Specified index does not exist in RecordSet.");
    }

    @Override
    public int getFieldCount() {
        return this._clientRecordSetEnumerator == null ? 0 : this._clientRecordSetEnumerator.getFieldCount();
    }

    private void dispose(boolean disposing) {
        this.close();
        this._currentRow = null;
    }

    public void dispose() {
        this.dispose(true);
    }

    protected void finalize() throws Throwable {
        this.dispose(false);
    }

    @Override
    protected boolean tryGetKeyFromCurrentRow(RefObject<String> key) {
        Object possiblyKey = this._currentRow[this.getOrdinal(keyColumnName)];
        key.argvalue = possiblyKey == null ? null : possiblyKey.toString();
        return key.argvalue != null;
    }
}

