/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ClientRecordSetEnumerator;
import com.alachisoft.ncache.client.internal.caching.TargetMethodAttribute;
import com.alachisoft.ncache.client.internal.util.DictionaryEntry;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

class ClientRecordSetEnumeratorImpl
implements ClientRecordSetEnumerator {
    private LinkedList _keyList;
    private int _index = 0;
    private ArrayList _chunkKeys;
    private static final int CHUNKSIZE = 100;
    private HashMap _dataWithValue;
    private Object[] _currentValue;
    private CacheImpl _cache;
    private boolean _getData;
    private boolean _hasKeys;

    public ClientRecordSetEnumeratorImpl(List keyList, CacheImpl cache, boolean getData) throws CacheException {
        if (keyList.size() > 0) {
            this._hasKeys = true;
        }
        this._keyList = new LinkedList(keyList);
        this._getData = getData;
        this._cache = cache;
        this._dataWithValue = this.getDataWithKeys();
    }

    @Override
    public boolean moveNext() throws CacheException {
        if (this._dataWithValue != null && this._index < this._chunkKeys.size()) {
            Object key;
            if (this._dataWithValue.containsKey(key = this._chunkKeys.get(this._index++))) {
                if (this._getData) {
                    this._currentValue = new Object[2];
                    this._currentValue[0] = key;
                    this._currentValue[1] = this._dataWithValue.get(key);
                    return true;
                }
                this._currentValue = new Object[2];
                this._currentValue[0] = key;
                return true;
            }
            return this.getHasMoreData();
        }
        return this.getHasMoreData();
    }

    public void dispose() {
        this._keyList = null;
        this._chunkKeys = null;
        this._currentValue = null;
        this._dataWithValue = null;
    }

    @Override
    public Object[] getCurrent() {
        return this._currentValue;
    }

    private boolean getHasMoreData() throws CacheException {
        Object key;
        this._dataWithValue = this.getDataWithKeys();
        if (this._dataWithValue == null || this._dataWithValue.size() <= 0) {
            return false;
        }
        if (this._dataWithValue.containsKey(key = this._chunkKeys.get(this._index++))) {
            if (this._getData) {
                this._currentValue = new Object[2];
                this._currentValue[0] = key;
                this._currentValue[1] = this._dataWithValue.get(key);
                return true;
            }
            this._currentValue = new Object[1];
            this._currentValue[0] = key;
            return true;
        }
        return false;
    }

    private ArrayList getGetKeys() {
        if (this._keyList != null && this._keyList.size() > 0) {
            int count = 100 < this._keyList.size() ? 100 : this._keyList.size();
            ArrayList keys = new ArrayList();
            for (int i = 0; i < count; ++i) {
                keys.add(this._keyList.poll());
            }
            return keys;
        }
        return null;
    }

    private HashMap getDataWithKeys() throws CacheException {
        int prevOverload = 0;
        this._index = 0;
        ArrayList keys = this.getGetKeys();
        if (keys != null && this._cache != null) {
            if (this._getData) {
                prevOverload = TargetMethodAttribute.getMethodOverload();
                TargetMethodAttribute.setMethodOverload(0);
                Map retObjs = this._cache.getBulk(this.GetStringKeys(keys), null);
                TargetMethodAttribute.setMethodOverload(prevOverload);
                if (retObjs != null) {
                    HashMap data = new HashMap();
                    this._chunkKeys = new ArrayList();
                    for (Map.Entry item : retObjs.entrySet()) {
                        DictionaryEntry entry = (DictionaryEntry)item;
                        if (entry.getValue() == null || entry.getValue() instanceof Exception) continue;
                        String key = entry.getKey() instanceof String ? entry.getKey() : null;
                        this._chunkKeys.add(key);
                        data.put(key, entry.getValue());
                    }
                    return data;
                }
                return this.getDataWithKeys();
            }
            HashMap data = new HashMap();
            this._chunkKeys = new ArrayList();
            for (int i = 0; i < keys.size(); ++i) {
                data.put(keys.get(i), null);
                this._chunkKeys.add(keys.get(i));
            }
            return data;
        }
        return null;
    }

    private ArrayList<String> GetStringKeys(ArrayList list) {
        ArrayList<String> keys = new ArrayList<String>();
        for (Object item : list) {
            keys.add((String)(item instanceof String ? item : null));
        }
        return keys;
    }

    @Override
    public int getFieldCount() {
        if (this._hasKeys) {
            return this._getData ? 2 : 1;
        }
        return 0;
    }
}

