/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.CallbackInfo;
import Alachisoft.NCache.Caching.Util.CollectionUtil;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.Enum.SerializationFormat;
import Alachisoft.NCache.Common.Enum.UserObjectType;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import Alachisoft.NCache.Common.Logger.JLogger;
import Alachisoft.NCache.Common.ResourcePool;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheEventArg;
import com.alachisoft.ncache.client.CacheEventDescriptor;
import com.alachisoft.ncache.client.EventCacheItem;
import com.alachisoft.ncache.client.EventCacheItemWrapperInternal;
import com.alachisoft.ncache.client.EventHandle;
import com.alachisoft.ncache.client.EventUtil;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.CacheItemRemovedListener;
import com.alachisoft.ncache.client.internal.caching.CacheItemRemovedReason;
import com.alachisoft.ncache.client.internal.caching.CacheItemUpdatedListener;
import com.alachisoft.ncache.client.internal.caching.CollectionEventMessageReceivedListener;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.GeneralEventMessageReceivedListener;
import com.alachisoft.ncache.client.internal.caching.PollNotificationListener;
import com.alachisoft.ncache.client.internal.caching.SelectiveEventMessageReceivedListener;
import com.alachisoft.ncache.client.internal.caching.SelectiveRemoveListenerWrapper;
import com.alachisoft.ncache.client.internal.caching.SelectiveUpdateListenerWrapper;
import com.alachisoft.ncache.client.internal.caching.TopicImpl;
import com.alachisoft.ncache.client.internal.caching.TopicSubscriptionImpl;
import com.alachisoft.ncache.client.internal.messaging.MessageEventItem;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.TopicSubscription;
import com.alachisoft.ncache.runtime.caching.messaging.MessageReceivedListener;
import com.alachisoft.ncache.runtime.events.DataStructureDataChangeListener;
import com.alachisoft.ncache.runtime.events.DataStructureEventArg;
import com.alachisoft.ncache.runtime.events.DataTypeEventDataFilter;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.events.ListenerType;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class EventManager {
    public static final short REFSTART = -1;
    public static final short SELECTIVEREFSTARTRemove = 8000;
    public static final short SELECTIVEREFSTARTUpdate = 9000;
    public static final short COLLECTIONREFSTARTAdd = 11000;
    public static final short COLLECTIONREFSTARTUpdate = 12000;
    public static final short COLLECTIONREFSTARTRemove = 13000;
    MessageReceivedListener selectiveEventMessageReceivedListener = null;
    MessageReceivedListener generalEventMessageReceivedListener = null;
    MessageReceivedListener collectionEventMessageReceivedListener = null;
    private String _cacheName = null;
    private JLogger _logger;
    private Object sync_lock_selective = new Object();
    private Object sync_lock_general = new Object();
    private Object sync_lock_collection = new Object();
    private CacheImpl _cache;
    private PollNotificationListener pollnotifyListener;
    private ResourcePool _addEventPool = null;
    private ResourcePool _cacheClearEventPool = null;
    private EventDataFilter _addDataFilter = EventDataFilter.None;
    private ResourcePool _removeEventPool = null;
    private EventDataFilter _removeDataFilter = EventDataFilter.None;
    private ResourcePool _updateEventPool = null;
    private EventDataFilter _updateDataFilter = EventDataFilter.None;
    private short _addEventRegistrationSequence = (short)-1;
    private short _updateEventRegisrationSequenceId = (short)-1;
    private short _removeEventRegistrationSequenceId = (short)-1;
    private ResourcePool _selectiveRemoveEventPool = null;
    private ResourcePool _selectiveRemoveEventIDPool = null;
    private ResourcePool _oldSelectiveCallbackPool = new ResourcePool();
    private ResourcePool _oldSelectiveMappingCallbackPool = new ResourcePool();
    private short _selectveRemoveCallbackRef = (short)8000;
    private ResourcePool _selectiveUpdateEventPool = null;
    private ResourcePool _selectiveUpdateEventIDPool = null;
    private short _selectiveUpdateCallbackRef = (short)9000;
    private EventDataFilter _generalAddDataFilter = EventDataFilter.None;
    private EventDataFilter _generalUpdateDataFilter = EventDataFilter.None;
    private EventDataFilter _generalRemoveDataFilter = EventDataFilter.None;
    private PollNotificationListener _pollClientCacheCallback;
    private PollNotificationListener _pollPubSubCallback;
    private ResourcePool _collectionAddEventPool = null;
    private ResourcePool _collectionAddEventIdPool = null;
    private short _collectionAddCallbackRef = (short)11000;
    private ResourcePool _collectionUpdateEventPool = null;
    private ResourcePool _collectionUpdateEventIdPool = null;
    private short _collectionUpdateCallbackRef = (short)12000;
    private ResourcePool _collectionRemoveEventPool = null;
    private ResourcePool _collectionRemoveEventIdPool = null;
    private short _collectionRemoveCallbackRef = (short)13000;
    private int addCallbacks = -1;
    private int removeCallbacks = -1;
    private int updateCallbacks = -1;
    private TopicSubscriptionImpl _generalEventsSubscription;
    private TopicSubscriptionImpl _collectionEventsSubscription;
    private TopicSubscription _selectiveEventsSubscription;
    private Set<Integer> eventHandlerSet = new HashSet<Integer>();

    public EventManager(String cacheName, JLogger logger, CacheImpl cache) {
        this._cacheName = cacheName;
        this._logger = logger;
        this._cache = cache;
        if (this.generalEventMessageReceivedListener == null) {
            this.generalEventMessageReceivedListener = new GeneralEventMessageReceivedListener(this);
        }
        if (this.collectionEventMessageReceivedListener == null) {
            this.collectionEventMessageReceivedListener = new CollectionEventMessageReceivedListener(this);
        }
        if (this.selectiveEventMessageReceivedListener == null) {
            this.selectiveEventMessageReceivedListener = new SelectiveEventMessageReceivedListener(this);
        }
    }

    private static void fire(Object obj) {
        try {
            Object[] objArray = (Object[])obj;
            ((CacheDataModificationListener)objArray[0]).onCacheDataModified((String)objArray[1], (CacheEventArg)objArray[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final short getAddSequenceNumber() {
        return this._addEventRegistrationSequence;
    }

    public final short getUpdateSequenceNumber() {
        return this._updateEventRegisrationSequenceId;
    }

    public final short getRemoveSequenceNumber() {
        return this._removeEventRegistrationSequenceId;
    }

    public final Object getSyncLockGeneral() {
        return this.sync_lock_general;
    }

    public final Object getSyncLockSelective() {
        return this.sync_lock_selective;
    }

    public Object getSyncLockCollection() {
        return this.sync_lock_collection;
    }

    public final short generalEventRefCountAgainstEvent(EventType eventType) {
        if ((eventType.getValue() & EventType.ItemAdded.getValue()) != 0) {
            return this._addEventRegistrationSequence;
        }
        if ((eventType.getValue() & EventType.ItemRemoved.getValue()) != 0) {
            return this._removeEventRegistrationSequenceId;
        }
        if ((eventType.getValue() & EventType.ItemUpdated.getValue()) != 0) {
            return this._updateEventRegisrationSequenceId;
        }
        return -1;
    }

    public final EventDataFilter maxFilterAgainstEvent(EventType eventType) {
        if ((eventType.getValue() & EventType.ItemAdded.getValue()) != 0) {
            return this._addDataFilter;
        }
        if ((eventType.getValue() & EventType.ItemRemoved.getValue()) != 0) {
            return this._removeDataFilter;
        }
        if ((eventType.getValue() & EventType.ItemUpdated.getValue()) != 0) {
            return this._updateDataFilter;
        }
        return EventDataFilter.DataWithMetadata;
    }

    public final short[] registerSelectiveEvent(CacheDataModificationListener listener, EnumSet<EventType> enumTypeSet, EventDataFilter datafilter) throws CacheException {
        if (listener != null) {
            if (this._selectiveUpdateEventPool == null) {
                this._selectiveUpdateEventPool = new ResourcePool();
                this._selectiveUpdateEventIDPool = new ResourcePool();
            }
            if (this._selectiveRemoveEventPool == null) {
                this._selectiveRemoveEventPool = new ResourcePool();
                this._selectiveRemoveEventIDPool = new ResourcePool();
            }
            return this.registerSelectiveDiscriptor(listener, enumTypeSet);
        }
        return new short[]{-1, -1};
    }

    public final short[] registerSelectiveEvent(CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter datafilter, ListenerType listenerType) throws CacheException {
        if (listener != null) {
            if (this._selectiveUpdateEventPool == null) {
                this._selectiveUpdateEventPool = new ResourcePool();
                this._selectiveUpdateEventIDPool = new ResourcePool();
            }
            if (this._selectiveRemoveEventPool == null) {
                this._selectiveRemoveEventPool = new ResourcePool();
                this._selectiveRemoveEventIDPool = new ResourcePool();
            }
            return this.registerSelectiveDiscriptor(listener, eventTypes, listenerType);
        }
        return null;
    }

    public CacheEventDescriptor registerGeneralEvents(CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter datafilter) throws CacheException {
        if (listener != null) {
            if (this._addEventPool == null) {
                this._addEventPool = new ResourcePool();
            }
            if (this._removeEventPool == null) {
                this._removeEventPool = new ResourcePool();
            }
            if (this._updateEventPool == null) {
                this._updateEventPool = new ResourcePool();
            }
            CacheEventDescriptor discriptor = CacheEventDescriptor.createCacheDiscriptor(eventTypes, this._cacheName, listener, datafilter);
            boolean registeredDescriptor = false;
            for (EventType eventType : eventTypes) {
                EventTypeInternal eventTypeInternal = EventUtil.getEventTypeInternal(eventType);
                registeredDescriptor = this.registerGeneralDiscriptor(discriptor, eventTypeInternal);
            }
            if (!registeredDescriptor) {
                return null;
            }
            return discriptor;
        }
        return null;
    }

    public final void unregisterAll() {
    }

    public final void raiseGeneralCacheNotification(final String key, EventType eventType, EventCacheItem item, EventCacheItem oldItem, CacheItemRemovedReason reason, boolean notifyAsync) {
        block9: {
            try {
                Object[] registeredDiscriptors = null;
                ResourcePool eventPool = this.getEventPool(EventUtil.getEventTypeInternal(eventType));
                if (eventPool != null) {
                    registeredDiscriptors = eventPool.GetAllResourceKeys();
                }
                if (registeredDiscriptors != null && registeredDiscriptors.length > 0) {
                    for (int i = 0; i < registeredDiscriptors.length; ++i) {
                        final CacheEventDescriptor discriptor = (CacheEventDescriptor)(registeredDiscriptors[i] instanceof CacheEventDescriptor ? registeredDiscriptors[i] : null);
                        if (discriptor == null) continue;
                        BitSet bitSet = new BitSet();
                        if (this._cache.getSerializationFormat() == SerializationFormat.Json) {
                            bitSet.SetBit((byte)32);
                        }
                        if (item != null) {
                            EventCacheItemWrapperInternal.setValue(item, this._cache.safeDeserialize(item.getValue(null), this._cache.getSerializationContext(), bitSet, UserObjectType.CacheItem, null));
                        }
                        if (oldItem != null) {
                            EventCacheItemWrapperInternal.setValue(oldItem, this._cache.safeDeserialize(oldItem.getValue(null), this._cache.getSerializationContext(), bitSet, UserObjectType.CacheItem, null));
                        }
                        final CacheEventArg arg = this.createCacheEventArgument(discriptor.getDataFilter(), key, this._cacheName, eventType, item, oldItem, reason);
                        arg.setDescriptor(discriptor);
                        if (notifyAsync) {
                            ThreadPool.getInstance().executeTask(new Runnable(){

                                @Override
                                public void run() {
                                    EventManager.fire(new Object[]{discriptor.getCacheDataNotificationListener(), key, arg});
                                }
                            });
                            continue;
                        }
                        discriptor.getCacheDataNotificationListener().onCacheDataModified(key, arg);
                    }
                }
            }
            catch (OperationFailedException | RuntimeException ex) {
                if (this._logger == null || !this._logger.getIsErrorEnabled()) break block9;
                this._logger.CriticalInfo(ex.toString());
            }
        }
    }

    private CacheEventArg createCacheEventArgument(EventDataFilter dataFilter, String key, String cacheName, EventType eventType, EventCacheItem item, EventCacheItem oldItem, CacheItemRemovedReason removedReason) {
        Object tempVar2;
        Object tempVar;
        EventCacheItem cloneItem = null;
        EventCacheItem cloneOldItem = null;
        if (dataFilter != EventDataFilter.None && item != null && (cloneItem = (EventCacheItem)((tempVar = item.clone()) instanceof EventCacheItem ? tempVar : null)) != null && dataFilter == EventDataFilter.Metadata) {
            EventCacheItemWrapperInternal.setValue(cloneItem, null);
        }
        if (dataFilter != EventDataFilter.None && oldItem != null && (cloneOldItem = (EventCacheItem)((tempVar2 = oldItem.clone()) instanceof EventCacheItem ? tempVar2 : null)) != null && dataFilter == EventDataFilter.Metadata) {
            EventCacheItemWrapperInternal.setValue(cloneOldItem, null);
        }
        CacheEventArg eventArg = new CacheEventArg(key, cacheName, eventType, cloneItem, null, removedReason);
        if (eventType == EventType.ItemUpdated) {
            eventArg.setOldItem(cloneOldItem);
        }
        return eventArg;
    }

    public final void raiseSelectiveCacheNotification(final String key, EnumSet<EventType> eventEnumSet, EventCacheItem item, EventCacheItem oldItem, CacheItemRemovedReason reason, boolean _notifyAsync, EventHandle eventhandle, EventDataFilter dataFilter) {
        block9: {
            try {
                ResourcePool poolID = null;
                if (eventEnumSet.contains(EventType.ItemUpdated)) {
                    poolID = this._selectiveUpdateEventIDPool;
                } else if (eventEnumSet.contains(EventType.ItemRemoved)) {
                    poolID = this._selectiveRemoveEventIDPool;
                }
                if (poolID == null) {
                    return;
                }
                final CacheEventArg arg = this.createCacheEventArgument(dataFilter, key, this._cacheName, EventUtil.getEventType(eventEnumSet), item, oldItem, reason);
                Object tempVar = poolID.GetResource((Object)((short)eventhandle.getHandle()));
                final CacheDataModificationListener callback = (CacheDataModificationListener)(tempVar instanceof CacheDataModificationListener ? tempVar : null);
                if (callback == null) {
                    return;
                }
                if (_notifyAsync) {
                    ThreadPool.getInstance().executeTask(new Runnable(){

                        @Override
                        public void run() {
                            EventManager.fire(new Object[]{callback, key, arg});
                        }
                    });
                } else {
                    callback.onCacheDataModified(key, arg);
                }
            }
            catch (RuntimeException ex) {
                if (this._logger == null || !this._logger.getIsErrorEnabled()) break block9;
                this._logger.CriticalInfo(ex.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short[] registerSelectiveDiscriptor(CacheDataModificationListener listener, EnumSet<EventType> eventTypes, ListenerType listenerType) throws CacheException {
        if (listener == null) {
            return null;
        }
        short[] returnValue = new short[]{-1, -1};
        for (EventType type : eventTypes) {
            if (type == EventType.ItemAdded) continue;
            Object object = this.getSyncLockSelective();
            synchronized (object) {
                ResourcePool pool = null;
                ResourcePool poolID = null;
                if (type == EventType.ItemRemoved) {
                    pool = this._selectiveRemoveEventPool;
                    poolID = this._selectiveRemoveEventIDPool;
                } else if (type == EventType.ItemUpdated) {
                    pool = this._selectiveUpdateEventPool;
                    poolID = this._selectiveUpdateEventIDPool;
                }
                if (pool == null) {
                    continue;
                }
                while (true) {
                    int i;
                    int n = i = type == EventType.ItemUpdated ? 0 : 1;
                    if (pool.GetResource((Object)listener) == null) {
                        short s;
                        if (type == EventType.ItemUpdated) {
                            s = (short)(this._selectiveUpdateCallbackRef + 1);
                            this._selectiveUpdateCallbackRef = this._selectiveUpdateCallbackRef;
                        } else {
                            s = (short)(this._selectveRemoveCallbackRef + 1);
                            this._selectveRemoveCallbackRef = this._selectveRemoveCallbackRef;
                        }
                        returnValue[i] = s;
                        pool.AddResource((Object)listener, (Object)returnValue[i]);
                        poolID.AddResource((Object)returnValue[i], (Object)listener);
                        break;
                    }
                    try {
                        short cref = (Short)pool.GetResource((Object)listener);
                        if (cref < 0) break;
                        pool.AddResource((Object)listener, (Object)cref);
                        poolID.AddResource((Object)cref, (Object)listener);
                        returnValue[i] = cref;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (this._selectiveEventsSubscription == null && listenerType != ListenerType.PullBasedCallback) {
            TopicImpl topic = (TopicImpl)this._cache._messagingService.getTopic("$ItemLevelEvents$", true);
            this._selectiveEventsSubscription = topic.createEventSubscription(this.selectiveEventMessageReceivedListener);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short[] registerSelectiveDiscriptor(CacheDataModificationListener listener, EnumSet<EventType> enumTypeSet) throws CacheException {
        if (listener == null) {
            return null;
        }
        short[] returnValue = new short[]{-1, -1};
        for (EventType type : EventType.values()) {
            if (type == EventType.ItemAdded) continue;
            Object object = this.getSyncLockSelective();
            synchronized (object) {
                ResourcePool pool = null;
                ResourcePool poolID = null;
                if (type.equals((Object)EventType.ItemRemoved) && enumTypeSet.contains(type)) {
                    pool = this._selectiveRemoveEventPool;
                    poolID = this._selectiveRemoveEventIDPool;
                } else if (type.equals((Object)EventType.ItemUpdated) && enumTypeSet.contains(type)) {
                    pool = this._selectiveUpdateEventPool;
                    poolID = this._selectiveUpdateEventIDPool;
                }
                if (pool == null) {
                    continue;
                }
                while (true) {
                    int i;
                    int n = i = type.equals((Object)EventType.ItemUpdated) ? 0 : 1;
                    if (pool.GetResource((Object)listener) == null) {
                        short s;
                        if (type.equals((Object)EventType.ItemUpdated)) {
                            s = (short)(this._selectiveUpdateCallbackRef + 1);
                            this._selectiveUpdateCallbackRef = this._selectiveUpdateCallbackRef;
                        } else {
                            s = (short)(this._selectveRemoveCallbackRef + 1);
                            this._selectveRemoveCallbackRef = this._selectveRemoveCallbackRef;
                        }
                        returnValue[i] = s;
                        pool.AddResource((Object)listener, (Object)returnValue[i]);
                        poolID.AddResource((Object)returnValue[i], (Object)listener);
                        break;
                    }
                    try {
                        if (pool.GetResource((Object)listener) == null) continue;
                        short cref = (Short)pool.GetResource((Object)listener);
                        if (cref < 0) break;
                        pool.AddResource((Object)listener, (Object)cref);
                        poolID.AddResource((Object)cref, (Object)listener);
                        returnValue[i] = cref;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    break;
                }
                if (this._selectiveEventsSubscription == null) {
                    TopicImpl topic = (TopicImpl)this._cache._messagingService.getTopic("$ItemLevelEvents$", true);
                    SelectiveEventMessageReceivedListener eventListener = new SelectiveEventMessageReceivedListener(this);
                    this._selectiveEventsSubscription = topic.createEventSubscription(eventListener);
                }
            }
        }
        return returnValue;
    }

    public void onSelectiveEventsMessageRecieved(MessageEventItem eventMessage) {
        String key = eventMessage.getKey();
        CallbackInfo cbInfo = new CallbackInfo(null, eventMessage.getCallback(), eventMessage.getDataFilter());
        EventHandle handle = null;
        if (cbInfo != null) {
            short handler = (Short)cbInfo.getCallback();
            handle = new EventHandle(handler);
        }
        switch (eventMessage.getEventType()) {
            case ITEM_UPDATED_CALLBACK: {
                this.raiseSelectiveCacheNotification(key, EnumSet.of(EventType.ItemUpdated), eventMessage.getItem(), eventMessage.getOldItem(), CacheItemRemovedReason.Underused, false, handle, cbInfo.getDataFilter());
                break;
            }
            case ITEM_REMOVED_CALLBACK: {
                this.raiseSelectiveCacheNotification(key, EnumSet.of(EventType.ItemRemoved), eventMessage.getItem(), null, eventMessage.getReason(), false, handle, cbInfo.getDataFilter());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean registerGeneralDiscriptor(CacheEventDescriptor discriptor, EventTypeInternal eventType) throws CacheException {
        if (discriptor == null) {
            return false;
        }
        EventHandle handle = null;
        for (EventTypeInternal type : EventTypeInternal.values()) {
            ResourcePool pool = null;
            boolean registrationUpdated = false;
            if (type == eventType) {
                pool = this.getEventPool(type);
            }
            if (pool == null) continue;
            short registrationSequenceId = -1;
            Object object = this.getSyncLockGeneral();
            synchronized (object) {
                pool.AddResource((Object)discriptor, (Object)1);
                switch (type) {
                    case ItemAdded: {
                        if (discriptor.getDataFilter() != this._generalAddDataFilter || this._addEventRegistrationSequence == -1) {
                            registrationUpdated = true;
                            registrationSequenceId = this._addEventRegistrationSequence = (short)(this._addEventRegistrationSequence + 1);
                            this._generalAddDataFilter = discriptor.getDataFilter();
                            break;
                        }
                        registrationSequenceId = this._addEventRegistrationSequence;
                        break;
                    }
                    case ItemRemoved: {
                        if (discriptor.getDataFilter() != this._generalRemoveDataFilter || this._removeEventRegistrationSequenceId == -1) {
                            registrationUpdated = true;
                            registrationSequenceId = this._removeEventRegistrationSequenceId = (short)(this._removeEventRegistrationSequenceId + 1);
                            this._generalRemoveDataFilter = discriptor.getDataFilter();
                            break;
                        }
                        registrationSequenceId = this._removeEventRegistrationSequenceId;
                        break;
                    }
                    case ItemUpdated: {
                        if (discriptor.getDataFilter() != this._generalUpdateDataFilter || this._updateEventRegisrationSequenceId == -1) {
                            registrationUpdated = true;
                            registrationSequenceId = this._updateEventRegisrationSequenceId = (short)(this._updateEventRegisrationSequenceId + 1);
                            this._generalUpdateDataFilter = discriptor.getDataFilter();
                            break;
                        }
                        registrationSequenceId = this._updateEventRegisrationSequenceId;
                    }
                }
                if (handle == null) {
                    handle = new EventHandle(registrationSequenceId);
                }
            }
            if (this._cache == null || registrationSequenceId == -1) continue;
            this._cache.addCacheNotificationDataFilter(type, discriptor.getDataFilter(), registrationSequenceId);
        }
        if (this._generalEventsSubscription == null) {
            TopicImpl topic = (TopicImpl)this._cache._messagingService.getTopic("$GeneralEvents$", true);
            this._generalEventsSubscription = (TopicSubscriptionImpl)topic.createEventSubscription(this.generalEventMessageReceivedListener);
        }
        discriptor.setIsRegistered(true);
        discriptor.setHandle(handle);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final short[] unRegisterSelectiveNotification(CacheDataModificationListener listener, EnumSet<EventType> eventTypes) throws Exception {
        if (listener == null) {
            return null;
        }
        short[] returnValue = new short[]{-1, -1};
        for (EventType type : eventTypes) {
            if (type == EventType.ItemAdded) continue;
            Object id = -1;
            Object object = this.getSyncLockSelective();
            synchronized (object) {
                ResourcePool pool = null;
                ResourcePool poolID = null;
                if (type.equals((Object)EventType.ItemRemoved)) {
                    pool = this._selectiveRemoveEventPool;
                    poolID = this._selectiveRemoveEventIDPool;
                    if (pool == null) {
                        this.removeCallbacks = 0;
                    }
                } else if (type.equals((Object)EventType.ItemUpdated)) {
                    pool = this._selectiveUpdateEventPool;
                    poolID = this._selectiveUpdateEventIDPool;
                    if (pool == null) {
                        this.updateCallbacks = 0;
                    }
                }
                if (this.removeCallbacks == 0 && this.updateCallbacks == 0) {
                    this._selectiveEventsSubscription.unSubscribe();
                    this._selectiveEventsSubscription = null;
                }
                if (pool == null) {
                    continue;
                }
                int i = type == EventType.ItemUpdated ? 0 : 1;
                id = pool.GetResource((Object)listener);
                if (id instanceof Short) {
                    returnValue[i] = (Short)id;
                }
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EventHandle unRegisterDiscriptor(CacheEventDescriptor discriptor) throws Exception {
        if (discriptor == null || !discriptor.getIsRegistered()) {
            return null;
        }
        for (EventType type : EventType.values()) {
            boolean unregisterNotification;
            ResourcePool pool = null;
            if (discriptor.getRegisteredAgainst().contains(type)) {
                pool = this.getEventPool(EventUtil.getEventTypeInternal(type));
            }
            if (pool == null) continue;
            short registrationSequenceId = -1;
            EventDataFilter maxDataFilter = EventDataFilter.None;
            Object object = this.getSyncLockGeneral();
            synchronized (object) {
                Object[] pooledDescriptors;
                Object retVal = pool.RemoveResource((Object)discriptor);
                if (retVal == null) {
                    continue;
                }
                boolean bl = unregisterNotification = pool.getCount() == 0;
                if (!unregisterNotification && (pooledDescriptors = pool.GetAllResourceKeys()) != null) {
                    for (int i = 0; i < pooledDescriptors.length; ++i) {
                        CacheEventDescriptor pooledDescriptor = (CacheEventDescriptor)(pooledDescriptors[i] instanceof CacheEventDescriptor ? pooledDescriptors[i] : null);
                        if (pooledDescriptor != null && pooledDescriptor.getDataFilter().getValue() > maxDataFilter.getValue()) {
                            maxDataFilter = pooledDescriptor.getDataFilter();
                        }
                        if (maxDataFilter.getValue() == EventDataFilter.DataWithMetadata.getValue()) break;
                    }
                }
                discriptor.setIsRegistered(false);
                switch (type) {
                    case ItemAdded: {
                        if (maxDataFilter != this._generalAddDataFilter) {
                            this._generalAddDataFilter = maxDataFilter;
                            this._addEventRegistrationSequence = (short)(this._addEventRegistrationSequence + 1);
                            registrationSequenceId = this._addEventRegistrationSequence;
                        }
                        if (!unregisterNotification) break;
                        this._generalAddDataFilter = EventDataFilter.None;
                        break;
                    }
                    case ItemRemoved: {
                        if (maxDataFilter != this._generalRemoveDataFilter) {
                            this._generalRemoveDataFilter = maxDataFilter;
                            this._removeEventRegistrationSequenceId = (short)(this._removeEventRegistrationSequenceId + 1);
                            registrationSequenceId = this._removeEventRegistrationSequenceId;
                        }
                        if (!unregisterNotification) break;
                        this._generalAddDataFilter = EventDataFilter.None;
                        break;
                    }
                    case ItemUpdated: {
                        if (maxDataFilter != this._generalUpdateDataFilter) {
                            this._generalUpdateDataFilter = maxDataFilter;
                            this._updateEventRegisrationSequenceId = (short)(this._updateEventRegisrationSequenceId + 1);
                            registrationSequenceId = this._updateEventRegisrationSequenceId;
                        }
                        if (!unregisterNotification) break;
                        this._generalAddDataFilter = EventDataFilter.None;
                    }
                }
            }
            if (this._cache == null) continue;
            if (unregisterNotification) {
                this._cache.removeGeneralCacheNotification(EventUtil.getEventTypeInternal(type));
                if (this._generalEventsSubscription == null) continue;
                this._generalEventsSubscription.unSubscribeEventTopic();
                this._generalEventsSubscription = null;
                continue;
            }
            if (registrationSequenceId == -1) continue;
            this._cache.addCacheNotificationDataFilter(EventUtil.getEventTypeInternal(type), maxDataFilter, registrationSequenceId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final EventRegistrationInfo[] getEventRegistrationInfo() {
        ArrayList<EventRegistrationInfo> registeredEvents = new ArrayList<EventRegistrationInfo>();
        Object object = this.getSyncLockGeneral();
        synchronized (object) {
            if (this._addEventPool != null && this._addEventPool.getCount() > 0) {
                registeredEvents.add(new EventRegistrationInfo(EventType.ItemAdded, this._generalAddDataFilter, this._addEventRegistrationSequence));
            }
            if (this._updateEventPool != null && this._updateEventPool.getCount() > 0) {
                registeredEvents.add(new EventRegistrationInfo(EventType.ItemUpdated, this._generalUpdateDataFilter, this._updateEventRegisrationSequenceId));
            }
            if (this._removeEventPool != null && this._removeEventPool.getCount() > 0) {
                registeredEvents.add(new EventRegistrationInfo(EventType.ItemRemoved, this._generalRemoveDataFilter, this._removeEventRegistrationSequenceId));
            }
        }
        return registeredEvents.toArray(new EventRegistrationInfo[0]);
    }

    private ResourcePool getEventPool(EventTypeInternal eventType) {
        ResourcePool pool = null;
        if (eventType == EventTypeInternal.ItemAdded) {
            pool = this._addEventPool;
        } else if (eventType == EventTypeInternal.ItemRemoved) {
            pool = this._removeEventPool;
        } else if (eventType == EventTypeInternal.ItemUpdated) {
            pool = this._updateEventPool;
        }
        return pool;
    }

    public void raisePollNotification(short callbackId, EventTypeInternal eventType) {
        block6: {
            try {
                PollNotificationListener _pollCallback = null;
                if (eventType == EventTypeInternal.ClientCache) {
                    _pollCallback = this._pollClientCacheCallback;
                } else if (eventType == EventTypeInternal.PubSub) {
                    _pollCallback = this._pollPubSubCallback;
                }
                if (_pollCallback != null) {
                    _pollCallback.onPollNotified();
                }
            }
            catch (Exception ex) {
                if (this._logger == null || !this._logger.getIsErrorEnabled()) break block6;
                this._logger.CriticalInfo(ex.getMessage());
            }
        }
    }

    public short registerPollingEvent(PollNotificationListener pollNotifyListener, EventTypeInternal eventType) {
        if (eventType == EventTypeInternal.ClientCache) {
            this._pollClientCacheCallback = pollNotifyListener;
        } else if (eventType == EventTypeInternal.PubSub) {
            this._pollPubSubCallback = pollNotifyListener;
        }
        return 10001;
    }

    public short[] registerCollectionEvent(DataStructureDataChangeListener dataStructureDataChangeListener, EnumSet<EventTypeInternal> enumSet, DataTypeEventDataFilter datafilter) throws CacheException {
        if (dataStructureDataChangeListener != null) {
            if (this._collectionAddEventPool == null) {
                this._collectionAddEventPool = new ResourcePool();
                this._collectionAddEventIdPool = new ResourcePool();
            }
            if (this._collectionUpdateEventPool == null) {
                this._collectionUpdateEventPool = new ResourcePool();
                this._collectionUpdateEventIdPool = new ResourcePool();
            }
            if (this._collectionRemoveEventPool == null) {
                this._collectionRemoveEventPool = new ResourcePool();
                this._collectionRemoveEventIdPool = new ResourcePool();
            }
            return this.registerCollectionDescriptor(dataStructureDataChangeListener, enumSet);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short[] UnregisterCollectionNotification(DataStructureDataChangeListener listener, EnumSet<EventTypeInternal> enumSet) throws Exception {
        if (listener == null) {
            return null;
        }
        short[] returnValue = new short[]{-1, -1, -1};
        for (EventTypeInternal type : enumSet) {
            Object id = -1;
            Object object = this.getSyncLockCollection();
            synchronized (object) {
                ResourcePool pool = null;
                ResourcePool poolID = null;
                if (type == EventTypeInternal.ItemAdded) {
                    pool = this._collectionAddEventPool;
                    poolID = this._collectionAddEventIdPool;
                    if (pool == null) {
                        this.addCallbacks = 0;
                    }
                }
                if (type == EventTypeInternal.ItemRemoved) {
                    pool = this._collectionRemoveEventPool;
                    poolID = this._collectionRemoveEventIdPool;
                    if (pool == null) {
                        this.removeCallbacks = 0;
                    }
                } else if (type == EventTypeInternal.ItemUpdated) {
                    pool = this._collectionUpdateEventPool;
                    poolID = this._collectionUpdateEventIdPool;
                    if (pool == null) {
                        this.updateCallbacks = 0;
                    }
                }
                if (this.addCallbacks == 0 && this.removeCallbacks == 0 && this.updateCallbacks == 0) {
                    this._collectionEventsSubscription.unSubscribeEventTopic();
                    this._collectionEventsSubscription = null;
                }
                if (pool == null) {
                    continue;
                }
                int i = type == EventTypeInternal.ItemAdded ? 0 : (type == EventTypeInternal.ItemUpdated ? 1 : 2);
                id = pool.GetResource((Object)listener);
                if (id instanceof Short) {
                    returnValue[i] = (Short)id;
                }
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short[] registerCollectionDescriptor(DataStructureDataChangeListener listener, EnumSet<EventTypeInternal> enumSet) throws CacheException {
        if (listener == null) {
            return null;
        }
        short[] returnValue = new short[]{-1, -1, -1};
        for (EventTypeInternal type : enumSet) {
            Object object = this.getSyncLockCollection();
            synchronized (object) {
                ResourcePool pool = null;
                ResourcePool poolId = null;
                if (type == EventTypeInternal.ItemAdded) {
                    pool = this._collectionAddEventPool;
                    poolId = this._collectionAddEventIdPool;
                } else if (type == EventTypeInternal.ItemUpdated) {
                    pool = this._collectionUpdateEventPool;
                    poolId = this._collectionUpdateEventIdPool;
                } else if (type == EventTypeInternal.ItemRemoved) {
                    pool = this._collectionRemoveEventPool;
                    poolId = this._collectionRemoveEventIdPool;
                }
                if (pool == null) {
                    continue;
                }
                while (true) {
                    int index;
                    int n = type == EventTypeInternal.ItemAdded ? 0 : (index = type == EventTypeInternal.ItemUpdated ? 1 : 2);
                    if (pool.GetResource((Object)listener) == null) {
                        short s;
                        if (type == EventTypeInternal.ItemAdded) {
                            s = (short)(this._collectionAddCallbackRef + 1);
                            this._collectionAddCallbackRef = this._collectionAddCallbackRef;
                        } else if (type == EventTypeInternal.ItemUpdated) {
                            s = (short)(this._collectionUpdateCallbackRef + 1);
                            this._collectionUpdateCallbackRef = this._collectionUpdateCallbackRef;
                        } else {
                            s = (short)(this._collectionRemoveCallbackRef + 1);
                            this._collectionRemoveCallbackRef = this._collectionRemoveCallbackRef;
                        }
                        returnValue[index] = s;
                        pool.AddResource((Object)listener, (Object)returnValue[index]);
                        poolId.AddResource((Object)returnValue[index], (Object)listener);
                        break;
                    }
                    try {
                        short cref = (Short)pool.GetResource((Object)listener);
                        if (cref < 0) break;
                        pool.AddResource((Object)listener, (Object)cref);
                        poolId.AddResource((Object)cref, (Object)listener);
                        returnValue[index] = cref;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                    break;
                }
            }
        }
        if (this._collectionEventsSubscription == null) {
            TopicImpl topic = (TopicImpl)this._cache._messagingService.getTopic("$CollectionEvents$", true);
            this._collectionEventsSubscription = (TopicSubscriptionImpl)topic.createEventSubscription(this.collectionEventMessageReceivedListener);
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short registerSelectiveCallback(CacheItemRemovedListener removedCallback, ListenerType listenerType) throws CacheException {
        if (removedCallback == null) {
            return -1;
        }
        Object object = this.getSyncLockSelective();
        synchronized (object) {
            SelectiveRemoveListenerWrapper callbackWrapper = null;
            if (this._oldSelectiveCallbackPool.GetResource((Object)removedCallback) == null) {
                callbackWrapper = new SelectiveRemoveListenerWrapper(removedCallback);
                this._oldSelectiveCallbackPool.AddResource((Object)removedCallback, (Object)callbackWrapper);
                this._oldSelectiveMappingCallbackPool.AddResource((Object)callbackWrapper, (Object)removedCallback);
            } else {
                callbackWrapper = (SelectiveRemoveListenerWrapper)this._oldSelectiveCallbackPool.GetResource((Object)removedCallback);
                this._oldSelectiveCallbackPool.AddResource((Object)removedCallback, (Object)callbackWrapper);
            }
            short[] callbackIds = this.registerSelectiveEvent(callbackWrapper.getMappingListener(), EnumSet.of(EventType.ItemRemoved), EventDataFilter.DataWithMetadata, listenerType);
            return callbackIds[1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short registerSelectiveCallback(CacheItemUpdatedListener updatedCallback, ListenerType listenerType) throws CacheException {
        if (updatedCallback == null) {
            return -1;
        }
        Object object = this.getSyncLockSelective();
        synchronized (object) {
            SelectiveUpdateListenerWrapper callbackWrapper = null;
            if (this._oldSelectiveCallbackPool.GetResource((Object)updatedCallback) == null) {
                callbackWrapper = new SelectiveUpdateListenerWrapper(updatedCallback);
                this._oldSelectiveCallbackPool.AddResource((Object)updatedCallback, (Object)callbackWrapper);
                this._oldSelectiveMappingCallbackPool.AddResource((Object)callbackWrapper, (Object)updatedCallback);
            } else {
                callbackWrapper = (SelectiveUpdateListenerWrapper)this._oldSelectiveCallbackPool.GetResource((Object)updatedCallback);
                this._oldSelectiveCallbackPool.AddResource((Object)updatedCallback, (Object)callbackWrapper);
            }
            short[] callbackIds = this.registerSelectiveEvent(callbackWrapper.getMappingListener(), EnumSet.of(EventType.ItemRemoved), EventDataFilter.DataWithMetadata, listenerType);
            return callbackIds[1];
        }
    }

    void raiseCollectionNotification(final String collectionName, EventTypeInternal eventType, DistributedDataStructure dataType, DataTypeEventDataFilter dataFilter, Object collectionItem, Object oldCollectionItem, boolean _notifyAsync, EventHandle handle) {
        block17: {
            try {
                Map.Entry pair;
                ResourcePool poolID = null;
                DataStructureEventArg arg = null;
                if (collectionItem != null) {
                    if (dataType == DistributedDataStructure.Map) {
                        pair = collectionItem;
                        collectionItem = new AbstractMap.SimpleEntry<String, Object>((String)pair.getKey(), CollectionUtil.getValueFromJsonValueBase((ExtendedJsonValueBase)((ExtendedJsonValueBase)pair.getValue())));
                    } else {
                        collectionItem = CollectionUtil.getValueFromJsonValueBase((ExtendedJsonValueBase)((ExtendedJsonValueBase)(collectionItem instanceof ExtendedJsonValueBase ? collectionItem : null)));
                    }
                }
                if (oldCollectionItem != null) {
                    if (dataType == DistributedDataStructure.Map) {
                        pair = oldCollectionItem;
                        oldCollectionItem = new AbstractMap.SimpleEntry<String, Object>((String)pair.getKey(), CollectionUtil.getValueFromJsonValueBase((ExtendedJsonValueBase)((ExtendedJsonValueBase)pair.getValue())));
                    } else {
                        oldCollectionItem = CollectionUtil.getValueFromJsonValueBase((ExtendedJsonValueBase)((ExtendedJsonValueBase)(oldCollectionItem instanceof ExtendedJsonValueBase ? oldCollectionItem : null)));
                    }
                }
                if (eventType == EventTypeInternal.ItemAdded) {
                    poolID = this._collectionAddEventIdPool;
                } else if (eventType == EventTypeInternal.ItemUpdated) {
                    poolID = this._collectionUpdateEventIdPool;
                } else if (eventType == EventTypeInternal.ItemRemoved) {
                    poolID = this._collectionRemoveEventIdPool;
                }
                arg = this.createCollectionEventArgument(collectionName, this._cacheName, eventType, dataFilter, dataType, collectionItem, oldCollectionItem);
                if (poolID == null) {
                    return;
                }
                Object tempVar = poolID.GetResource((Object)((short)handle.getHandle()));
                final DataStructureDataChangeListener listener = (DataStructureDataChangeListener)(tempVar instanceof DataStructureDataChangeListener ? tempVar : null);
                if (listener == null) {
                    return;
                }
                if (_notifyAsync) {
                    final DataStructureEventArg finalArg = arg;
                    ThreadPool.getInstance().executeTask(new Runnable(){

                        @Override
                        public void run() {
                            listener.onDataStructureChanged(collectionName, finalArg);
                        }
                    });
                } else {
                    listener.onDataStructureChanged(collectionName, arg);
                }
            }
            catch (Exception e) {
                if (this._logger == null || !this._logger.getIsErrorEnabled()) break block17;
                this._logger.CriticalInfo(e.toString());
            }
        }
    }

    private DataStructureEventArg createCollectionEventArgument(String collectionName, String cacheName, EventTypeInternal eventType, DataTypeEventDataFilter dataFilter, DistributedDataStructure dataType, Object collectionItem, Object oldCollectionItem) {
        Object collectionItemCopy = null;
        Object oldCollectionItemCopy = null;
        switch (dataFilter) {
            case None: {
                collectionItemCopy = null;
                oldCollectionItemCopy = null;
                break;
            }
            case Data: {
                collectionItemCopy = collectionItem;
                oldCollectionItemCopy = oldCollectionItem;
            }
        }
        DataStructureEventArg eventArg = null;
        if (eventType == EventTypeInternal.ItemUpdated) {
            eventArg = new DataStructureEventArg(cacheName, EventType.ItemUpdated, dataType, collectionItemCopy, oldCollectionItemCopy);
        } else if (eventType == EventTypeInternal.ItemAdded) {
            eventArg = new DataStructureEventArg(cacheName, EventType.ItemAdded, dataType, collectionItemCopy, null);
        } else if (eventType == EventTypeInternal.ItemRemoved) {
            eventArg = new DataStructureEventArg(cacheName, EventType.ItemRemoved, dataType, collectionItemCopy, null);
        }
        return eventArg;
    }

    public static class EventRegistrationInfo {
        private EventType _eventType;
        private EventDataFilter _filter;
        private short _registrationSequence;

        public EventRegistrationInfo() {
        }

        public EventRegistrationInfo(EventType eventTYpe, EventDataFilter filter, short sequenceId) {
            this._eventType = eventTYpe;
            this._filter = filter;
            this._registrationSequence = sequenceId;
        }

        public final EventType getEventTYpe() {
            return this._eventType;
        }

        public final void setEventTYpe(EventType value) {
            this._eventType = value;
        }

        public final EventDataFilter getDataFilter() {
            return this._filter;
        }

        public final void setDataFilter(EventDataFilter value) {
            this._filter = value;
        }

        public final short getRegistrationSequence() {
            return this._registrationSequence;
        }

        public final void setRegistrationSequence(short value) {
            this._registrationSequence = value;
        }
    }
}

