/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.runtime.caching.expiration.Expiration;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationConstants;
import com.alachisoft.ncache.runtime.caching.expiration.ExpirationType;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.text.ParseException;
import java.util.Date;

class ExpirationUtil {
    ExpirationUtil() {
    }

    public static Expiration getExpiration(Date absoluteExpiration, TimeSpan slidingExpiration) throws ParseException {
        Expiration modernSlidingExpiration = new Expiration(ExpirationType.None);
        Expiration modernAbsoluteExpiration = new Expiration(ExpirationType.None);
        if (absoluteExpiration != null && slidingExpiration != null) {
            if (slidingExpiration.equals(ExpirationConstants.SlidingDefaultExpiration)) {
                modernSlidingExpiration = new Expiration(ExpirationType.DefaultSliding);
            } else if (slidingExpiration.equals(ExpirationConstants.SlidingDefaultLongerExpiration)) {
                modernSlidingExpiration = new Expiration(ExpirationType.DefaultSlidingLonger);
            } else if (!slidingExpiration.equals(ExpirationConstants.SlidingNoneExpiration)) {
                modernSlidingExpiration = new Expiration(ExpirationType.Sliding, slidingExpiration);
            }
            if (NCDateTime.getUTCDate((Date)absoluteExpiration).equals(NCDateTime.getUTCDate((Date)ExpirationConstants.AbsoluteDefaultExpiration))) {
                modernAbsoluteExpiration = new Expiration(ExpirationType.DefaultAbsolute);
            } else if (NCDateTime.getUTCDate((Date)absoluteExpiration).equals(NCDateTime.getUTCDate((Date)ExpirationConstants.AbsoluteDefaultLongerExpiration))) {
                modernAbsoluteExpiration = new Expiration(ExpirationType.DefaultAbsoluteLonger);
            } else if (!NCDateTime.getUTCDate((Date)absoluteExpiration).equals(NCDateTime.getUTCDate((Date)ExpirationConstants.AbsoluteNoneExpiration))) {
                try {
                    modernAbsoluteExpiration = new Expiration(ExpirationType.Absolute, TimeSpan.subtract((Date)absoluteExpiration, (Date)new NCDateTime(new Date()).getLocalizedDate()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        return modernAbsoluteExpiration.getExpirationType() == ExpirationType.None ? modernSlidingExpiration : modernAbsoluteExpiration;
    }
}

