/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.Enum.EventType;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import Alachisoft.NCache.Common.Logger.EventLogger;
import com.alachisoft.ncache.client.CacheConnectionOptions;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheItem;
import com.alachisoft.ncache.client.CacheItemVersion;
import com.alachisoft.ncache.client.CacheManager;
import com.alachisoft.ncache.client.CacheSyncDependency;
import com.alachisoft.ncache.client.LockHandle;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ClientCacheSearchService;
import com.alachisoft.ncache.client.internal.caching.DisconnectedClientCache;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.caching.FailSafeClientCacheSearchService;
import com.alachisoft.ncache.client.services.SearchService;
import com.alachisoft.ncache.runtime.CacheItemPriority;
import com.alachisoft.ncache.runtime.caching.CacheItemAttributes;
import com.alachisoft.ncache.runtime.caching.DataSourceModifiedListener;
import com.alachisoft.ncache.runtime.caching.NamedTagsDictionary;
import com.alachisoft.ncache.runtime.caching.ReadThruOptions;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.caching.WriteMode;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.exceptions.AggregateException;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.ConfigurationException;
import com.alachisoft.ncache.runtime.exceptions.GeneralFailureException;
import com.alachisoft.ncache.runtime.exceptions.LicensingException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.exceptions.OperationNotSupportedException;
import com.alachisoft.ncache.runtime.exceptions.SecurityException;
import com.alachisoft.ncache.runtime.exceptions.StreamAlreadyLockedException;
import com.alachisoft.ncache.runtime.exceptions.StreamException;
import com.alachisoft.ncache.runtime.exceptions.StreamNotFoundException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.FutureTask;
import tangible.RefObject;

public class FailSafeClientCache
extends DisconnectedClientCache {
    private CacheConnectionOptions _cacheConnectionOption;
    private String _clientCacheId;
    private boolean _isClientCacheEnable;
    private boolean _isConnectivityThreadRunning;
    private Thread _clientCacheConnectivityThread;
    private int _clientCacheConnectionRetryInterval;
    private FailSafeClientCacheSearchService privateFailSafeSearchService;

    public FailSafeClientCache(CacheImpl l2, CacheImpl l1, String userid, String pswd, boolean isPessimistic, int retryL1connectionInterval) throws Exception {
        super(l2, l1, userid, pswd, isPessimistic);
        this._isClientCacheEnable = true;
        this._clientCacheConnectionRetryInterval = retryL1connectionInterval;
        if (this._nearCache == null) {
            this.switchToClusteredCache();
        }
    }

    public FailSafeClientCache(CacheImpl l2, CacheImpl l1, String userid, String pswd, boolean isPessimistic, CacheConnectionOptions cacheConnectionOption, String clientCacheId, int retryL1connectionInterval) throws Exception {
        super(l2, l1, userid, pswd, isPessimistic);
        this._cacheConnectionOption = cacheConnectionOption;
        this._clientCacheId = clientCacheId;
        this._isClientCacheEnable = true;
        this._clientCacheConnectionRetryInterval = retryL1connectionInterval;
        if (this._nearCache == null) {
            this.switchToClusteredCache();
        }
    }

    public final FailSafeClientCacheSearchService getFailSafeSearchService() {
        return this.privateFailSafeSearchService;
    }

    public final void setFailSafeSearchService(FailSafeClientCacheSearchService value) {
        this.privateFailSafeSearchService = value;
    }

    @Override
    public SearchService getSearchService() {
        if (!this.getFailSafeSearchService().getIsClientCacheActive()) {
            this.switchToClusteredCache();
        }
        return this.getFailSafeSearchService();
    }

    @Override
    public void setSearchService(SearchService value) {
        this.setFailSafeSearchService((FailSafeClientCacheSearchService)(value instanceof FailSafeClientCacheSearchService ? value : null));
    }

    @Override
    public CacheImpl getNearCacheInstance() {
        if (this._isClientCacheEnable) {
            this._clientCacheUsed = true;
            return this._nearCache;
        }
        this._clientCacheUsed = false;
        return this._farCache;
    }

    @Override
    public void setNearCacheProperties() throws Exception {
        if (this._nearCache != null) {
            this.InitializeEncryption();
            this._nearCache.setQueryTypeInfoMap(this._farCache.getQueryTypeMap());
            this._nearCache.setSerializationContext(this._farCache.getSerializationContext());
            this._nearCache.setSerializationFormat(this._farCache.getSerializationFormat());
        }
        this.setFailSafeSearchService(new FailSafeClientCacheSearchService(this._farCache, this._nearCache));
        super.setSearchService(new ClientCacheSearchService(this._farCache, this._nearCache));
    }

    @Override
    protected boolean getThrowError() {
        return true;
    }

    @Override
    public CacheSyncDependency getCacheSyncDependency(String key) {
        if (this._isClientCacheEnable) {
            return super.getCacheSyncDependency(key);
        }
        return null;
    }

    @Override
    public CacheItemVersion addOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode writeOption, DataSourceModifiedListener dataSourceModifiedCallback, EventTypeInternal eventTypeInternal, boolean isResyncExpiredItems, String group, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUdpatedCallback, CacheDataModificationListener cacheItemRemovedCallaback, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, RefObject<Long> size, boolean allowQueryTags, String clientId, short updateCallbackID, short removeCallbackID, short dsItemAddedCallbackID) throws CacheException {
        try {
            return super.addOperation(key, value, dependency, null, absoluteExpiration, slidingExpiration, priority, writeOption, dataSourceModifiedCallback, eventTypeInternal, isResyncExpiredItems, group, tags, providerName, resyncProviderName, namedTags, cacheItemUdpatedCallback, cacheItemRemovedCallaback, itemUpdateDataFilter, itemRemovedDataFilter, size, allowQueryTags, clientId, updateCallbackID, removeCallbackID, dsItemAddedCallbackID);
        }
        catch (CacheException | RuntimeException e) {
            if (this.isConnectivityErrorFromClientCache(e.getMessage())) {
                this.switchToClusteredCache();
                return super.addOperation(key, value, dependency, null, absoluteExpiration, slidingExpiration, priority, writeOption, dataSourceModifiedCallback, eventTypeInternal, isResyncExpiredItems, group, tags, providerName, resyncProviderName, namedTags, cacheItemUdpatedCallback, cacheItemRemovedCallaback, itemUpdateDataFilter, itemRemovedDataFilter, size, allowQueryTags, clientId, updateCallbackID, removeCallbackID, dsItemAddedCallbackID);
            }
            if (this.isExceptionsEnabled()) {
                throw e;
            }
            return null;
        }
    }

    @Override
    public Map<String, Exception> addBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws OperationFailedException, StreamNotFoundException, StreamException, ConfigurationException, CommandException, AggregateException, GeneralFailureException, OperationNotSupportedException, StreamAlreadyLockedException, LicensingException, SecurityException {
        try {
            return super.addBulk(items, writeThruOptions);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.addBulk(items, writeThruOptions);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public CacheItemVersion insertOperation(String key, Object value, CacheDependency dependency, CacheSyncDependency syncDependency, Date absoluteExpiration, TimeSpan slidingExpiration, CacheItemPriority priority, WriteMode WriteMode2, DataSourceModifiedListener dataSourceModifiedCallback, EventTypeInternal eventType, boolean isResyncExpiredItems, String group, LockHandle lockHandle, CacheItemVersion version, LockAccessType accessType, Tag[] tags, String providerName, String resyncProviderName, NamedTagsDictionary namedTags, CacheDataModificationListener cacheItemUdpatedCallback, CacheDataModificationListener onRemoveCallback, EventDataFilter itemUpdateDataFilter, EventDataFilter itemRemovedDataFilter, boolean allowQueryTags, String clientId, short updateCallbackId, short removeCallbackId, short dataSourceUpdatedCallbackId) throws CacheException {
        try {
            return super.insertOperation(key, value, dependency, syncDependency, absoluteExpiration, slidingExpiration, priority, WriteMode2, dataSourceModifiedCallback, eventType, isResyncExpiredItems, group, lockHandle, version, accessType, tags, providerName, resyncProviderName, namedTags, cacheItemUdpatedCallback, onRemoveCallback, itemUpdateDataFilter, itemRemovedDataFilter, allowQueryTags, clientId, updateCallbackId, removeCallbackId, dataSourceUpdatedCallbackId);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.insertOperation(key, value, dependency, syncDependency, absoluteExpiration, slidingExpiration, priority, WriteMode2, dataSourceModifiedCallback, eventType, isResyncExpiredItems, group, lockHandle, version, accessType, tags, providerName, resyncProviderName, namedTags, cacheItemUdpatedCallback, onRemoveCallback, itemUpdateDataFilter, itemRemovedDataFilter, allowQueryTags, clientId, updateCallbackId, removeCallbackId, dataSourceUpdatedCallbackId);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public Map<String, Exception> insertBulk(Map<String, CacheItem> items, WriteThruOptions writeThruOptions) throws CacheException {
        try {
            return super.insertBulk(items, writeThruOptions);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.insertBulk(items, writeThruOptions);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public boolean updateAttributes(String key, CacheItemAttributes attributes) throws CacheException {
        try {
            return super.updateAttributes(key, attributes);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.updateAttributes(key, attributes);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return false;
        }
    }

    @Override
    public <T> T remove(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions, Class<?> cls) throws CacheException {
        try {
            return super.remove(key, lockHandle, version, writeThruOptions, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.remove(key, lockHandle, version, writeThruOptions, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public void delete(String key, LockHandle lockHandle, CacheItemVersion version, WriteThruOptions writeThruOptions) throws CacheException {
        block3: {
            try {
                super.delete(key, lockHandle, version, writeThruOptions);
            }
            catch (CacheException | RuntimeException ex) {
                if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                    this.switchToClusteredCache();
                    super.delete(key, lockHandle, version, writeThruOptions);
                }
                if (!this.isExceptionsEnabled()) break block3;
                throw ex;
            }
        }
    }

    @Override
    public <T> Map<String, T> removeBulk(Iterable<String> keys, WriteThruOptions writeThruOption, Class<?> cls) throws CacheException {
        try {
            return super.removeBulk(keys, writeThruOption, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.removeBulk(keys, writeThruOption, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public void deleteBulk(Iterable<String> keys, WriteThruOptions writeThruOptions) throws CacheException {
        block3: {
            this.getNearCacheInstance().deleteBulk(keys, writeThruOptions);
            try {
                super.deleteBulk(keys, writeThruOptions);
            }
            catch (CacheException | RuntimeException ex) {
                if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                    this.switchToClusteredCache();
                    super.deleteBulk(keys, writeThruOptions);
                }
                if (!this.isExceptionsEnabled()) break block3;
                throw ex;
            }
        }
    }

    @Override
    public <T> FutureTask<T> removeAsync(String key, WriteThruOptions writeThruOptions, Class<?> cls) {
        try {
            return super.removeAsync(key, writeThruOptions, cls);
        }
        catch (Exception ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.removeAsync(key, writeThruOptions, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public <T> T get(String key, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException {
        try {
            return super.get(key, readThruOptions, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.get(key, readThruOptions, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public <T> T get(String key, CacheItemVersion version, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException {
        try {
            return super.get(key, version, readThruOptions, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.get(key, version, readThruOptions, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public <T> T get(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle, Class<?> cls) throws CacheException {
        try {
            return super.get(key, acquireLock, lockTimeout, lockHandle, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.get(key, acquireLock, lockTimeout, lockHandle, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public <T> T getInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readOptions, Class<?> cls) throws CacheException {
        try {
            return super.getInternal(key, version, accessType, lockTimeout, lockHandle, readOptions, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.getInternal(key, version, accessType, lockTimeout, lockHandle, readOptions, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public <T> Map<String, T> getBulk(Iterable<String> keys, ReadThruOptions readThruOptions, Class<?> cls) throws CacheException {
        try {
            return super.getBulk(keys, readThruOptions, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.getBulk(keys, readThruOptions, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public CacheItem getCacheItem(String key, ReadThruOptions readThruOptions) throws CacheException {
        try {
            return super.getCacheItem(key, readThruOptions);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.getCacheItem(key, readThruOptions);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public CacheItem getCacheItem(String key, boolean acquireLock, TimeSpan lockTimeout, LockHandle lockHandle) throws CacheException {
        try {
            return super.getCacheItem(key, acquireLock, lockTimeout, lockHandle);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.getCacheItem(key, acquireLock, lockTimeout, lockHandle);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public Map<String, CacheItem> getCacheItemBulk(Iterable<String> keys, ReadThruOptions readThruOptions) throws CacheException {
        try {
            return super.getCacheItemBulk(keys, readThruOptions);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.getCacheItemBulk(keys, readThruOptions);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public CacheItem getCacheItemInternal(String key, CacheItemVersion version, LockAccessType accessType, TimeSpan lockTimeout, LockHandle lockHandle, ReadThruOptions readOptions) throws CacheException {
        try {
            return super.getCacheItemInternal(key, version, accessType, lockTimeout, lockHandle, readOptions);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.getCacheItemInternal(key, version, accessType, lockTimeout, lockHandle, readOptions);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public <T> T getIfNewer(String key, CacheItemVersion version, Class<?> cls) throws CacheException {
        try {
            return super.getIfNewer(key, version, cls);
        }
        catch (CacheException | RuntimeException ex) {
            if (this.isConnectivityErrorFromClientCache(ex.getMessage())) {
                this.switchToClusteredCache();
                return super.getIfNewer(key, version, cls);
            }
            if (this.isExceptionsEnabled()) {
                throw ex;
            }
            return null;
        }
    }

    @Override
    public void close() {
        if (this._clientCacheConnectivityThread != null && this._clientCacheConnectivityThread.isAlive()) {
            this._clientCacheConnectivityThread.interrupt();
        }
    }

    @Override
    public String toString() {
        return "L1 cache=" + this._clientCacheId + ", L2 cache=" + this._farCache.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchToClusteredCache() {
        FailSafeClientCache failSafeClientCache = this;
        synchronized (failSafeClientCache) {
            this._isClientCacheEnable = false;
            if (!this._isConnectivityThreadRunning) {
                this._isConnectivityThreadRunning = true;
                this._clientCacheConnectivityThread = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FailSafeClientCache.this.tryToReConnectL1Cache();
                        }
                        catch (CacheException cacheException) {
                            // empty catch block
                        }
                    }
                });
                this._clientCacheConnectivityThread.start();
            }
        }
    }

    private boolean isConnectivityErrorFromClientCache(String message) {
        return message.contains("No server is available") && this._clientCacheUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToReConnectL1Cache() throws CacheException {
        ArrayList<String> keys = new ArrayList<String>();
        keys.add("key");
        EventLogger.LogEvent((String)"NCache", (String)(this._clientCacheId + " is not running. All operations will be performed on clustered cache. Please start client cache, otherwise application performance may degrade."), (EventType)EventType.WARNING, (short)2, (int)1023);
        while (true) {
            try {
                if (this._nearCache != null) {
                    this._nearCache.touch(keys);
                } else {
                    try {
                        this._nearCache = CacheManager.initializeClientCache(this._clientCacheId, this._cacheConnectionOption, this._farCache, true);
                        this.setNearCacheProperties();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                FailSafeClientCache e = this;
                synchronized (e) {
                    this._isClientCacheEnable = true;
                    this._isConnectivityThreadRunning = false;
                    this.getFailSafeSearchService().SetClientCacheActive(this._nearCache);
                    EventLogger.LogEvent((String)"NCache", (String)("Connectivity with " + this._clientCacheId + " is established."), (EventType)EventType.INFORMATION, (short)3, (int)1023);
                }
            }
            catch (CacheException | RuntimeException ex) {
                if (!ex.getMessage().contains("No server is available")) {
                    throw ex;
                }
                try {
                    Thread.sleep(TimeSpan.FromSeconds((double)this._clientCacheConnectionRetryInterval).getTotalMiliSeconds());
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }
}

