/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.TagSearchOptions;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.ClientCacheSearchService;
import com.alachisoft.ncache.runtime.caching.Tag;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.List;

public class FailSafeClientCacheSearchService
extends ClientCacheSearchService {
    protected boolean _isClientCacheActive;

    boolean getIsClientCacheActive() {
        return this._isClientCacheActive;
    }

    void setIsClientCacheActive(boolean value) {
        this._isClientCacheActive = value;
    }

    public FailSafeClientCacheSearchService(CacheImpl cache, CacheImpl nearCache) {
        super(cache, nearCache);
        if (nearCache == null) {
            this.setIsClientCacheActive(false);
            this._clientCacheUsed = false;
        } else {
            this.setIsClientCacheActive(true);
            this._clientCacheUsed = true;
        }
    }

    @Override
    public void removeByTag(Tag tag) throws CacheException {
        try {
            super.removeByTag(tag);
        }
        catch (RuntimeException ex) {
            if (this.IsConnectivityErrorFromClientCache(ex)) {
                this.SwitchToClusteredCache();
                super.removeByTag(tag);
            }
            throw ex;
        }
    }

    @Override
    public void removeByTags(List<Tag> tags, TagSearchOptions type) throws CacheException {
        try {
            super.removeByTags(tags, type);
        }
        catch (RuntimeException ex) {
            if (this.IsConnectivityErrorFromClientCache(ex)) {
                this.SwitchToClusteredCache();
                super.removeByTags(tags, type);
            }
            throw ex;
        }
    }

    @Override
    public void removeGroupData(String group) throws CacheException {
        try {
            super.removeGroupData(group);
        }
        catch (RuntimeException ex) {
            if (this.IsConnectivityErrorFromClientCache(ex)) {
                this.SwitchToClusteredCache();
                super.removeGroupData(group);
            }
            throw ex;
        }
    }

    private boolean IsConnectivityErrorFromClientCache(RuntimeException exception) {
        return exception != null && exception.getMessage().contains("No server is available") && this._clientCacheUsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SwitchToClusteredCache() {
        FailSafeClientCacheSearchService failSafeClientCacheSearchService = this;
        synchronized (failSafeClientCacheSearchService) {
            this.setIsClientCacheActive(false);
        }
    }

    @Override
    public CacheImpl getNearCacheContainer() {
        if (this.getIsClientCacheActive()) {
            this._clientCacheUsed = true;
            return this._nearCacheContainer;
        }
        this._clientCacheUsed = false;
        return this.cacheContainer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void SetClientCacheActive(CacheImpl cache) {
        FailSafeClientCacheSearchService failSafeClientCacheSearchService = this;
        synchronized (failSafeClientCacheSearchService) {
            this.setIsClientCacheActive(true);
            this._nearCacheContainer = cache;
        }
    }
}

