/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.EventUtil;
import com.alachisoft.ncache.client.internal.caching.CacheItemRemovedReason;
import com.alachisoft.ncache.client.internal.caching.EventManager;
import com.alachisoft.ncache.client.internal.messaging.MessageEventItem;
import com.alachisoft.ncache.runtime.caching.MessageEventArgs;
import com.alachisoft.ncache.runtime.caching.messaging.MessageReceivedListener;
import com.alachisoft.ncache.runtime.events.EventType;

class GeneralEventMessageReceivedListener
implements MessageReceivedListener {
    private EventManager _eventManager;

    GeneralEventMessageReceivedListener(EventManager eventManager) {
        this._eventManager = eventManager;
    }

    public void onMessageReceived(Object sender, MessageEventArgs args) {
        EventUtil.MessageItemType type = EventUtil.getMessageItemType(args);
        switch (type) {
            case MessageEventItem: {
                this.onGeneralEventMessageReceived((MessageEventItem)args.getMessage().getPayload());
                break;
            }
            case MessageEventItems: {
                MessageEventItem[] messages = (MessageEventItem[])(args.getMessage().getPayload() instanceof MessageEventItem[] ? args.getMessage().getPayload() : null);
                if (messages == null) break;
                for (MessageEventItem item : messages) {
                    this.onGeneralEventMessageReceived(item);
                }
                break;
            }
        }
    }

    private void onGeneralEventMessageReceived(MessageEventItem eventMessage) {
        String key = eventMessage.getKey();
        switch (eventMessage.getEventType()) {
            case ITEM_ADDED_EVENT: {
                this._eventManager.raiseGeneralCacheNotification(key, EventType.ItemAdded, eventMessage.getItem(), null, CacheItemRemovedReason.Underused, false);
                break;
            }
            case ITEM_UPDATED_EVENT: {
                this._eventManager.raiseGeneralCacheNotification(key, EventType.ItemUpdated, eventMessage.getItem(), eventMessage.getOldItem(), CacheItemRemovedReason.Underused, false);
                break;
            }
            case ITEM_REMOVED_EVENT: {
                this._eventManager.raiseGeneralCacheNotification(key, EventType.ItemRemoved, eventMessage.getItem(), null, eventMessage.getReason(), false);
            }
        }
    }
}

