/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Common.Enum.TopicOperationType;
import Alachisoft.NCache.Common.Threading.ThreadPool;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.client.CacheDataModificationListener;
import com.alachisoft.ncache.client.CacheEventDescriptor;
import com.alachisoft.ncache.client.ContinuousQuery;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.caching.EventManager;
import com.alachisoft.ncache.client.internal.messaging.MessageManager;
import com.alachisoft.ncache.client.internal.messaging.TopicIdentity;
import com.alachisoft.ncache.client.services.MessagingService;
import com.alachisoft.ncache.runtime.caching.Topic;
import com.alachisoft.ncache.runtime.caching.messaging.TopicPriority;
import com.alachisoft.ncache.runtime.caching.messaging.TopicSearchOptions;
import com.alachisoft.ncache.runtime.events.EventDataFilter;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.CacheException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.concurrent.FutureTask;
import tangible.DotNetToJavaStringHelper;

class MessagingServiceImpl
implements MessagingService {
    private MessageManager pubSubManager;
    private CacheImpl cacheContainer;

    MessagingServiceImpl(EventManager eventManager, StatisticsCounter perfStatsCollector, CacheImpl cache) {
        this.pubSubManager = new MessageManager(eventManager, perfStatsCollector);
        this.pubSubManager.initialize();
        this.cacheContainer = cache;
    }

    public MessageManager getPubSubManager() {
        return this.pubSubManager;
    }

    public CacheImpl getCacheContainer() {
        return this.cacheContainer;
    }

    public void setCacheContainer(CacheImpl cache) {
        this.cacheContainer = cache;
    }

    @Override
    public Topic getTopic(String topicName) throws CacheException {
        return this.getTopic(topicName, TopicSearchOptions.ByName);
    }

    @Override
    public Topic getTopic(String topicName, TopicSearchOptions searchOptions) throws CacheException {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)topicName)) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: topicName");
        }
        TopicIdentity topicPair = new TopicIdentity(topicName, searchOptions);
        return this.pubSubManager.getOrCreateTopic(topicPair, searchOptions == TopicSearchOptions.ByName ? TopicOperationType.Get : TopicOperationType.GetPatternBased, false);
    }

    @Override
    public Topic createTopic(String topicName, TopicPriority topicPriority) throws CacheException, IllegalArgumentException {
        if (DotNetToJavaStringHelper.isNullOrEmpty((String)topicName)) {
            throw new IllegalArgumentException("Value cannot be null or empty." + System.lineSeparator() + "Parameter name: topicName");
        }
        TopicIdentity topicPair = new TopicIdentity(topicName, TopicSearchOptions.ByName, topicPriority);
        return this.pubSubManager.getOrCreateTopic(topicPair, TopicOperationType.Create, false);
    }

    @Override
    public Topic createTopic(String topicName) throws CacheException, IllegalArgumentException {
        return this.createTopic(topicName, TopicPriority.Normal);
    }

    @Override
    public void deleteTopic(String topicName) throws CacheException {
        if (topicName == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: topicName");
        }
        if (topicName == "") {
            throw new IllegalArgumentException("Value cannot be empty.\nParameter name: topicName");
        }
        this.pubSubManager.deleteTopic(topicName);
    }

    @Override
    public FutureTask deleteTopicAsync(String topicName) throws CacheException {
        if (topicName == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: topicName");
        }
        if (topicName == "") {
            throw new IllegalArgumentException("Value cannot be empty.\nParameter name: topicName");
        }
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            this.pubSubManager.deleteTopic(topicName);
            return null;
        });
        ThreadPool.getInstance().submitTask(task);
        return task;
    }

    public Topic getTopic(String topicName, boolean flag) throws CacheException {
        TopicIdentity topicPair = new TopicIdentity(topicName, TopicSearchOptions.ByName);
        return this.pubSubManager.getOrCreateTopic(topicPair, TopicOperationType.Get, flag);
    }

    protected void onReregisterTopic() {
        try {
            if (this.pubSubManager != null && this.pubSubManager.getReregisterTopicListener() != null) {
                this.pubSubManager.onTopicReregisterListener();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void registerCQ(ContinuousQuery query) throws CacheException {
        if (query == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: query");
        }
        if (!(query.notifyAddInternal() || query.notifyUpdateInternal() || query.notifyRemoveInternal())) {
            throw new IllegalArgumentException("There is no event registered for this query. Please register at least one event (add/update/remove) before activating continuous query.");
        }
        this.cacheContainer.registerCQ(query);
        this.cacheContainer.getCQManager().register(query, this.cacheContainer);
    }

    @Override
    public void addCacheNotificationListener(String key, CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter eventDataFilter) throws CacheException {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: listener");
        }
        if (eventTypes == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventTypes");
        }
        if (eventDataFilter == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventDataFilter");
        }
        this.cacheContainer.registerCacheNotificationInternal(key, listener, eventTypes, eventDataFilter, true);
    }

    @Override
    public void addCacheNotificationListener(Iterable<String> keys, CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter eventDataFilter) throws CacheException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        ArrayList<String> stringArray = new ArrayList<String>();
        for (String key : keys) {
            if (key == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Value cannot be Empty." + System.lineSeparator() + "Parameter name: key");
            }
            stringArray.add(key);
        }
        String[] keysList = new String[]{};
        keysList = stringArray.toArray(keysList);
        if (listener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: listener");
        }
        if (eventTypes == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventTypes");
        }
        if (eventDataFilter == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventDataFilter");
        }
        this.cacheContainer.addCacheDataNotificationListener(keysList, listener, eventTypes, eventDataFilter, true);
    }

    @Override
    public CacheEventDescriptor addCacheNotificationListener(CacheDataModificationListener listener, EnumSet<EventType> eventTypes, EventDataFilter eventDataFilter) throws CacheException {
        if (listener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: listener");
        }
        if (eventTypes == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventType");
        }
        if (eventDataFilter == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventDataFilter");
        }
        return this.cacheContainer.registerCacheNotificationInternal(null, listener, eventTypes, eventDataFilter, true);
    }

    @Override
    public void unRegisterCQ(ContinuousQuery query) throws Exception {
        if (query == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: query");
        }
        this.cacheContainer.removeCQ(query);
        this.cacheContainer.getCQManager().unRegister(query);
    }

    @Override
    public void removeCacheNotificationListener(CacheEventDescriptor descriptor) throws Exception {
        if (descriptor == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: descriptor");
        }
        this.cacheContainer.removeCacheNotification(descriptor);
    }

    @Override
    public void removeCacheNotificationListener(String key, CacheDataModificationListener listener, EnumSet<EventType> eventTypes) throws CacheException {
        if (key == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
        }
        if (key.isEmpty()) {
            throw new IllegalArgumentException("Value cannot be empty.\nParameter name: key");
        }
        if (listener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: listener");
        }
        if (eventTypes == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventTypes");
        }
        this.cacheContainer.removeCacheNotification(key, listener, eventTypes);
    }

    @Override
    public void removeCacheNotificationListener(Iterable<String> keys, CacheDataModificationListener listener, EnumSet<EventType> eventTypes) throws CacheException {
        if (keys == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: keys");
        }
        ArrayList<String> stringArray = new ArrayList<String>();
        for (String key : keys) {
            if (key == null) {
                throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: key");
            }
            if (key.isEmpty()) {
                throw new IllegalArgumentException("Value cannot be empty.\nParameter name: key");
            }
            stringArray.add(key);
        }
        String[] keysList = new String[]{};
        keysList = stringArray.toArray(keysList);
        if (listener == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: listener");
        }
        if (eventTypes == null) {
            throw new IllegalArgumentException("Value cannot be null." + System.lineSeparator() + "Parameter name: eventTypes");
        }
        this.cacheContainer.removeCacheNotification(keysList, listener, eventTypes);
    }

    void OnReregisterTopic() {
        try {
            if (this.pubSubManager != null && this.pubSubManager.getReregisterTopicListener() != null) {
                this.pubSubManager.onTopicReregisterListener();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void dispose() {
        this.pubSubManager.dispose();
    }
}

