/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import com.alachisoft.ncache.client.internal.caching.AggregateFunctionType;
import com.alachisoft.ncache.client.internal.caching.QueryType;
import com.alachisoft.ncache.client.internal.util.DictionaryEntry;
import com.alachisoft.ncache.runtime.queries.AverageResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

class QueryResultSet {
    private Collection searchKeysResult = new ArrayList();
    private HashMap searchEntriesResult;
    private DictionaryEntry<Object, Object> aggregateFunctionResult;
    private QueryType queryType = QueryType.SearchKeys;
    private AggregateFunctionType aggregateFunctionType = AggregateFunctionType.NOTAPPLICABLE;
    private String CQUniqueId;
    private boolean isInitialized;

    QueryResultSet() {
    }

    public boolean isIsInitialized() {
        return this.isInitialized;
    }

    public String getCQUniqueId() {
        return this.CQUniqueId;
    }

    public void setCQUniqueId(String CQUniqueId) {
        this.CQUniqueId = CQUniqueId;
    }

    public QueryType getQueryType() {
        return this.queryType;
    }

    public void setQueryType(QueryType queryType) {
        this.queryType = queryType;
    }

    public void setQueryType(int queryType) {
        switch (queryType) {
            case 0: {
                this.queryType = QueryType.SearchKeys;
                break;
            }
            case 1: {
                this.queryType = QueryType.SearchEntries;
                break;
            }
            case 2: {
                this.queryType = QueryType.AggregateFunction;
            }
        }
    }

    public AggregateFunctionType getAggregateFunctionType() {
        return this.aggregateFunctionType;
    }

    public void setAggregateFunctionType(AggregateFunctionType aggregateFunctionType) {
        this.aggregateFunctionType = aggregateFunctionType;
    }

    public void setAggregateFunctionType(int aggregateFunctionType) {
        switch (aggregateFunctionType) {
            case 0: {
                this.aggregateFunctionType = AggregateFunctionType.SUM;
                break;
            }
            case 1: {
                this.aggregateFunctionType = AggregateFunctionType.COUNT;
                break;
            }
            case 2: {
                this.aggregateFunctionType = AggregateFunctionType.MIN;
                break;
            }
            case 3: {
                this.aggregateFunctionType = AggregateFunctionType.MAX;
                break;
            }
            case 4: {
                this.aggregateFunctionType = AggregateFunctionType.AVG;
                break;
            }
            case 5: {
                this.aggregateFunctionType = AggregateFunctionType.NOTAPPLICABLE;
            }
        }
    }

    public DictionaryEntry<Object, Object> getAggregateFunctionResult() {
        return this.aggregateFunctionResult;
    }

    public void setAggregateFunctionResult(DictionaryEntry<Object, Object> aggregateFunctionResult) {
        this.aggregateFunctionResult = aggregateFunctionResult;
    }

    public Collection getSearchKeysResult() {
        return this.searchKeysResult;
    }

    public void setSearchKeysResult(Collection searchKeysResult) {
        this.searchKeysResult = searchKeysResult;
    }

    public HashMap getSearchEntriesResult() {
        return this.searchEntriesResult;
    }

    public void setSearchEntriesResult(HashMap searchEnteriesResult) {
        this.searchEntriesResult = searchEnteriesResult;
    }

    public void Compile(QueryResultSet resultSet) {
        if (!this.isInitialized) {
            this.Initialize(resultSet);
            return;
        }
        switch (this.getQueryType()) {
            case AggregateFunction: {
                AggregateFunctionType type = AggregateFunctionType.valueOf(this.getAggregateFunctionResult().getKey().toString());
                switch (type) {
                    case SUM: {
                        Object thisVal = this.getAggregateFunctionResult().getValue();
                        Object otherVal = resultSet.getAggregateFunctionResult().getValue();
                        BigDecimal sum = null;
                        if (thisVal == null && otherVal != null) {
                            sum = (BigDecimal)otherVal;
                        } else if (thisVal != null && otherVal == null) {
                            sum = (BigDecimal)thisVal;
                        } else if (thisVal != null && otherVal != null) {
                            BigDecimal a = (BigDecimal)thisVal;
                            BigDecimal b = (BigDecimal)otherVal;
                            sum = a.add(b);
                        }
                        if (sum != null) {
                            this.setAggregateFunctionResult(new DictionaryEntry<AggregateFunctionType, BigDecimal>(AggregateFunctionType.SUM, sum));
                            break;
                        }
                        this.setAggregateFunctionResult(new DictionaryEntry<AggregateFunctionType, Object>(AggregateFunctionType.SUM, null));
                        break;
                    }
                    case COUNT: {
                        BigDecimal a = (BigDecimal)this.getAggregateFunctionResult().getValue();
                        BigDecimal b = (BigDecimal)resultSet.getAggregateFunctionResult().getValue();
                        BigDecimal count = a.add(b);
                        this.setAggregateFunctionResult(new DictionaryEntry<AggregateFunctionType, BigDecimal>(AggregateFunctionType.COUNT, count));
                        break;
                    }
                    case MIN: {
                        Comparable thisValue = (Comparable)this.getAggregateFunctionResult().getValue();
                        Comparable otherValue = (Comparable)resultSet.getAggregateFunctionResult().getValue();
                        Comparable min = thisValue;
                        if (thisValue == null && otherValue != null) {
                            min = otherValue;
                        } else if (thisValue != null && otherValue == null) {
                            min = thisValue;
                        } else if (thisValue == null && otherValue == null) {
                            min = null;
                        } else if (otherValue.compareTo(thisValue) < 0) {
                            min = otherValue;
                        }
                        this.setAggregateFunctionResult(new DictionaryEntry<AggregateFunctionType, Comparable>(AggregateFunctionType.MIN, min));
                        break;
                    }
                    case MAX: {
                        Comparable thisValue = (Comparable)this.getAggregateFunctionResult().getValue();
                        Comparable otherValue = (Comparable)resultSet.getAggregateFunctionResult().getValue();
                        Comparable max = thisValue;
                        if (thisValue == null && otherValue != null) {
                            max = otherValue;
                        } else if (thisValue != null && otherValue == null) {
                            max = thisValue;
                        } else if (thisValue == null && otherValue == null) {
                            max = null;
                        } else if (otherValue.compareTo(thisValue) > 0) {
                            max = otherValue;
                        }
                        this.setAggregateFunctionResult(new DictionaryEntry<AggregateFunctionType, Comparable>(AggregateFunctionType.MAX, max));
                        break;
                    }
                    case AVG: {
                        Object thisVal = this.getAggregateFunctionResult().getValue();
                        Object otherVal = resultSet.getAggregateFunctionResult().getValue();
                        AverageResult avg = null;
                        if (thisVal == null && otherVal != null) {
                            avg = (AverageResult)otherVal;
                        } else if (thisVal != null && otherVal == null) {
                            avg = (AverageResult)thisVal;
                        } else if (thisVal != null && otherVal != null) {
                            AverageResult thisResult = (AverageResult)thisVal;
                            AverageResult otherResult = (AverageResult)otherVal;
                            avg = new AverageResult();
                            avg.setSum(thisResult.getSum().add(otherResult.getSum()));
                            avg.setCount(thisResult.getCount().add(otherResult.getCount()));
                        }
                        if (avg != null) {
                            this.setAggregateFunctionResult(new DictionaryEntry<AggregateFunctionType, AverageResult>(AggregateFunctionType.AVG, avg));
                            break;
                        }
                        this.setAggregateFunctionResult(new DictionaryEntry<AggregateFunctionType, Object>(AggregateFunctionType.AVG, null));
                    }
                }
                break;
            }
            case SearchKeys: {
                if (this.getSearchKeysResult() == null) {
                    this.setSearchKeysResult(resultSet.getSearchKeysResult());
                    break;
                }
                this.getSearchKeysResult().addAll(resultSet.getSearchKeysResult());
                break;
            }
            case SearchEntries: {
                if (this.getSearchEntriesResult() == null) {
                    this.setSearchEntriesResult(resultSet.getSearchEntriesResult());
                    break;
                }
                this.getSearchEntriesResult().putAll(resultSet.getSearchEntriesResult());
            }
        }
    }

    public void Initialize(QueryResultSet resultSet) {
        if (!this.isInitialized) {
            this.setQueryType(resultSet.getQueryType());
            this.setAggregateFunctionType(resultSet.getAggregateFunctionType());
            this.setAggregateFunctionResult(resultSet.getAggregateFunctionResult());
            this.setSearchKeysResult(resultSet.getSearchKeysResult());
            this.setSearchEntriesResult(resultSet.getSearchEntriesResult());
            this.isInitialized = true;
        }
    }
}

