/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.caching;

import Alachisoft.NCache.Caching.AutoExpiration.ExpirationHint;
import Alachisoft.NCache.Caching.AutoExpiration.FixedExpiration;
import Alachisoft.NCache.Caching.AutoExpiration.IdleExpiration;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import tangible.DotNetToJavaStringHelper;

public final class WebCacheHelper {
    public static ExpirationHint MakeFixedIdleExpirationHint(Date absoluteExpiration, TimeSpan slidingExpiration) {
        if (CacheImpl.NoAbsoluteExpiration.equals(absoluteExpiration) && CacheImpl.NoSlidingExpiration.equals(slidingExpiration)) {
            return null;
        }
        if (CacheImpl.NoAbsoluteExpiration.equals(absoluteExpiration)) {
            if (slidingExpiration.compareTo(TimeSpan.Zero) < 0) {
                throw new IllegalArgumentException("slidingExpiration");
            }
            Calendar calendar = Calendar.getInstance();
            Calendar currentCalendar = Calendar.getInstance();
            calendar.add(1, 1);
            if (slidingExpiration.getTotalMiliSeconds() - (calendar.getTimeInMillis() - currentCalendar.getTimeInMillis()) >= 0L) {
                throw new IllegalArgumentException("slidingExpiration");
            }
            return new IdleExpiration(slidingExpiration);
        }
        if (CacheImpl.NoSlidingExpiration.equals(slidingExpiration)) {
            return new FixedExpiration(absoluteExpiration);
        }
        throw new IllegalArgumentException("You cannot set both sliding and absolute expirations on the same cache item.");
    }

    public static void EvaluateTagsParameters(Hashtable queryInfo, String group) {
        if (queryInfo != null && !DotNetToJavaStringHelper.isNullOrEmpty((String)group) && queryInfo.get("tag-info") != null && group != null && group.length() != 0 && queryInfo.get("tag-info") != null) {
            throw new IllegalArgumentException("You cannot set both groups and tags on the same cache item.");
        }
    }

    public static byte EvaluateExpirationParameters(Date absoluteExpiration, TimeSpan slidingExpiration) {
        if (CacheImpl.NoAbsoluteExpiration.equals(absoluteExpiration) && CacheImpl.NoSlidingExpiration.equals(slidingExpiration)) {
            return 2;
        }
        if (CacheImpl.NoAbsoluteExpiration.equals(absoluteExpiration)) {
            if (slidingExpiration.compareTo(TimeSpan.Zero) < 0) {
                throw new IllegalArgumentException("slidingExpiration");
            }
            Calendar calendar = Calendar.getInstance();
            Calendar currentCalendar = Calendar.getInstance();
            calendar.add(1, 1);
            if (slidingExpiration.getTotalMiliSeconds() - (calendar.getTimeInMillis() - currentCalendar.getTimeInMillis()) >= 0L) {
                throw new IllegalArgumentException("slidingExpiration");
            }
            return 0;
        }
        if (CacheImpl.NoSlidingExpiration.equals(slidingExpiration)) {
            return 1;
        }
        throw new IllegalArgumentException("You cannot set both sliding and absolute expirations on the same cache item.");
    }
}

