/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.BulkRemoveCommandProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class BulkRemoveCommand
extends Command {
    private final int _methodOverload;
    private String[] keys;
    private BitSet flagMap;
    private int onDsItemsRemovedId;
    private String providerName;
    protected BulkRemoveCommandProtocol.BulkRemoveCommand _commandInstance;

    public BulkRemoveCommand(String[] keys, BitSet flagMap, String providerName, short onDsItemRemovedId, int methodOverLoad) {
        this.name = "BulkRemoveCommand";
        this.keys = keys;
        this.flagMap = flagMap;
        this.providerName = providerName;
        this.onDsItemsRemovedId = onDsItemRemovedId;
        this._methodOverload = methodOverLoad;
        super.setBulkKeys(keys);
    }

    @Override
    protected void createCommand() throws CommandException {
        if (this.keys == null) {
            throw new NullPointerException("keys");
        }
        if (this.keys.length == 0) {
            throw new IllegalArgumentException("There is no key present in keys array");
        }
        BulkRemoveCommandProtocol.BulkRemoveCommand.Builder builder = BulkRemoveCommandProtocol.BulkRemoveCommand.newBuilder();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.keys.length; ++i) {
            if (this.keys[i] == null) continue;
            list.add(this.keys[i]);
        }
        builder = builder.addAllKeys(list).setDatasourceItemRemovedCallbackId(this.onDsItemsRemovedId).setRequestId(super.getRequestId()).setFlag(BitSetConstants.getBitSetData((BitSet)this.flagMap));
        if (this.providerName != null) {
            builder = builder.setProviderName(this.providerName);
        }
        if (this.getIntendedRecipient() != null) {
            builder.setIntendedRecipient(this.getIntendedRecipient());
        }
        builder.setClientLastViewId(this.getClientLastViewId()).setCommandVersion(1).setMethodOverload(this._methodOverload);
        this._commandInstance = builder.build();
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.REMOVE_BULK;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkWrite;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.REMOVE_BULK.getNumber();
    }
}

