/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.CounterCommandProtocol;
import com.alachisoft.ncache.common.protobuf.LockInfoProtocol;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

abstract class CounterCommandBase
extends Command {
    protected String _lockId;
    protected TimeSpan _lockTimeout = new TimeSpan();
    protected WriteThruOptions _writeThruOption;
    protected CounterCommandProtocol.CounterCommand.Builder _counterCommand;

    CounterCommandBase() {
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.COUNTER_COMMAND.getNumber();
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._counterCommand.build().writeTo((OutputStream)stream);
    }

    @Override
    protected void createCommand() {
        this._counterCommand = CounterCommandProtocol.CounterCommand.newBuilder();
        this._counterCommand.setRequestId(super.getRequestId());
        this._counterCommand.setName(this.key);
        LockInfoProtocol.LockInfo.Builder lockInfoBuilder = LockInfoProtocol.LockInfo.newBuilder();
        if (this._lockId != null) {
            lockInfoBuilder.setLockId(this._lockId);
        }
        lockInfoBuilder.setLockTimeout(this._lockTimeout.getTotalTicks());
        this._counterCommand.setLockInfo(lockInfoBuilder);
        if (this._writeThruOption != null) {
            this._counterCommand.setDsWriteOption(this._writeThruOption.getMode().getValue());
            if (this._writeThruOption.getProviderName() != null) {
                this._counterCommand.setProviderName(this._writeThruOption.getProviderName());
            }
        }
    }
}

