/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Caching.Util.ProtobufHelper;
import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.DataTypes.CollectionCreateOrGetOperation;
import Alachisoft.NCache.Common.Util.DependencyHelper;
import com.alachisoft.ncache.client.datastructures.DataStructureAttributes;
import com.alachisoft.ncache.client.internal.caching.CacheHelper;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.util.ConversionUtil;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.DataTypeAttributesProtocol;
import com.alachisoft.ncache.common.protobuf.DataTypeManagementCommandProtocol;
import com.alachisoft.ncache.common.protobuf.DependencyProtocol;
import com.alachisoft.ncache.common.protobuf.ObjectQueryInfoProtocol;
import com.alachisoft.ncache.runtime.caching.DistributedDataStructure;
import com.alachisoft.ncache.runtime.caching.WriteThruOptions;
import com.alachisoft.ncache.runtime.dependencies.CacheDependency;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import com.alachisoft.ncache.runtime.util.NCDateTime;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import com.google.protobuf.ByteString;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;

public class DataTypeCreateCommand
extends Command {
    private int _boundedCapacity;
    private BitSet _flagMap;
    private long _initialValue;
    private WriteThruOptions _writeThruOptions;
    private DataStructureAttributes _dataTypeAttributes;
    private Date absoluteExpiration;
    private TimeSpan slidingExpiration;
    private CacheImpl _cache;
    private boolean _isSerializable;
    private DistributedDataStructure _dataType;
    private DataTypeManagementCommandProtocol.DataTypeManagementCommand _dataTypeManagementCommand;
    private short dataSourceModifiedListenerId;

    public DataTypeCreateCommand(CollectionCreateOrGetOperation operation, int boundedCapacity, BitSet flagMap, DataStructureAttributes dtAttributes, CacheImpl cache, boolean serializable) throws IOException, OperationFailedException {
        this.name = "DataTypeManagementCommand";
        this.key = operation.getName();
        this._boundedCapacity = boundedCapacity;
        this._flagMap = flagMap;
        this._initialValue = operation.getInitialValue();
        this._dataType = operation.getType();
        this._dataTypeAttributes = dtAttributes;
        this._cache = cache;
        this._isSerializable = serializable;
        this._writeThruOptions = operation.getWriteThruOptions();
        this.dataSourceModifiedListenerId = operation.getDataSourceModifiedListenerIdInternal();
        if (dtAttributes != null) {
            this.absoluteExpiration = ConversionUtil.getAbsoluteExpiration(dtAttributes.getExpiration());
            this.slidingExpiration = ConversionUtil.getSlidingExpiration(dtAttributes.getExpiration());
        }
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicWrite;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.DATATYPE_MANAGEMENT.getNumber();
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._dataTypeManagementCommand.writeTo((OutputStream)stream);
    }

    @Override
    protected void createCommand() throws CommandException {
        DataTypeManagementCommandProtocol.DataTypeManagementCommand.Builder builder = DataTypeManagementCommandProtocol.DataTypeManagementCommand.newBuilder();
        builder.setBoundedCapacity(this._boundedCapacity);
        builder.setFlag((int)this._flagMap.getData());
        builder.setInitialValue(this._initialValue);
        builder.setMethod(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Method.CREATE);
        switch (this._dataType) {
            case List: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.LIST);
                break;
            }
            case Queue: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.QUEUE);
                break;
            }
            case Map: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.DICTIONARY);
                break;
            }
            case Set: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.SET);
                break;
            }
            case Counter: {
                builder.setType(DataTypeManagementCommandProtocol.DataTypeManagementCommand.Type.COUNTER);
            }
        }
        DataTypeAttributesProtocol.DataTypeAttributes.Builder dtBuilder = DataTypeAttributesProtocol.DataTypeAttributes.newBuilder();
        dtBuilder.setDatasourceItemAddedCallbackId((int)this.dataSourceModifiedListenerId);
        if (this._dataTypeAttributes != null) {
            HashMap<String, Object> queryInfo = new HashMap<String, Object>();
            queryInfo.put("named-tag-info", this._cache.getNamedTagsInfoForCollection(this.key, this._dataTypeAttributes.getNamedTags()));
            queryInfo.put("tag-info", this._cache.getTagInfoForCollection(ConversionUtil.toArray(this._dataTypeAttributes.getTags())));
            ObjectQueryInfoProtocol.ObjectQueryInfo.Builder objectQueryInfoBuilder = ObjectQueryInfoProtocol.ObjectQueryInfo.newBuilder();
            if (queryInfo.get("tag-info") != null) {
                objectQueryInfoBuilder.setTagInfo(ProtobufHelper.GetTagInfoObj((HashMap)(queryInfo.get("tag-info") instanceof HashMap ? queryInfo.get("tag-info") : null)));
            }
            if (queryInfo.get("named-tag-info") != null) {
                objectQueryInfoBuilder.setNamedTagInfo(ProtobufHelper.GetNamedTagInfoObj((HashMap)(queryInfo.get("named-tag-info") instanceof HashMap ? queryInfo.get("named-tag-info") : null), (boolean)false));
            }
            if (this._isSerializable && objectQueryInfoBuilder.getNamedTagInfo() != null || objectQueryInfoBuilder.getQueryInfo() != null || objectQueryInfoBuilder.getTagInfo() != null) {
                byte[] encryptedResult = CacheHelper.EncryptData(objectQueryInfoBuilder.build().toByteArray(), this.getCacheId());
                builder = builder.addObjectQueryInfoEncrypted(ByteString.copyFrom((byte[])encryptedResult));
            } else {
                builder.setObjectQueryInfo(objectQueryInfoBuilder.build());
            }
            if (this._dataTypeAttributes.getExpiration() != null) {
                long sldExp = 0L;
                long absExp = 0L;
                try {
                    if (this.absoluteExpiration.equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsolute))) {
                        absExp = 1L;
                    } else if (this.absoluteExpiration.equals(NCDateTime.getUTCDate((Date)CacheImpl.defaultAbsoluteLonger))) {
                        absExp = 2L;
                    } else if (this.absoluteExpiration != CacheImpl.NoAbsoluteExpiration) {
                        absExp = HelperFxn.getTicks((Date)NCDateTime.getUTCDate((Date)this.absoluteExpiration));
                    }
                    if (this.slidingExpiration.equals(CacheImpl.DefaultSliding)) {
                        sldExp = 1L;
                    } else if (this.slidingExpiration.equals(CacheImpl.DefaultSlidingLonger)) {
                        sldExp = 2L;
                    } else if (this.slidingExpiration != CacheImpl.NoSlidingExpiration) {
                        sldExp = this.slidingExpiration.getTotalTicks();
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                dtBuilder.setAbsExpiration(absExp);
                dtBuilder.setSldExpiration(sldExp);
            }
            dtBuilder.setIsAsync(this.isAsync);
            dtBuilder.setPriority(this._dataTypeAttributes.getPriority().value());
            if (this._dataTypeAttributes.getResyncOptions() != null) {
                dtBuilder.setIsResync(this._dataTypeAttributes.getResyncOptions().getResyncOnExpiration());
                if (this._dataTypeAttributes.getResyncOptions().getProviderName() != null) {
                    dtBuilder.setResyncProviderName(this._dataTypeAttributes.getResyncOptions().getProviderName());
                }
            }
            if (this._dataTypeAttributes.getGroup() != null) {
                dtBuilder.setGroup(this._dataTypeAttributes.getGroup());
            }
            if (this._dataTypeAttributes.getDependency() != null) {
                try {
                    dtBuilder.setDependency(DependencyHelper.getProtoBufDependency((CacheDependency)this._dataTypeAttributes.getDependency(), (DependencyProtocol.Dependency.Builder)DependencyProtocol.Dependency.newBuilder()));
                }
                catch (OperationFailedException e) {
                    throw new CommandException(e.getMessage());
                }
                catch (IOException e) {
                    throw new CommandException(e.getMessage());
                }
            }
            builder.setDataTypeAttributes(dtBuilder.build());
        } else {
            builder.setDataTypeAttributes(dtBuilder.build());
        }
        builder.setRequestId(super.getRequestId());
        builder.setName(this.key);
        if (this._writeThruOptions != null) {
            builder.setDsWriteOption(this._writeThruOptions.getMode().getValue());
            if (this._writeThruOptions.getProviderName() != null) {
                builder.setProviderName(this._writeThruOptions.getProviderName());
            }
        }
        this._dataTypeManagementCommand = builder.build();
    }
}

