/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.util.QueryCommandHelper;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.DeleteQueryCommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;

public final class DeleteQueryCommand
extends Command {
    private String query;
    private HashMap values;
    private boolean isRemove;
    private int _methodOverload;
    protected DeleteQueryCommandProtocol.DeleteQueryCommand _commandInstance;

    public DeleteQueryCommand(String query, HashMap values, boolean isRemove, int methodOverload) {
        this.query = query;
        this.values = values;
        this.isRemove = isRemove;
        this._methodOverload = methodOverload;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DELETEQUERY;
    }

    @Override
    protected void createCommand() throws CommandException {
        DeleteQueryCommandProtocol.DeleteQueryCommand.Builder builder = DeleteQueryCommandProtocol.DeleteQueryCommand.newBuilder();
        builder.setQuery(this.query).setIsRemove(this.isRemove).setMethodOverload(this._methodOverload);
        List<KeyValueProtocol.KeyValue> valuesToSend = QueryCommandHelper.getValuesFromMap(this.values);
        if (valuesToSend != null) {
            builder.addAllValues(valuesToSend);
        }
        this._commandInstance = builder.setRequestId(super.getRequestId()).setCommandVersion(1).setClientLastViewId(super.getClientLastViewId()).build();
    }

    @Override
    public boolean getIsSafe() {
        return false;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.NonKeyBulkWrite;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.DELETEQUERY.getNumber();
    }
}

