/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryAddOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.DictionaryCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.DictionaryAddProtocol;
import com.alachisoft.ncache.common.protobuf.DictionaryCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.google.protobuf.ByteString;
import java.util.Map;

public class DictionaryAddCommand
extends DictionaryCommandBase {
    private DictionaryAddOperation.OpType _operationType;
    private Map<String, ExtendedJsonValueBase> _collection;
    private DictionaryAddProtocol.DictionaryAdd.Builder _dictionaryAddBuilder;

    public DictionaryAddCommand(DictionaryAddOperation operation) {
        this.name = "DictionaryAdd";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._operationType = operation.getOperationType();
        this._collection = operation.getCollection();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkWrite;
    }

    @Override
    protected void createCommand() throws CommandException {
        this._dictionaryAddBuilder = DictionaryAddProtocol.DictionaryAdd.newBuilder();
        this._dictionaryAddBuilder.addAllKeys(this._collection.keySet());
        for (ExtendedJsonValueBase value : this._collection.values()) {
            CollectionItemProtocol.CollectionItem.Builder valueItemBuilder = CollectionItemProtocol.CollectionItem.newBuilder();
            for (byte[] bytes : value.toUserBinaryObject().getDataList()) {
                valueItemBuilder.addData(ByteString.copyFrom((byte[])bytes));
            }
            this._dictionaryAddBuilder.addValues(valueItemBuilder.build());
        }
        switch (this._operationType) {
            case Add: {
                this._dictionaryAddBuilder.setOperationType(DictionaryAddProtocol.DictionaryAdd.OperationType.Add);
                break;
            }
            case Insert: {
                this._dictionaryAddBuilder.setOperationType(DictionaryAddProtocol.DictionaryAdd.OperationType.Insert);
            }
        }
        super.createCommand();
        this._dictionaryCommandBuilder.setType(DictionaryCommandProtocol.DictionaryCommand.Type.DICTIONARY_ADD);
        this._dictionaryCommandBuilder.setDictionaryAdd(this._dictionaryAddBuilder);
    }
}

