/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.Dictionary.DictionaryRemoveOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.DictionaryCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.DictionaryCommandProtocol;
import com.alachisoft.ncache.common.protobuf.DictionaryRemoveProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;

public class DictionaryRemoveCommand
extends DictionaryCommandBase {
    private List<String> _collection;
    private Map.Entry<String, ExtendedJsonValueBase> _keyValuePair;
    private DictionaryRemoveOperation.OpType _operationType;
    private DictionaryRemoveProtocol.DictionaryRemove.Builder _dictionaryRemoveBuilder;

    public DictionaryRemoveCommand(DictionaryRemoveOperation operation) {
        this.name = "DictionaryRemove";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._operationType = operation.getOperationType();
        this._collection = operation.getCollection();
        this._keyValuePair = operation.getKeyValue();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicRead;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() throws CommandException {
        this._dictionaryRemoveBuilder = DictionaryRemoveProtocol.DictionaryRemove.newBuilder();
        switch (this._operationType) {
            case Remove: {
                this._dictionaryRemoveBuilder.addAllCollection(this._collection);
                this._dictionaryRemoveBuilder.setOperationType(DictionaryRemoveProtocol.DictionaryRemove.OperationType.Remove);
                break;
            }
            case KeyValueRemove: {
                this._dictionaryRemoveBuilder.setKey(this._keyValuePair.getKey());
                if (this._keyValuePair.getValue() != null) {
                    UserBinaryObject valueObject = UserBinaryObject.createUserBinaryObject((byte[])this._keyValuePair.getValue().toJson().getBytes(StandardCharsets.UTF_8));
                    CollectionItemProtocol.CollectionItem.Builder valueItemBuilder = CollectionItemProtocol.CollectionItem.newBuilder();
                    for (byte[] bytes : valueObject.getDataList()) {
                        valueItemBuilder.addData(ByteString.copyFrom((byte[])bytes));
                    }
                    this._dictionaryRemoveBuilder.setValue(valueItemBuilder);
                }
                this._dictionaryRemoveBuilder.setOperationType(DictionaryRemoveProtocol.DictionaryRemove.OperationType.KeyValueRemove);
            }
        }
        super.createCommand();
        this._dictionaryCommandBuilder.setType(DictionaryCommandProtocol.DictionaryCommand.Type.DICTIONARY_REMOVE);
        this._dictionaryCommandBuilder.setDictionaryRemove(this._dictionaryRemoveBuilder);
    }
}

