/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.BitSet;
import Alachisoft.NCache.Common.BitSetConstants;
import Alachisoft.NCache.Common.Locking.LockAccessType;
import com.alachisoft.ncache.client.internal.caching.CacheImpl;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.GetCommandProtocol;
import com.alachisoft.ncache.common.protobuf.LockInfoProtocol;
import com.alachisoft.ncache.runtime.caching.ReadMode;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.TimeSpan;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class GetCommand
extends Command {
    private final ReadMode _readMode;
    private final long _threadId;
    private final int _methodOveload;
    private String group;
    private String subGroup;
    private int flagMap;
    private LockAccessType _accessType;
    private String _lockId;
    private TimeSpan _lockTimeout;
    private long _version;
    private String providerName;
    protected GetCommandProtocol.GetCommand _commandInstance;

    public GetCommand(String key, BitSet flagMap, String group, LockAccessType accessType, String lockId, TimeSpan lockTimeout, long version, ReadMode readMode, String providerName, long threadId, int methodOverload) {
        this.name = "GetCommand";
        this.key = key;
        this.flagMap = BitSetConstants.getBitSetData((BitSet)flagMap);
        this.group = group;
        this._accessType = accessType;
        this._lockId = lockId;
        this._lockTimeout = lockTimeout;
        this._version = version;
        this._readMode = readMode;
        this.providerName = providerName;
        this._threadId = threadId;
        this._methodOveload = methodOverload;
    }

    @Override
    protected void createCommand() throws CommandException {
        if (this.key == null) {
            throw new NullPointerException("Key");
        }
        if (this.key.equals("")) {
            throw new IllegalArgumentException("key");
        }
        long ticks = 0L;
        if (this._lockTimeout != CacheImpl.NoLockingExpiration && (ticks = this._lockTimeout.getTotalTicks()) < 0L) {
            ticks = 0L;
        }
        GetCommandProtocol.GetCommand.Builder builder = GetCommandProtocol.GetCommand.newBuilder();
        builder = builder.setKey(this.key).setFlag(this.flagMap).setVersion(this._version).setRequestId(super.getRequestId()).setThreadId((int)this._threadId).setReadMode(this._readMode.getValue());
        LockInfoProtocol.LockInfo.Builder lockInfoBuilder = LockInfoProtocol.LockInfo.newBuilder();
        if (this._lockId != null) {
            lockInfoBuilder = lockInfoBuilder.setLockId(this._lockId);
        }
        lockInfoBuilder = lockInfoBuilder.setLockAccessType(this._accessType.getValue()).setLockTimeout(ticks);
        builder = builder.setLockInfo(lockInfoBuilder);
        if (this.group != null) {
            builder = builder.setGroup(this.group);
            if (this.subGroup != null) {
                builder = builder.setSubGroup(this.subGroup);
            }
        }
        if (this.providerName != null) {
            builder = builder.setProviderName(this.providerName);
        }
        this._commandInstance = builder.build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.GET;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicRead;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.GET.getNumber();
    }
}

