/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.HashSet.HashSetAddOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.HashSetCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.HashSetAddProtocol;
import com.alachisoft.ncache.common.protobuf.HashSetCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class HashSetAddCommand
extends HashSetCommandBase {
    private Set<ExtendedJsonValueBase> _collection;
    private HashSetAddProtocol.HashSetAdd.Builder _hashSetAddBuilder;

    public HashSetAddCommand(HashSetAddOperation operation) {
        this.name = "HashSetAdd";
        this.key = operation.getName();
        this._writeThruOption = operation.getWriteThruOptions();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._collection = operation.getCollection();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.KeyBulkWrite;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() throws CommandException {
        this._hashSetAddBuilder = HashSetAddProtocol.HashSetAdd.newBuilder();
        for (ExtendedJsonValueBase value : this._collection) {
            UserBinaryObject valueObject = UserBinaryObject.createUserBinaryObject((byte[])value.toJson().getBytes(StandardCharsets.UTF_8));
            CollectionItemProtocol.CollectionItem.Builder valueItemBuilder = CollectionItemProtocol.CollectionItem.newBuilder();
            for (byte[] bytes : valueObject.getDataList()) {
                valueItemBuilder.addData(ByteString.copyFrom((byte[])bytes));
            }
            this._hashSetAddBuilder.addValues(valueItemBuilder.build());
        }
        super.createCommand();
        this._hashSetCommandBuilder.setType(HashSetCommandProtocol.HashSetCommand.Type.HASHSET_ADD);
        this._hashSetCommandBuilder.setHashSetAdd(this._hashSetAddBuilder);
    }
}

