/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.ProductVersion;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.InitialCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.client.internal.communication.AddressUtil;
import com.alachisoft.ncache.client.internal.communication.ClientLicenseType;
import com.alachisoft.ncache.common.protobuf.ClientInfoProtocol;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.InitCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ProductVersionProtocol;
import com.alachisoft.ncache.licensing.LicenseInfo;
import com.alachisoft.ncache.licensing.LicenseManager;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.google.protobuf.ByteString;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public final class InitCommand
extends InitialCommandBase {
    private final boolean _isDotnetClient;
    private final boolean _secureConnectionEnabled;
    private String cacheId;
    private String _clientId;
    private byte[] _userName;
    private byte[] _password;
    private String _licenseCode = "";
    private String _clientEditionId;
    private ArrayList<String> macAddresses;
    private String _licenseInfoString;
    private LicenseInfo _LicenseInfo;
    private boolean _isBridgeClient;
    private ProductVersion _currentVersion;
    private ClientInfo _clientInfo;
    private int _operationTimeout;
    int _clientVersion;
    boolean _FromClientCache;

    public InitCommand(String clientId, String id, byte[] userName, byte[] password, String licenseCode, LicenseInfo info, boolean LicenseIsNull, boolean isBridgeClient, String clientLocalIP, InetAddress requestedServerAddress, ClientInfo clientInfo, ClientLicenseType clientType, boolean secureConnectionEnabled, int operationTimeout, boolean FromClientCache) {
        switch (LicenseManager.getNCacheBuildType()) {
            case ENT: 
            case CNT: {
                this.name = "InitCommand";
                this._clientEditionId = "INIT_NEW";
                break;
            }
            case ENTO: 
            case CNTO: {
                this.name = "InitCommand";
                switch (clientType) {
                    case EnterprisePaidClient: {
                        this._clientEditionId = "INIT";
                        break;
                    }
                    case EnterpriseFreeClient: {
                        this._clientEditionId = "INIT_NEW";
                    }
                }
                break;
            }
            case DEV: {
                this.name = "InitCommand";
                this._clientEditionId = "INIT_DEV";
                break;
            }
            case PDEV: {
                this.name = "InitCommand";
                this._clientEditionId = "INITPROF_DEV";
            }
        }
        this.verifyRemoteServer(requestedServerAddress);
        this._currentVersion = ProductVersion.getProductInfo();
        this.cacheId = id;
        this._userName = userName;
        this._password = password;
        this._clientId = clientId;
        this._licenseCode = licenseCode;
        this._isDotnetClient = false;
        this._isBridgeClient = isBridgeClient;
        this._clientInfo = new ClientInfo();
        this._clientInfo.setClientID(clientInfo.getClientID());
        this._clientInfo.setMachineName(clientInfo.getMachineName());
        this._clientInfo.setProcessID(clientInfo.getProcessID());
        this._clientInfo.setAppName(clientInfo.getAppName());
        this._clientInfo.setClientVersion(clientInfo.getClientVersion());
        this._clientInfo.setMacAddress(info != null ? info.getStringMacInfo() : null);
        this._clientInfo.setCores(info != null ? Integer.valueOf(info.getCores()) : null);
        this._LicenseInfo = info;
        this._licenseInfoString = !LicenseIsNull ? info.serialize() : "";
        this._secureConnectionEnabled = secureConnectionEnabled;
        this._operationTimeout = operationTimeout;
        this._clientVersion = 5000;
        this._FromClientCache = FromClientCache;
    }

    @Override
    public void createCommand() throws CommandException {
        try {
            this.GetMacAddresses();
        }
        catch (SocketException ex) {
            throw new CommandException(ex.getMessage());
        }
        ProductVersionProtocol.ProductVersion.Builder productVersionBuilder = ProductVersionProtocol.ProductVersion.newBuilder();
        productVersionBuilder.setAddiotionalData(ByteString.copyFrom((byte[])this._currentVersion.getAdditionalData())).setEditionID(this._currentVersion.getEditionID()).setMajorVersion1(this.parseToByteString(this._currentVersion.getMajorVersion1())).setMajorVersion2(this.parseToByteString(this._currentVersion.getMajorVersion2())).setMinorVersion1(this.parseToByteString(this._currentVersion.getMinorVersion1())).setMinorVersion2(this.parseToByteString(this._currentVersion.getMinorVersion2())).setProductName(this._currentVersion.getProductName());
        ClientInfoProtocol.ClientInfo.Builder clientInfoBuilder = ClientInfoProtocol.ClientInfo.newBuilder();
        clientInfoBuilder.setMachineName(this._clientInfo.getMachineName() != null ? this._clientInfo.getMachineName() : "").setProcessId(this._clientInfo.getProcessID()).setAppName(this._clientInfo.getAppName() != null ? this._clientInfo.getAppName() : "").setClientId(this._clientInfo.getClientID() != null ? this._clientInfo.getClientID() : "").setMacAddress(this._LicenseInfo != null ? this._LicenseInfo.getStringMacInfo() : "").setCores(this._LicenseInfo != null ? this._LicenseInfo.getCores() : -1);
        InitCommandProtocol.InitCommand.Builder initCoomandBuilder = InitCommandProtocol.InitCommand.newBuilder();
        initCoomandBuilder.setCacheId(this.cacheId).setRequestId(this.getRequestId()).setClientEditionId(this._clientEditionId).setClientId(this._clientId).setIsDotnetClient(this._isDotnetClient).setIsBridgeClient(false).setBinaryUserid(ByteString.copyFrom((byte[])this._userName)).setBinaryPwd(ByteString.copyFrom((byte[])this._password)).setLicenceCode(this._licenseCode).setLicenceInfo(this._licenseInfoString).setSecureConnectionEnabled(this._secureConnectionEnabled).setOperationTimeout(this._operationTimeout).setClientVersion(this._clientVersion).setFromClientCache(this._FromClientCache).setProductVersion(productVersionBuilder).setClientInfo(clientInfoBuilder);
        CommandProtocol.Command.Builder commandBuilder = CommandProtocol.Command.newBuilder();
        commandBuilder = commandBuilder.setInitCommand(initCoomandBuilder).setRequestID(this.getRequestId()).setType(CommandProtocol.Command.Type.INIT);
        this._command = commandBuilder.build();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.INIT;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.InternalCommand;
    }

    @Override
    public boolean getSupportsAacknowledgement() {
        return false;
    }

    private void GetMacAddresses() throws SocketException {
        String mac1 = "";
        String mac2 = "";
        String mac3 = "";
        String mac4 = "";
        Enumeration<NetworkInterface> networkInterface = NetworkInterface.getNetworkInterfaces();
        int counter = 1;
        while (networkInterface.hasMoreElements()) {
            NetworkInterface network = networkInterface.nextElement();
            byte[] macAddressBytes = network.getHardwareAddress();
            if (macAddressBytes == null) continue;
            StringBuilder macAddressStr = new StringBuilder();
            for (int i = 0; i < macAddressBytes.length; ++i) {
                macAddressStr.append(String.format("%02X", macAddressBytes[i]));
            }
            if (counter == 1) {
                mac1 = macAddressStr.toString().toLowerCase();
            }
            if (counter == 2) {
                mac2 = macAddressStr.toString().toLowerCase();
            }
            if (counter == 3) {
                mac3 = macAddressStr.toString().toLowerCase();
            }
            if (counter == 4) {
                mac4 = macAddressStr.toString().toLowerCase();
            }
            ++counter;
        }
        this.macAddresses = new ArrayList();
        this.macAddresses.add(mac1);
        this.macAddresses.add(mac2);
        this.macAddresses.add(mac3);
        this.macAddresses.add(mac4);
        Collections.sort(this.macAddresses);
    }

    private void verifyRemoteServer(InetAddress requestedServerAddress) {
        if (LicenseManager.getNCacheBuildType() == LicenseManager.BuildType.DEV && requestedServerAddress != null) {
            AddressUtil _addresUtil = new AddressUtil();
            _addresUtil.verifyLocalAddress(requestedServerAddress);
            if (!_addresUtil.getIsLocalAddres()) {
                this._clientEditionId = "INIT";
            }
        }
    }

    private ByteString parseToByteString(byte value) {
        byte[] tempArray = new byte[]{value};
        return ByteString.copyFrom((byte[])tempArray);
    }
}

