/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.List.ListSearchOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.ListCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.ListCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ListSearchProtocol;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;

public class ListSearchCommand
extends ListCommandBase {
    private ExtendedJsonValueBase _value;
    private ListSearchProtocol.ListSearch.Builder _listSearchCommandBuilder;

    public ListSearchCommand(ListSearchOperation operation) {
        this.name = "ListSearch";
        this.key = operation.getName();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._value = operation.getItem();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicRead;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() {
        this._listSearchCommandBuilder = ListSearchProtocol.ListSearch.newBuilder();
        UserBinaryObject ubObject = UserBinaryObject.createUserBinaryObject((byte[])this._value.toJson().getBytes(StandardCharsets.UTF_8));
        CollectionItemProtocol.CollectionItem.Builder cItem = CollectionItemProtocol.CollectionItem.newBuilder();
        for (byte[] value : ubObject.getDataList()) {
            cItem.addData(ByteString.copyFrom((byte[])value));
        }
        this._listSearchCommandBuilder.setItem(cItem);
        super.createCommand();
        this._listCommandBuilder.setType(ListCommandProtocol.ListCommand.Type.LIST_SEARCH);
        this._listCommandBuilder.setListSearch(this._listSearchCommandBuilder);
    }
}

