/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Common.Caching.UserBinaryObject;
import Alachisoft.NCache.Common.DataTypes.Queue.QueueSearchOperation;
import Alachisoft.NCache.Common.JSON.ExtendedJsonValueBase;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.QueueCommandBase;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CollectionItemProtocol;
import com.alachisoft.ncache.common.protobuf.QueueCommandProtocol;
import com.alachisoft.ncache.common.protobuf.QueueSerachProtocol;
import com.google.protobuf.ByteString;
import java.nio.charset.StandardCharsets;

public class QueueSearchCommand
extends QueueCommandBase {
    private ExtendedJsonValueBase _value;
    private QueueSerachProtocol.QueueSearch.Builder _queueSearch;

    public QueueSearchCommand(QueueSearchOperation operation) {
        this.name = "QueueSearch";
        this.key = operation.getName();
        this._lockId = (String)operation.getLockId();
        this._lockTimeout = operation.getLockTimeout();
        this._value = operation.getItem();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.AtomicRead;
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.DATA_TYPE;
    }

    @Override
    protected void createCommand() {
        this._queueSearch = QueueSerachProtocol.QueueSearch.newBuilder();
        if (this._value != null) {
            UserBinaryObject valueObject = UserBinaryObject.createUserBinaryObject((byte[])this._value.toJson().getBytes(StandardCharsets.UTF_8));
            CollectionItemProtocol.CollectionItem.Builder valueItem = CollectionItemProtocol.CollectionItem.newBuilder();
            for (byte[] bytes : valueObject.getDataList()) {
                valueItem.addData(ByteString.copyFrom((byte[])bytes));
            }
            this._queueSearch.setItem(valueItem);
        }
        super.createCommand();
        this._queueCommandBuilder.setType(QueueCommandProtocol.QueueCommand.Type.QUEUE_SEARCH);
        this._queueCommandBuilder.setQueueSearch(this._queueSearch);
    }
}

