/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.KeyValueProtocol;
import com.alachisoft.ncache.common.protobuf.SearchCommandProtocol;
import com.alachisoft.ncache.common.protobuf.ValueWithTypeProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import com.alachisoft.ncache.runtime.util.HelperFxn;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class SearchCommand
extends Command {
    private static char Delimitor = (char)124;
    private String query;
    private HashMap values;
    private boolean isSearchEntries;
    private int _commandVersion;
    private int _methodOverload = 0;
    protected SearchCommandProtocol.SearchCommand _commandInstance;

    public SearchCommand(String query, HashMap values, boolean isSearchEntries, boolean async) {
        this.query = query;
        this.values = values;
        this.isAsync = async;
        this.isSearchEntries = isSearchEntries;
    }

    @Override
    public void createCommand() throws CommandException {
        SearchCommandProtocol.SearchCommand.Builder builder = SearchCommandProtocol.SearchCommand.newBuilder();
        builder = builder.setRequestId(this.getRequestId()).setQuery(this.query).setSearchEntries(this.isSearchEntries);
        boolean totalValuesCount = false;
        Set keySet = this.values.keySet();
        Iterator iterator = keySet.iterator();
        while (iterator.hasNext()) {
            try {
                String typeKey = (String)iterator.next();
                KeyValueProtocol.KeyValue.Builder keyValPair = KeyValueProtocol.KeyValue.newBuilder();
                keyValPair = keyValPair.setKey(typeKey);
                if (this.values.get(typeKey) instanceof ArrayList) {
                    ArrayList list = (ArrayList)this.values.get(typeKey);
                    for (int i = 0; i < list.size(); ++i) {
                        Object typeValue = list.get(i);
                        keyValPair = keyValPair.addValue(ValueWithTypeProtocol.ValueWithType.newBuilder().setValue(this.getValueString(typeValue)).setType(typeValue.getClass().getName()).build());
                    }
                } else {
                    Object typeValue = this.values.get(typeKey);
                    keyValPair = keyValPair.addValue(ValueWithTypeProtocol.ValueWithType.newBuilder().setValue(this.getValueString(typeValue)).setType(typeValue.getClass().getName()).build());
                }
                builder = builder.addValues(keyValPair);
            }
            catch (CommandException cmE) {
                throw cmE;
            }
            catch (Exception e) {
                throw new CommandException("Error parsing values.");
            }
        }
        this._commandVersion = builder.getSearchEntries() ? 2 : 3;
        this._commandInstance = builder.setClientLastViewId(this.getClientLastViewId()).setCommandVersion(this._commandVersion).setMethodOverload(this._methodOverload).build();
    }

    private String getValueString(Object value) throws Exception {
        if (value == null) {
            throw new CommandException("NCache query does not support null values");
        }
        if (value instanceof String) {
            value = value.toString().toLowerCase();
        }
        if (value instanceof Date) {
            value = HelperFxn.getTicks((Date)((Date)value));
        }
        return value.toString();
    }

    @Override
    public CommandType getCommandType() {
        return CommandType.SEARCH;
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.NonKeyBulkRead;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.SEARCH.getNumber();
    }
}

