/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.command;

import Alachisoft.NCache.Caching.EventId;
import com.alachisoft.ncache.client.internal.command.Command;
import com.alachisoft.ncache.client.internal.command.CommandType;
import com.alachisoft.ncache.client.internal.command.RequestType;
import com.alachisoft.ncache.common.protobuf.CommandProtocol;
import com.alachisoft.ncache.common.protobuf.EventIdCommandProtocol;
import com.alachisoft.ncache.common.protobuf.SyncEventsCommandProtocol;
import com.alachisoft.ncache.runtime.exceptions.CommandException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;

public final class SyncEventsCommand
extends Command {
    private SyncEventsCommandProtocol.SyncEventsCommand.Builder _syncEventCommand;
    private EventIdCommandProtocol _eventIdCommand;
    protected SyncEventsCommandProtocol.SyncEventsCommand _commandInstance;

    public SyncEventsCommand(ArrayList<EventId> eventIds) {
        this.name = "SyncEventsCommand";
        this._syncEventCommand = SyncEventsCommandProtocol.SyncEventsCommand.newBuilder();
        this._syncEventCommand.setRequestId(super.getRequestId());
        for (EventId eventId : eventIds) {
            EventIdCommandProtocol.EventIdCommand.Builder _eventIdCommand = EventIdCommandProtocol.EventIdCommand.newBuilder();
            _eventIdCommand.setEventType(eventId.getEventType().getValue());
            _eventIdCommand.setEventUniqueId(eventId.getEventUniqueID());
            _eventIdCommand.setEventCounter(eventId.getEventCounter());
            _eventIdCommand.setOperationCounter(eventId.getOperationCounter());
            _eventIdCommand.setQueryChangeType(eventId.getQueryChangeType().getValue());
            _eventIdCommand.setQueryId(eventId.getQueryId());
            this._syncEventCommand.addEventIds(_eventIdCommand);
        }
    }

    @Override
    public CommandType getCommandType() {
        this.getCommandType();
        return CommandType.SYNC_EVENTS;
    }

    @Override
    protected void createCommand() throws CommandException {
        CommandProtocol.Command.Builder commandBuilder = CommandProtocol.Command.newBuilder();
        commandBuilder.setRequestID(this.getRequestId());
        commandBuilder.setSyncEventsCommand(this._syncEventCommand);
        commandBuilder.setType(CommandProtocol.Command.Type.SYNC_EVENTS);
        this._commandInstance = this._syncEventCommand.build();
    }

    @Override
    public RequestType getCommandRequestType() {
        return RequestType.InternalCommand;
    }

    @Override
    protected void serializeCommandInternal(ByteArrayOutputStream stream) throws IOException {
        this._commandInstance.writeTo((OutputStream)stream);
    }

    @Override
    protected short getCommandHandle() {
        return (short)CommandProtocol.Command.Type.SYNC_EVENTS.getNumber();
    }
}

