/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Caching.EventId;
import Alachisoft.NCache.Caching.OpCode;
import Alachisoft.NCache.Common.Net.Address;
import Alachisoft.NCache.Common.Threading.AsyncProcessor;
import Alachisoft.NCache.Management.Statistics.StatisticsCounter;
import com.alachisoft.ncache.client.ClientInfo;
import com.alachisoft.ncache.client.ConnectivityStatus;
import com.alachisoft.ncache.client.internal.asynctasks.ClientConnectivityChangeTask;
import com.alachisoft.ncache.client.internal.caching.EventTypeInternal;
import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.common.protobuf.BulkEventItemResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ClientConnectivityChangeEventResponseProtocol;
import com.alachisoft.ncache.common.protobuf.ClientInfoProtocol;
import com.alachisoft.ncache.common.protobuf.DSUpdatedCallbackResultProtocol;
import com.alachisoft.ncache.runtime.caching.WriteBehindOpResult;
import com.alachisoft.ncache.runtime.caching.WriteBehindOpStatus;
import com.alachisoft.ncache.runtime.events.EventType;
import com.alachisoft.ncache.runtime.exceptions.OperationFailedException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;

public class BulkEventStructure
implements Runnable {
    public Address remoteServerAddress = null;
    public List<BulkEventItemResponseProtocol.BulkEventItemResponse> bulkEventList;
    public Broker parent;
    public StatisticsCounter _perfStatsCollector;
    boolean _notifyAsync;
    private AsyncProcessor _eventProcessor = null;

    public BulkEventStructure(Address remoteServerAddress, List<BulkEventItemResponseProtocol.BulkEventItemResponse> bulkEventList, Broker parent, StatisticsCounter _perfStatsCollector, AsyncProcessor _eventProcessor, boolean _notifyAsync) {
        this.remoteServerAddress = remoteServerAddress;
        this.bulkEventList = bulkEventList;
        this.parent = parent;
        this._perfStatsCollector = _perfStatsCollector;
        this._eventProcessor = _eventProcessor;
        this._notifyAsync = _notifyAsync;
    }

    @Override
    public void run() {
        this.RaiseBulkEvent();
    }

    private void RaiseBulkEvent() {
        try {
            for (BulkEventItemResponseProtocol.BulkEventItemResponse eventItem : this.bulkEventList) {
                try {
                    if (this._perfStatsCollector != null) {
                        this._perfStatsCollector.incrementEventsTriggeredPerSeconds();
                    }
                    EventId eventId = new EventId();
                    switch (eventItem.getEventType()) {
                        case POLL_NOTIFY_EVENT: {
                            this.parent.getCache().getEventsListener().OnPollNotified((short)eventItem.getPollNotifyEvent().getCallbackId(), EventTypeInternal.forValue(eventItem.getPollNotifyEvent().getEventType()));
                            break;
                        }
                        case CACHE_CLEARED_EVENT: {
                            eventId = new EventId();
                            eventId.setEventUniqueID(eventItem.getCacheClearedEvent().getEventId().getEventUniqueId());
                            eventId.setEventCounter(eventItem.getCacheClearedEvent().getEventId().getEventCounter());
                            eventId.setOperationCounter(eventItem.getCacheClearedEvent().getEventId().getOperationCounter());
                            eventId.setEventType(Alachisoft.NCache.Persistence.EventType.CACHE_CLEARED_EVENT);
                            if (!this._notifyAsync) break;
                            this.parent.getCache().getEventsListener().OnCacheCleared(this._notifyAsync);
                            break;
                        }
                        case DS_UPDATED_CALLBACK: {
                            int _opCode = eventItem.getDSUpdatedCallback().getOpCode();
                            OpCode operationCode = OpCode.forValue((int)_opCode);
                            EventType eventType = EventType.getEventType((int)_opCode);
                            HashMap<String, WriteBehindOpResult> resultDic = new HashMap<String, WriteBehindOpResult>();
                            for (DSUpdatedCallbackResultProtocol.DSUpdatedCallbackResult result : eventItem.getDSUpdatedCallback().getResultList()) {
                                WriteBehindOpResult writeBehindOpResult;
                                if (result.getSuccess()) {
                                    writeBehindOpResult = new WriteBehindOpResult(eventType, WriteBehindOpStatus.Success, null);
                                } else if (result.getException() != null) {
                                    OperationFailedException exception = new OperationFailedException(result.getException().getErrorCode(), result.getException().getMessage());
                                    writeBehindOpResult = new WriteBehindOpResult(eventType, WriteBehindOpStatus.Failure, (Exception)((Object)exception));
                                } else {
                                    writeBehindOpResult = new WriteBehindOpResult(eventType, WriteBehindOpStatus.Failure, null);
                                }
                                resultDic.put(result.getKey(), writeBehindOpResult);
                            }
                            if (this._notifyAsync && this.parent.getCache() != null && this.parent.getCache().getEventsListener() != null) {
                                this.parent.getCache().getAsyncEventListener().onDataSourceUpdated((short)eventItem.getDSUpdatedCallback().getCallbackId(), resultDic, operationCode, this._notifyAsync);
                            }
                        }
                        case CLIENT_CONNECTIVITY: {
                            ClientConnectivityChangeEventResponseProtocol.ClientConnectivityChangeEventResponse eventResponse = eventItem.getClientConnectivityChangeEvent();
                            ClientInfoProtocol.ClientInfo clientInfoProto = eventResponse.getClientInfo();
                            ClientInfo clientInfo = new ClientInfo();
                            clientInfo.setProcessID(clientInfoProto.getProcessId());
                            clientInfo.setAppName(clientInfoProto.getAppName());
                            clientInfo.setClientID(clientInfoProto.getClientId());
                            clientInfo.setMachineName(clientInfoProto.getMachineName());
                            try {
                                clientInfo.setiPAddress(InetAddress.getByName(clientInfoProto.getIpAddress()));
                            }
                            catch (UnknownHostException unknownHostException) {
                                // empty catch block
                            }
                            clientInfo.setStatus(ConnectivityStatus.forValue(eventResponse.getStatus()));
                            if (this._notifyAsync) {
                                if (this.parent == null || this.parent.getCache() == null || this.parent.getCache().getEventsListener() == null) break;
                                this.parent.getCache().getEventsListener().OnClientConnectivityChange(eventResponse.getCacheId(), clientInfo, ConnectivityStatus.forValue(eventResponse.getStatus()));
                                break;
                            }
                            this._eventProcessor.Enqueue((AsyncProcessor.IAsyncTask)new ClientConnectivityChangeTask(this.parent, eventResponse.getCacheId(), clientInfo, ConnectivityStatus.forValue(eventResponse.getStatus())));
                        }
                    }
                }
                catch (RuntimeException ex) {
                    if (!this.parent.getLogger().getIsErrorLogsEnabled()) continue;
                    this.parent.getLogger().getNCacheLog().Error("Broker.RaiseBulkEvent", "An error occurred while raising bulk event of type : " + eventItem.getEventType() + ". Error :" + ex.toString());
                }
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }
}

