/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import com.alachisoft.ncache.client.internal.command.CommandResponse;
import com.alachisoft.ncache.client.internal.command.PingCommand;
import com.alachisoft.ncache.client.internal.communication.Broker;
import com.alachisoft.ncache.client.internal.communication.Connection;
import com.alachisoft.ncache.client.internal.communication.Request;
import java.util.HashSet;

final class ConnectionKeepAlive {
    boolean isThreadStop = false;
    private int _interval;
    private Broker _enclosure;
    private HashSet<Connection> _idleConnections;
    private Thread _activityPerformer;

    public ConnectionKeepAlive(Broker encloser, int interval) {
        this._enclosure = encloser;
        this._interval = interval;
        this._idleConnections = new HashSet();
    }

    public void Start() {
        if (this._activityPerformer != null) {
            return;
        }
        this._activityPerformer = new Thread(() -> this.Run());
        this._activityPerformer.setDaemon(true);
        this._activityPerformer.setName(String.join((CharSequence)this._enclosure.getCache().getName(), ":KeepAlivePerformer"));
        this._activityPerformer.start();
    }

    public void Stop() {
        if (this._activityPerformer == null) {
            return;
        }
        this.isThreadStop = true;
        this._activityPerformer.interrupt();
        this._activityPerformer = null;
    }

    private void Run() {
        block5: {
            try {
                while (!this.isThreadStop) {
                    this.MarkConnectionsIdle();
                    Thread.sleep(this._interval * 1000);
                    this.PopulateIdleList();
                    this.PingIdleList();
                }
            }
            catch (InterruptedException e) {
                if (this._enclosure.getLogger() != null && this._enclosure.getLogger().getIsDetailedLogsEnabled()) {
                    this._enclosure.getLogger().getNCacheLog().Info("Broker.ConnectionKeepAlive.Run", " The activity performing thread is stopping...");
                }
            }
            catch (RuntimeException ex) {
                if (this._enclosure.getLogger() == null || !this._enclosure.getLogger().getIsErrorLogsEnabled()) break block5;
                this._enclosure.getLogger().getNCacheLog().Error("Broker.ConnectionKeepAlive.Run", " The activity performing thread has been terminated due to the problem: " + ex);
            }
        }
    }

    private void MarkConnectionsIdle() {
        if (this._enclosure.getConnection() != null) {
            this._enclosure.getConnection().setIsIdle(true);
        }
        if (this._enclosure.getPool() != null) {
            this._enclosure.getPool().MarkConnectionsIdle();
        }
    }

    private void PopulateIdleList() {
        if (this._enclosure.getConnection() != null && this._enclosure.getConnection().getIsIdle()) {
            this._idleConnections.add(this._enclosure.getConnection());
        }
        if (this._enclosure.getPool() != null) {
            for (Connection connection : this._enclosure.getPool().GetIdleConnections()) {
                if (this._idleConnections.contains(connection)) continue;
                this._idleConnections.add(connection);
            }
        }
    }

    private void PingIdleList() {
        for (Connection connection : this._idleConnections) {
            this.SendPing(connection, false, true, false);
        }
        this._idleConnections.clear();
    }

    private void SendPing(Connection connection, boolean waitforReponse, boolean hasResponse, boolean isAsync) {
        block4: {
            try {
                if (this._enclosure.getLogger() != null && this._enclosure.getLogger().getIsDetailedLogsEnabled()) {
                    this._enclosure.getLogger().getNCacheLog().Info("Broker.ConnectionKeepAlive.SendPing", "Sending PingCommand to Server: " + connection.getIpAddress());
                }
                PingCommand command = new PingCommand(hasResponse, isAsync);
                Request request = new Request(false, this._enclosure.getOperationTimeout());
                request.addCommand(connection.getServerAddress(), command);
                this._enclosure.executeRequest(request, connection, true, waitforReponse);
                if (waitforReponse) {
                    CommandResponse reponse = request.getResponse();
                    reponse.parseResponse();
                }
            }
            catch (Exception ex) {
                if (this._enclosure.getLogger() == null || !this._enclosure.getLogger().getIsErrorLogsEnabled()) break block4;
                this._enclosure.getLogger().getNCacheLog().Error("Broker.ConnectionKeepAlive.SendPing", "Problem occured: " + ex);
            }
        }
    }
}

