/*
 * Decompiled with CFR 0.152.
 */
package com.alachisoft.ncache.client.internal.communication;

import Alachisoft.NCache.Common.Communication.IChannelFormatter;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IMethodArgumentPartitioner;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCCallBuilder;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCConstructorCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCMethodCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IRPCPropertyCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.IResponseConsolidator;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Impl.MultiPartitionMethodCall;
import Alachisoft.NCache.Common.Extensibility.Client.RPC.Partition;
import com.alachisoft.ncache.client.internal.communication.DistributedConstructorCall;
import com.alachisoft.ncache.client.internal.communication.DistributedMethodCall;
import com.alachisoft.ncache.client.internal.communication.DistributedPropertyCall;
import com.alachisoft.ncache.client.internal.communication.RPCTransport;
import java.util.Map;

class DistributedCallBuilder
implements IRPCCallBuilder {
    private RPCTransport _tranport;
    private IChannelFormatter _formtter;

    public DistributedCallBuilder(RPCTransport transport, IChannelFormatter formatter) {
        this._formtter = formatter;
        this._tranport = transport;
    }

    public final IRPCConstructorCall BuildConstructorCall(Class objectType, String objectUID, Object[] arguments) {
        DistributedConstructorCall constructorCall = new DistributedConstructorCall(this._tranport, this._formtter);
        constructorCall.SetObjectUid(objectUID);
        constructorCall.SetObjectType(objectType);
        for (Partition partition : this._tranport.GetPartitioningStrategy().GetAllPartitions()) {
            constructorCall.AddArguments(partition, arguments);
        }
        return constructorCall;
    }

    public final IRPCMethodCall BuildMethodCall(Class serverInstanceType, String method, int overload, boolean isStatic, Object[] arguments, String objectUID, IMethodArgumentPartitioner argumentPartitioner, IResponseConsolidator consolidator) {
        DistributedMethodCall methodCall = new DistributedMethodCall(this._tranport, this._formtter);
        methodCall.method = method;
        methodCall.overload = overload;
        methodCall.objectUID = objectUID;
        methodCall.consolidator = consolidator;
        methodCall.isStatic = isStatic;
        methodCall.instanceType = serverInstanceType;
        if (argumentPartitioner != null) {
            Iterable partitionWiseArguments = argumentPartitioner.PartitionArguments(arguments, this._tranport.GetPartitioningStrategy());
            for (Map.Entry partitionArguments : partitionWiseArguments) {
                methodCall.AddArguments((Partition)partitionArguments.getKey(), partitionArguments.getValue());
            }
        }
        return methodCall;
    }

    public final MultiPartitionMethodCall BuildMultipartionMethodCall(String method, int overload, Object[] arguments, String objectUID) {
        throw new UnsupportedOperationException();
    }

    public final IRPCPropertyCall BuildPropertyGetterCall(String property, String objectUID) {
        return this.BuildPropertyCallInternal(property, objectUID);
    }

    public final IRPCPropertyCall BuildPropertySetterCall(String property, Object value, String objectUID) {
        IRPCPropertyCall propertyCall = this.BuildPropertyCallInternal(property, objectUID, value);
        propertyCall.setIsSetterCall(true);
        return propertyCall;
    }

    private IRPCPropertyCall BuildPropertyCallInternal(String property, String objectUID) {
        return this.BuildPropertyCallInternal(property, objectUID, null);
    }

    private IRPCPropertyCall BuildPropertyCallInternal(String property, String objectUID, Object value) {
        DistributedPropertyCall propertyCall = new DistributedPropertyCall(this._tranport, this._formtter);
        propertyCall.setObjectUID(objectUID);
        propertyCall.setProperty(property);
        for (Partition partition : this._tranport.GetPartitioningStrategy().GetAllPartitions()) {
            propertyCall.AddArguments(partition, value);
        }
        return propertyCall;
    }
}

